/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.ranger.authorizer;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.security.ranger.authorizer.RangerAuthorizer;
import org.apache.druid.security.ranger.authorizer.guice.Ranger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class RangerSecurityDruidModule
implements DruidModule {
    private Properties props = null;

    public void configure(Binder binder) {
        Configuration conf = new Configuration();
        conf.setClassLoader(this.getClass().getClassLoader());
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            FileSystem.get((Configuration)conf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
        if (this.props != null) {
            for (String propName : this.props.stringPropertyNames()) {
                if (!propName.startsWith("hadoop.")) continue;
                conf.set(propName.substring("hadoop.".length()), this.props.getProperty(propName));
            }
        }
        binder.bind(Configuration.class).annotatedWith(Ranger.class).toInstance((Object)conf);
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new SimpleModule("RangerDruidSecurity").registerSubtypes(new Class[]{RangerAuthorizer.class}));
    }

    @Inject
    public void setProperties(Properties props) {
        this.props = props;
    }
}

