/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.kerberos;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.net.CookieManager;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.AbstractHttpClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.security.kerberos.DruidKerberosUtil;
import org.apache.druid.security.kerberos.ResponseCookieHandler;
import org.apache.druid.security.kerberos.RetryIfUnauthorizedResponseHandler;
import org.apache.druid.security.kerberos.RetryResponseHolder;
import org.apache.hadoop.security.UserGroupInformation;
import org.joda.time.Duration;

public class KerberosHttpClient
extends AbstractHttpClient {
    private static final Logger log = new Logger(KerberosHttpClient.class);
    private final HttpClient delegate;
    private final CookieManager cookieManager;
    private final ExecutorService exec = Execs.singleThreaded((String)"test-%s");
    private final String internalClientPrincipal;
    private final String internalClientKeytab;

    public KerberosHttpClient(HttpClient delegate, String internalClientPrincipal, String internalClientKeytab) {
        this.delegate = delegate;
        this.cookieManager = new CookieManager();
        this.internalClientPrincipal = internalClientPrincipal;
        this.internalClientKeytab = internalClientKeytab;
    }

    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler, Duration duration) {
        SettableFuture retVal = SettableFuture.create();
        this.inner_go(request, httpResponseHandler, duration, retVal);
        return retVal;
    }

    private <Intermediate, Final> void inner_go(final Request request, final HttpResponseHandler<Intermediate, Final> httpResponseHandler, final Duration duration, final SettableFuture<Final> future) {
        try {
            boolean should_retry_on_unauthorized_response;
            final String host = request.getUrl().getHost();
            final URI uri = request.getUrl().toURI();
            Map<String, List<String>> cookieMap = this.cookieManager.get(uri, Collections.emptyMap());
            for (Map.Entry<String, List<String>> entry : cookieMap.entrySet()) {
                request.addHeaderValues(entry.getKey(), (Iterable)entry.getValue());
            }
            if (DruidKerberosUtil.needToSendCredentials(this.cookieManager.getCookieStore(), uri)) {
                log.debug("No Auth Cookie found for URI[%s]. Existing Cookies[%s] Authenticating... ", new Object[]{uri, this.cookieManager.getCookieStore().getCookies()});
                DruidKerberosUtil.authenticateIfRequired(this.internalClientPrincipal, this.internalClientKeytab);
                UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                String challenge = (String)currentUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return DruidKerberosUtil.kerberosChallenge(host);
                    }
                });
                request.setHeader("Authorization", "Negotiate " + challenge);
                should_retry_on_unauthorized_response = false;
            } else {
                should_retry_on_unauthorized_response = true;
                log.debug("Found Auth Cookie found for URI[%s].", new Object[]{uri});
            }
            ListenableFuture internalFuture = this.delegate.go(request, new RetryIfUnauthorizedResponseHandler<Intermediate, Final>(new ResponseCookieHandler<Intermediate, Final>(request.getUrl().toURI(), this.cookieManager, httpResponseHandler)), duration);
            Futures.addCallback((ListenableFuture)internalFuture, (FutureCallback)new FutureCallback<RetryResponseHolder<Final>>(){

                public void onSuccess(RetryResponseHolder<Final> result) {
                    if (should_retry_on_unauthorized_response && result.shouldRetry()) {
                        log.info("Preparing for Retry", new Object[0]);
                        DruidKerberosUtil.removeAuthCookie(KerberosHttpClient.this.cookieManager.getCookieStore(), uri);
                        request.setHeader("Cookie", "");
                        KerberosHttpClient.this.inner_go(request.copy(), httpResponseHandler, duration, future);
                    } else {
                        log.debug("Not retrying and returning future response", new Object[0]);
                        future.set(result.getObj());
                    }
                }

                public void onFailure(Throwable t) {
                    future.setException(t);
                }
            }, (Executor)this.exec);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

