/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public class KafkaConsumerMonitor
extends AbstractMonitor {
    private volatile boolean stopAfterNext = false;
    private static final Map<String, String> METRICS = ImmutableMap.builder().put((Object)"bytes-consumed-total", (Object)"kafka/consumer/bytesConsumed").put((Object)"records-consumed-total", (Object)"kafka/consumer/recordsConsumed").build();
    private static final String TOPIC_TAG = "topic";
    private static final Set<String> TOPIC_METRIC_TAGS = ImmutableSet.of((Object)"client-id", (Object)"topic");
    private final KafkaConsumer<?, ?> consumer;
    private final Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();

    public KafkaConsumerMonitor(KafkaConsumer<?, ?> consumer) {
        this.consumer = consumer;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        for (Map.Entry entry : this.consumer.metrics().entrySet()) {
            long priorValue;
            MetricName metricName = (MetricName)entry.getKey();
            if (!METRICS.containsKey(metricName.name()) || !KafkaConsumerMonitor.isTopicMetric(metricName)) continue;
            String topic = (String)metricName.tags().get(TOPIC_TAG);
            long newValue = ((Number)((Metric)entry.getValue()).metricValue()).longValue();
            if (newValue == (priorValue = this.counters.computeIfAbsent(metricName.name(), ignored -> new AtomicLong()).getAndSet(newValue))) continue;
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension(TOPIC_TAG, (Object)topic);
            emitter.emit((ServiceEventBuilder)builder.setMetric(METRICS.get(metricName.name()), (Number)(newValue - priorValue)));
        }
        return !this.stopAfterNext;
    }

    public void stopAfterNextEmit() {
        this.stopAfterNext = true;
    }

    private static boolean isTopicMetric(MetricName metricName) {
        return TOPIC_METRIC_TAGS.equals(metricName.tags().keySet()) && !Strings.isNullOrEmpty((String)((String)metricName.tags().get(TOPIC_TAG)));
    }
}

