/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the condition of a component.")
public class V1ComponentCondition {
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private String error;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1ComponentCondition error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Condition error code for a component. For example, a health check error code.")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public V1ComponentCondition message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Message about the condition for a component. For example, information about a health check.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1ComponentCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the condition for a component. Valid values for \"Healthy\": \"True\", \"False\", or \"Unknown\".")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V1ComponentCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of condition for a component. Valid value: \"Healthy\"")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ComponentCondition v1ComponentCondition = (V1ComponentCondition)o;
        return Objects.equals(this.error, v1ComponentCondition.error) && Objects.equals(this.message, v1ComponentCondition.message) && Objects.equals(this.status, v1ComponentCondition.status) && Objects.equals(this.type, v1ComponentCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.message, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ComponentCondition {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

