/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.AbstractExceptionAwareLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.NoContentAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogoutLogic<R, C extends WebContext>
extends AbstractExceptionAwareLogic<R, C>
implements LogoutLogic<R, C> {
    public static final DefaultLogoutLogic INSTANCE = new DefaultLogoutLogic();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLogoutLogic.class);

    @Override
    public R perform(C context, Config config, HttpActionAdapter<R, C> httpActionAdapter, String defaultUrl, String inputLogoutUrlPattern, Boolean inputLocalLogout, Boolean inputDestroySession, Boolean inputCentralLogout) {
        HttpAction action;
        block9: {
            LOGGER.debug("=== LOGOUT ===");
            try {
                String logoutUrlPattern = inputLogoutUrlPattern == null ? "^(\\/|\\/[^\\/].*)$" : inputLogoutUrlPattern;
                boolean localLogout = inputLocalLogout == null || inputLocalLogout != false;
                boolean destroySession = inputDestroySession != null && inputDestroySession != false;
                boolean centralLogout = inputCentralLogout != null && inputCentralLogout != false;
                CommonHelper.assertNotNull("context", context);
                CommonHelper.assertNotNull("config", config);
                CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
                CommonHelper.assertNotBlank("logoutUrlPattern", logoutUrlPattern);
                Clients configClients = config.getClients();
                CommonHelper.assertNotNull("configClients", configClients);
                ProfileManager<UserProfile> manager = this.getProfileManager(context);
                manager.setConfig(config);
                List<UserProfile> profiles = manager.getAll(true);
                Optional<String> url = context.getRequestParameter("url");
                String redirectUrl = defaultUrl;
                if (url.isPresent() && Pattern.matches(logoutUrlPattern, url.get())) {
                    redirectUrl = url.get();
                }
                LOGGER.debug("redirectUrl: {}", (Object)redirectUrl);
                action = redirectUrl != null ? RedirectionActionHelper.buildRedirectUrlAction(context, redirectUrl) : NoContentAction.INSTANCE;
                if (localLogout || profiles.size() > 1) {
                    LOGGER.debug("Performing application logout");
                    manager.logout();
                    if (destroySession) {
                        SessionStore sessionStore = context.getSessionStore();
                        if (sessionStore != null) {
                            boolean removed = sessionStore.destroySession(context);
                            if (!removed) {
                                LOGGER.error("Unable to destroy the web session. The session store may not support this feature");
                            }
                        } else {
                            LOGGER.error("No session store available for this web context");
                        }
                    }
                }
                if (!centralLogout) break block9;
                LOGGER.debug("Performing central logout");
                for (UserProfile profile : profiles) {
                    Optional<Client> client;
                    LOGGER.debug("Profile: {}", (Object)profile);
                    String clientName = profile.getClientName();
                    if (clientName == null || !(client = configClients.findClient(clientName)).isPresent()) continue;
                    String targetUrl = redirectUrl != null && (redirectUrl.startsWith("http") || redirectUrl.startsWith("https")) ? redirectUrl : null;
                    Optional<RedirectionAction> logoutAction = client.get().getLogoutAction((WebContext)context, profile, targetUrl);
                    LOGGER.debug("Logout action: {}", logoutAction);
                    if (!logoutAction.isPresent()) continue;
                    action = logoutAction.get();
                    break;
                }
            }
            catch (RuntimeException e) {
                return this.handleException(e, httpActionAdapter, context);
            }
        }
        return httpActionAdapter.adapt(action, context);
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "errorUrl", this.getErrorUrl());
    }
}

