/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecs;
import org.apache.druid.msq.input.external.ExternalInputSpec;
import org.apache.druid.msq.input.inline.InlineInputSpec;
import org.apache.druid.msq.input.lookup.LookupInputSpec;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.msq.kernel.HashShuffleSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageDefinitionBuilder;
import org.apache.druid.msq.querykit.InputNumberDataSource;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.msq.querykit.common.SortMergeJoinFrameProcessorFactory;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.joda.time.Interval;

public class DataSourcePlan {
    private static final Map<String, Object> CONTEXT_MAP_NO_SEGMENT_GRANULARITY = new HashMap<String, Object>();
    private static final Logger log = new Logger(DataSourcePlan.class);
    private final DataSource newDataSource;
    private final List<InputSpec> inputSpecs;
    private final IntSet broadcastInputs;
    @Nullable
    private final QueryDefinitionBuilder subQueryDefBuilder;

    DataSourcePlan(DataSource newDataSource, List<InputSpec> inputSpecs, IntSet broadcastInputs, @Nullable QueryDefinitionBuilder subQueryDefBuilder) {
        this.newDataSource = (DataSource)Preconditions.checkNotNull((Object)newDataSource, (Object)"newDataSource");
        this.inputSpecs = (List)Preconditions.checkNotNull(inputSpecs, (Object)"inputSpecs");
        this.broadcastInputs = (IntSet)Preconditions.checkNotNull((Object)broadcastInputs, (Object)"broadcastInputs");
        this.subQueryDefBuilder = subQueryDefBuilder;
        IntIterator intIterator = broadcastInputs.iterator();
        while (intIterator.hasNext()) {
            int broadcastInput = (Integer)intIterator.next();
            if (broadcastInput >= 0 && broadcastInput < inputSpecs.size()) continue;
            throw new IAE("Broadcast input number [%d] out of range [0, %d)", new Object[]{broadcastInput, inputSpecs.size()});
        }
    }

    public static DataSourcePlan forDataSource(QueryKitSpec queryKitSpec, QueryContext queryContext, DataSource dataSource, QuerySegmentSpec querySegmentSpec, @Nullable DimFilter filter, @Nullable Set<String> filterFields, int minStageNumber, boolean broadcast) {
        if (!queryContext.isSecondaryPartitionPruningEnabled()) {
            filter = null;
            filterFields = null;
        }
        if (filter != null && filterFields == null) {
            filterFields = filter.getRequiredColumns();
        }
        if (dataSource instanceof TableDataSource) {
            return DataSourcePlan.forTable((TableDataSource)dataSource, DataSourcePlan.querySegmentSpecIntervals(querySegmentSpec), filter, filterFields, broadcast);
        }
        if (dataSource instanceof ExternalDataSource) {
            DataSourcePlan.checkQuerySegmentSpecIsEternity(dataSource, querySegmentSpec);
            return DataSourcePlan.forExternal((ExternalDataSource)dataSource, broadcast);
        }
        if (dataSource instanceof InlineDataSource) {
            DataSourcePlan.checkQuerySegmentSpecIsEternity(dataSource, querySegmentSpec);
            return DataSourcePlan.forInline((InlineDataSource)dataSource, broadcast);
        }
        if (dataSource instanceof LookupDataSource) {
            return DataSourcePlan.forLookup((LookupDataSource)dataSource, broadcast);
        }
        if (dataSource instanceof FilteredDataSource) {
            return DataSourcePlan.forFilteredDataSource(queryKitSpec, queryContext, (FilteredDataSource)dataSource, querySegmentSpec, minStageNumber, broadcast);
        }
        if (dataSource instanceof UnnestDataSource) {
            return DataSourcePlan.forUnnest(queryKitSpec, queryContext, (UnnestDataSource)dataSource, querySegmentSpec, minStageNumber, broadcast);
        }
        if (dataSource instanceof QueryDataSource) {
            DataSourcePlan.checkQuerySegmentSpecIsEternity(dataSource, querySegmentSpec);
            return DataSourcePlan.forQuery(queryKitSpec, (QueryDataSource)dataSource, minStageNumber, broadcast);
        }
        if (dataSource instanceof UnionDataSource) {
            return DataSourcePlan.forUnion(queryKitSpec, queryContext, (UnionDataSource)dataSource, querySegmentSpec, filter, filterFields, minStageNumber, broadcast);
        }
        if (dataSource instanceof JoinDataSource) {
            JoinDataSource joinDataSource = (JoinDataSource)dataSource;
            JoinAlgorithm preferredJoinAlgorithm = joinDataSource.getJoinAlgorithm();
            JoinAlgorithm deducedJoinAlgorithm = DataSourcePlan.deduceJoinAlgorithm(preferredJoinAlgorithm, joinDataSource);
            switch (deducedJoinAlgorithm) {
                case BROADCAST: {
                    return DataSourcePlan.forBroadcastHashJoin(queryKitSpec, queryContext, joinDataSource, querySegmentSpec, filter, filterFields, minStageNumber, broadcast);
                }
                case SORT_MERGE: {
                    return DataSourcePlan.forSortMergeJoin(queryKitSpec, joinDataSource, querySegmentSpec, minStageNumber, broadcast);
                }
            }
            throw new UOE("Cannot handle join algorithm [%s]", new Object[]{deducedJoinAlgorithm});
        }
        throw new UOE("Cannot handle dataSource [%s]", new Object[]{dataSource});
    }

    public DataSource getNewDataSource() {
        return this.newDataSource;
    }

    public List<InputSpec> getInputSpecs() {
        return this.inputSpecs;
    }

    public IntSet getBroadcastInputs() {
        return this.broadcastInputs;
    }

    public int getMaxWorkerCount(QueryKitSpec queryKitSpec) {
        if (this.isSingleWorker()) {
            return 1;
        }
        if (InputSpecs.hasLeafInputs(this.inputSpecs, this.broadcastInputs)) {
            return queryKitSpec.getMaxLeafWorkerCount();
        }
        return queryKitSpec.getMaxNonLeafWorkerCount();
    }

    public Optional<QueryDefinitionBuilder> getSubQueryDefBuilder() {
        return Optional.ofNullable(this.subQueryDefBuilder);
    }

    private static JoinAlgorithm deduceJoinAlgorithm(JoinAlgorithm preferredJoinAlgorithm, JoinDataSource joinDataSource) {
        JoinAlgorithm deducedJoinAlgorithm = JoinAlgorithm.BROADCAST.equals((Object)preferredJoinAlgorithm) ? JoinAlgorithm.BROADCAST : (DataSourcePlan.canUseSortMergeJoin(joinDataSource.getConditionAnalysis()) ? JoinAlgorithm.SORT_MERGE : JoinAlgorithm.BROADCAST);
        if (deducedJoinAlgorithm != preferredJoinAlgorithm) {
            log.debug("User wanted to plan join [%s] as [%s], however the join will be executed as [%s]", new Object[]{joinDataSource, preferredJoinAlgorithm.toString(), deducedJoinAlgorithm.toString()});
        }
        return deducedJoinAlgorithm;
    }

    private static boolean canUseSortMergeJoin(JoinConditionAnalysis joinConditionAnalysis) {
        return joinConditionAnalysis.getEquiConditions().stream().allMatch(equality -> equality.getLeftExpr().isIdentifier());
    }

    public boolean isSingleWorker() {
        return this.broadcastInputs.size() == this.inputSpecs.size();
    }

    private static DataSourcePlan forTable(TableDataSource dataSource, List<Interval> intervals, @Nullable DimFilter filter, @Nullable Set<String> filterFields, boolean broadcast) {
        return new DataSourcePlan((DataSource)(broadcast && dataSource.isGlobal() ? dataSource : new InputNumberDataSource(0)), Collections.singletonList(new TableInputSpec(dataSource.getName(), intervals, filter, filterFields)), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), null);
    }

    private static DataSourcePlan forExternal(ExternalDataSource dataSource, boolean broadcast) {
        return new DataSourcePlan((DataSource)dataSource, Collections.singletonList(new ExternalInputSpec(dataSource.getInputSource(), dataSource.getInputFormat(), dataSource.getSignature())), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), null);
    }

    private static DataSourcePlan forInline(InlineDataSource dataSource, boolean broadcast) {
        return new DataSourcePlan((DataSource)dataSource, Collections.singletonList(new InlineInputSpec(dataSource)), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), null);
    }

    private static DataSourcePlan forLookup(LookupDataSource dataSource, boolean broadcast) {
        return new DataSourcePlan((DataSource)dataSource, Collections.singletonList(new LookupInputSpec(dataSource.getLookupName())), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), null);
    }

    private static DataSourcePlan forQuery(QueryKitSpec queryKitSpec, QueryDataSource dataSource, int minStageNumber, boolean broadcast) {
        QueryDefinition subQueryDef = queryKitSpec.getQueryKit().makeQueryDefinition(queryKitSpec, dataSource.getQuery().withOverriddenContext(CONTEXT_MAP_NO_SEGMENT_GRANULARITY), ShuffleSpecFactories.globalSortWithMaxPartitionCount(queryKitSpec.getNumPartitionsForShuffle()), minStageNumber);
        int stageNumber = subQueryDef.getFinalStageDefinition().getStageNumber();
        return new DataSourcePlan(new InputNumberDataSource(0), Collections.singletonList(new StageInputSpec(stageNumber)), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), QueryDefinition.builder(subQueryDef));
    }

    private static DataSourcePlan forFilteredDataSource(QueryKitSpec queryKitSpec, QueryContext queryContext, FilteredDataSource dataSource, QuerySegmentSpec querySegmentSpec, int minStageNumber, boolean broadcast) {
        DataSourcePlan basePlan = DataSourcePlan.forDataSource(queryKitSpec, queryContext, dataSource.getBase(), querySegmentSpec, null, null, minStageNumber, broadcast);
        DataSource newDataSource = basePlan.getNewDataSource();
        ArrayList<InputSpec> inputSpecs = new ArrayList<InputSpec>(basePlan.getInputSpecs());
        newDataSource = FilteredDataSource.create((DataSource)newDataSource, (DimFilter)dataSource.getFilter());
        return new DataSourcePlan(newDataSource, inputSpecs, basePlan.getBroadcastInputs(), basePlan.getSubQueryDefBuilder().orElse(null));
    }

    private static DataSourcePlan forUnnest(QueryKitSpec queryKitSpec, QueryContext queryContext, UnnestDataSource dataSource, QuerySegmentSpec querySegmentSpec, int minStageNumber, boolean broadcast) {
        DataSourcePlan basePlan = DataSourcePlan.forDataSource(queryKitSpec, queryContext, dataSource.getBase(), querySegmentSpec, null, null, minStageNumber, broadcast);
        DataSource newDataSource = basePlan.getNewDataSource();
        ArrayList<InputSpec> inputSpecs = new ArrayList<InputSpec>(basePlan.getInputSpecs());
        newDataSource = UnnestDataSource.create((DataSource)newDataSource, (VirtualColumn)dataSource.getVirtualColumn(), (DimFilter)dataSource.getUnnestFilter());
        return new DataSourcePlan(newDataSource, inputSpecs, basePlan.getBroadcastInputs(), basePlan.getSubQueryDefBuilder().orElse(null));
    }

    private static DataSourcePlan forUnion(QueryKitSpec queryKitSpec, QueryContext queryContext, UnionDataSource unionDataSource, QuerySegmentSpec querySegmentSpec, @Nullable DimFilter filter, @Nullable Set<String> filterFields, int minStageNumber, boolean broadcast) {
        List children = unionDataSource.getDataSources();
        QueryDefinitionBuilder subqueryDefBuilder = QueryDefinition.builder(queryKitSpec.getQueryId());
        ArrayList<DataSource> newChildren = new ArrayList<DataSource>();
        ArrayList<InputSpec> inputSpecs = new ArrayList<InputSpec>();
        IntOpenHashSet broadcastInputs = new IntOpenHashSet();
        for (DataSource child : children) {
            DataSourcePlan childDataSourcePlan = DataSourcePlan.forDataSource(queryKitSpec, queryContext, child, querySegmentSpec, filter, filterFields, Math.max(minStageNumber, subqueryDefBuilder.getNextStageNumber()), broadcast);
            int shift = inputSpecs.size();
            newChildren.add(DataSourcePlan.shiftInputNumbers(childDataSourcePlan.getNewDataSource(), shift));
            inputSpecs.addAll(childDataSourcePlan.getInputSpecs());
            childDataSourcePlan.getSubQueryDefBuilder().ifPresent(subqueryDefBuilder::addAll);
            childDataSourcePlan.getBroadcastInputs().forEach(arg_0 -> DataSourcePlan.lambda$forUnion$1((IntSet)broadcastInputs, shift, arg_0));
        }
        return new DataSourcePlan((DataSource)new UnionDataSource(newChildren), inputSpecs, (IntSet)broadcastInputs, subqueryDefBuilder);
    }

    private static DataSourcePlan forBroadcastHashJoin(QueryKitSpec queryKitSpec, QueryContext queryContext, JoinDataSource dataSource, QuerySegmentSpec querySegmentSpec, @Nullable DimFilter filter, @Nullable Set<String> filterFields, int minStageNumber, boolean broadcast) {
        QueryDefinitionBuilder subQueryDefBuilder = QueryDefinition.builder(queryKitSpec.getQueryId());
        DataSourceAnalysis analysis = dataSource.getAnalysis();
        DataSourcePlan basePlan = DataSourcePlan.forDataSource(queryKitSpec, queryContext, analysis.getBaseDataSource(), querySegmentSpec, filter, filter == null ? null : DimFilterUtils.onlyBaseFields(filterFields, (DataSourceAnalysis)analysis), Math.max(minStageNumber, subQueryDefBuilder.getNextStageNumber()), broadcast);
        DataSource newDataSource = basePlan.getNewDataSource();
        ArrayList<InputSpec> inputSpecs = new ArrayList<InputSpec>(basePlan.getInputSpecs());
        IntOpenHashSet broadcastInputs = new IntOpenHashSet((IntCollection)basePlan.getBroadcastInputs());
        basePlan.getSubQueryDefBuilder().ifPresent(subQueryDefBuilder::addAll);
        for (int i = 0; i < analysis.getPreJoinableClauses().size(); ++i) {
            PreJoinableClause clause = (PreJoinableClause)analysis.getPreJoinableClauses().get(i);
            DataSourcePlan clausePlan = DataSourcePlan.forDataSource(queryKitSpec, queryContext, clause.getDataSource(), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY), null, null, Math.max(minStageNumber, subQueryDefBuilder.getNextStageNumber()), true);
            int shift = inputSpecs.size();
            newDataSource = JoinDataSource.create((DataSource)newDataSource, (DataSource)DataSourcePlan.shiftInputNumbers(clausePlan.getNewDataSource(), shift), (String)clause.getPrefix(), (JoinConditionAnalysis)clause.getCondition(), (JoinType)clause.getJoinType(), (DimFilter)(i == 0 ? (DimFilter)analysis.getJoinBaseTableFilter().orElse(null) : null), (JoinableFactoryWrapper)dataSource.getJoinableFactoryWrapper(), (JoinAlgorithm)clause.getJoinAlgorithm());
            inputSpecs.addAll(clausePlan.getInputSpecs());
            clausePlan.getBroadcastInputs().intStream().forEach(arg_0 -> DataSourcePlan.lambda$forBroadcastHashJoin$2((IntSet)broadcastInputs, shift, arg_0));
            clausePlan.getSubQueryDefBuilder().ifPresent(subQueryDefBuilder::addAll);
        }
        return new DataSourcePlan(newDataSource, inputSpecs, (IntSet)broadcastInputs, subQueryDefBuilder);
    }

    private static DataSourcePlan forSortMergeJoin(QueryKitSpec queryKitSpec, JoinDataSource dataSource, QuerySegmentSpec querySegmentSpec, int minStageNumber, boolean broadcast) {
        DataSourcePlan.checkQuerySegmentSpecIsEternity((DataSource)dataSource, querySegmentSpec);
        SortMergeJoinFrameProcessorFactory.validateCondition(dataSource.getConditionAnalysis());
        List<List<KeyColumn>> partitionKeys = SortMergeJoinFrameProcessorFactory.toKeyColumns(SortMergeJoinFrameProcessorFactory.validateCondition(dataSource.getConditionAnalysis()));
        QueryDefinitionBuilder subQueryDefBuilder = QueryDefinition.builder(queryKitSpec.getQueryId());
        DataSourcePlan leftPlan = DataSourcePlan.forQuery(queryKitSpec, (QueryDataSource)dataSource.getLeft(), Math.max(minStageNumber, subQueryDefBuilder.getNextStageNumber()), false);
        leftPlan.getSubQueryDefBuilder().ifPresent(subQueryDefBuilder::addAll);
        DataSourcePlan rightPlan = DataSourcePlan.forQuery(queryKitSpec, (QueryDataSource)dataSource.getRight(), Math.max(minStageNumber, subQueryDefBuilder.getNextStageNumber()), false);
        rightPlan.getSubQueryDefBuilder().ifPresent(subQueryDefBuilder::addAll);
        StageDefinitionBuilder leftBuilder = subQueryDefBuilder.getStageBuilder(((StageInputSpec)Iterables.getOnlyElement(leftPlan.getInputSpecs())).getStageNumber());
        int hashPartitionCount = queryKitSpec.getNumPartitionsForShuffle();
        List<KeyColumn> leftPartitionKey = partitionKeys.get(0);
        leftBuilder.shuffleSpec(new HashShuffleSpec(new ClusterBy(leftPartitionKey, 0), hashPartitionCount));
        leftBuilder.signature(QueryKitUtils.sortableSignature(leftBuilder.getSignature(), leftPartitionKey));
        StageDefinitionBuilder rightBuilder = subQueryDefBuilder.getStageBuilder(((StageInputSpec)Iterables.getOnlyElement(rightPlan.getInputSpecs())).getStageNumber());
        List<KeyColumn> rightPartitionKey = partitionKeys.get(1);
        rightBuilder.shuffleSpec(new HashShuffleSpec(new ClusterBy(rightPartitionKey, 0), hashPartitionCount));
        rightBuilder.signature(QueryKitUtils.sortableSignature(rightBuilder.getSignature(), rightPartitionKey));
        RowSignature.Builder joinSignatureBuilder = RowSignature.builder();
        for (String leftColumn : leftBuilder.getSignature().getColumnNames()) {
            joinSignatureBuilder.add(leftColumn, (ColumnType)leftBuilder.getSignature().getColumnType(leftColumn).orElse(null));
        }
        for (String rightColumn : rightBuilder.getSignature().getColumnNames()) {
            joinSignatureBuilder.add(dataSource.getRightPrefix() + rightColumn, (ColumnType)rightBuilder.getSignature().getColumnType(rightColumn).orElse(null));
        }
        int stageNumber = Math.max(minStageNumber, subQueryDefBuilder.getNextStageNumber());
        subQueryDefBuilder.add(StageDefinition.builder(stageNumber).inputs((List<InputSpec>)ImmutableList.of((Object)((InputSpec)Iterables.getOnlyElement(leftPlan.getInputSpecs())), (Object)((InputSpec)Iterables.getOnlyElement(rightPlan.getInputSpecs())))).maxWorkerCount(queryKitSpec.getMaxNonLeafWorkerCount()).signature(joinSignatureBuilder.build()).processorFactory(new SortMergeJoinFrameProcessorFactory(dataSource.getRightPrefix(), dataSource.getConditionAnalysis(), dataSource.getJoinType())));
        return new DataSourcePlan(new InputNumberDataSource(0), Collections.singletonList(new StageInputSpec(stageNumber)), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), subQueryDefBuilder);
    }

    private static DataSource shiftInputNumbers(DataSource dataSource, int shift) {
        if (shift < 0) {
            throw new IAE("Shift must be >= 0", new Object[0]);
        }
        if (shift == 0) {
            return dataSource;
        }
        if (dataSource instanceof InputNumberDataSource) {
            return new InputNumberDataSource(((InputNumberDataSource)dataSource).getInputNumber() + shift);
        }
        return dataSource.withChildren(dataSource.getChildren().stream().map(child -> DataSourcePlan.shiftInputNumbers(child, shift)).collect(Collectors.toList()));
    }

    private static List<Interval> querySegmentSpecIntervals(QuerySegmentSpec querySegmentSpec) {
        if (querySegmentSpec instanceof MultipleIntervalSegmentSpec) {
            return querySegmentSpec.getIntervals();
        }
        throw new UOE("Cannot handle querySegmentSpec type [%s]", new Object[]{querySegmentSpec.getClass().getName()});
    }

    private static void checkQuerySegmentSpecIsEternity(DataSource dataSource, QuerySegmentSpec querySegmentSpec) {
        boolean querySegmentSpecIsEternity;
        boolean bl = querySegmentSpecIsEternity = querySegmentSpec instanceof MultipleIntervalSegmentSpec && querySegmentSpec.getIntervals().equals(Intervals.ONLY_ETERNITY);
        if (!querySegmentSpecIsEternity) {
            throw new UOE("Cannot filter datasource [%s] using [%s]", new Object[]{dataSource.getClass().getName(), "__time"});
        }
    }

    private static /* synthetic */ void lambda$forBroadcastHashJoin$2(IntSet broadcastInputs, int shift, int n) {
        broadcastInputs.add(n + shift);
    }

    private static /* synthetic */ void lambda$forUnion$1(IntSet broadcastInputs, int shift, int inp) {
        broadcastInputs.add(inp + shift);
    }

    static {
        CONTEXT_MAP_NO_SEGMENT_GRANULARITY.put("sqlInsertSegmentGranularity", null);
    }
}

