/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.input.external.ExternalSegment;
import org.apache.druid.query.lookup.LookupSegment;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;

public class ParseExceptionUtils {
    @Nullable
    public static String generateReadableInputSourceNameFromMappedSegment(Segment segment) {
        if (segment instanceof ExternalSegment) {
            return StringUtils.format((String)"external input source: %s", (Object[])new Object[]{((ExternalSegment)segment).externalInputSource().toString()});
        }
        if (segment instanceof LookupSegment) {
            return StringUtils.format((String)"lookup input source: %s", (Object[])new Object[]{segment.getId().getDataSource()});
        }
        if (segment instanceof QueryableIndexSegment) {
            return StringUtils.format((String)"table input source: %s", (Object[])new Object[]{segment.getId().getDataSource()});
        }
        if ("__inline".equals(segment.getId().getDataSource())) {
            return "inline input source";
        }
        return null;
    }
}

