/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.processor.BlockingQueueOutputChannelFactory;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.frame.processor.ComposingOutputChannelFactory;
import org.apache.druid.frame.processor.FileOutputChannelFactory;
import org.apache.druid.frame.processor.FrameChannelHashPartitioner;
import org.apache.druid.frame.processor.FrameChannelMixer;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessorDecorator;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.frame.processor.SuperSorter;
import org.apache.druid.frame.processor.SuperSorterProgressTracker;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.frame.processor.manager.ProcessorManagers;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.ListeningOutputChannelFactory;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.exec.RunWorkOrderListener;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.indexing.CountingOutputChannelFactory;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.indexing.InputChannelsImpl;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.processor.KeyStatisticsCollectionProcessor;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.InputSlices;
import org.apache.druid.msq.input.MapInputSliceReader;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.NilInputSliceReader;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.external.ExternalInputSliceReader;
import org.apache.druid.msq.input.inline.InlineInputSlice;
import org.apache.druid.msq.input.inline.InlineInputSliceReader;
import org.apache.druid.msq.input.lookup.LookupInputSlice;
import org.apache.druid.msq.input.lookup.LookupInputSliceReader;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.input.stage.StageInputSliceReader;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.input.table.SegmentsInputSliceReader;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.FrameProcessorFactory;
import org.apache.druid.msq.kernel.ProcessorsAndChannels;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.shuffle.output.DurableStorageOutputChannelFactory;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.segment.column.RowSignature;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class RunWorkOrder {
    private final WorkOrder workOrder;
    private final InputChannelFactory inputChannelFactory;
    private final CounterTracker counterTracker;
    private final FrameProcessorExecutor exec;
    private final String cancellationId;
    private final int parallelism;
    private final WorkerContext workerContext;
    private final FrameContext frameContext;
    private final RunWorkOrderListener listener;
    private final boolean reindex;
    private final boolean removeNullBytes;
    private final ByteTracker intermediateSuperSorterLocalStorageTracker;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private final AtomicReference<Either<Throwable, Object>> resultForListener = new AtomicReference();
    private @MonotonicNonNull InputSliceReader inputSliceReader;
    private @MonotonicNonNull OutputChannelFactory workOutputChannelFactory;
    private @MonotonicNonNull OutputChannelFactory shuffleOutputChannelFactory;
    private @MonotonicNonNull ResultAndChannels<?> workResultAndOutputChannels;
    private @MonotonicNonNull SettableFuture<ClusterByPartitions> stagePartitionBoundariesFuture;
    private @MonotonicNonNull ListenableFuture<OutputChannels> stageOutputChannelsFuture;

    public RunWorkOrder(WorkOrder workOrder, InputChannelFactory inputChannelFactory, CounterTracker counterTracker, FrameProcessorExecutor exec, String cancellationId, WorkerContext workerContext, FrameContext frameContext, RunWorkOrderListener listener, boolean reindex, boolean removeNullBytes) {
        this.workOrder = workOrder;
        this.inputChannelFactory = inputChannelFactory;
        this.counterTracker = counterTracker;
        this.exec = exec;
        this.cancellationId = cancellationId;
        this.parallelism = workerContext.threadCount();
        this.workerContext = workerContext;
        this.frameContext = frameContext;
        this.listener = listener;
        this.reindex = reindex;
        this.removeNullBytes = removeNullBytes;
        this.intermediateSuperSorterLocalStorageTracker = new ByteTracker(frameContext.storageParameters().isIntermediateStorageLimitConfigured() ? frameContext.storageParameters().getIntermediateSuperSorterStorageMaxLocalBytes() : Long.MAX_VALUE);
    }

    public void startAsync() {
        if (!this.state.compareAndSet(State.INIT, State.STARTED)) {
            throw new ISE("Cannot start from state[%s]", new Object[]{this.state});
        }
        StageDefinition stageDef = this.workOrder.getStageDefinition();
        try {
            this.exec.registerCancellationId(this.cancellationId);
            this.makeInputSliceReader();
            this.makeWorkOutputChannelFactory();
            this.makeShuffleOutputChannelFactory();
            this.makeAndRunWorkProcessors();
            if (stageDef.doesShuffle()) {
                this.makeAndRunShuffleProcessors();
            } else {
                this.stageOutputChannelsFuture = Futures.immediateFuture((Object)this.workResultAndOutputChannels.getOutputChannels().readOnly());
            }
            this.setUpCompletionCallbacks();
        }
        catch (Throwable t) {
            this.stopUnchecked(t);
        }
    }

    public void stop(@Nullable Throwable t) throws InterruptedException {
        if (this.state.compareAndSet(State.INIT, State.STOPPING) || this.state.compareAndSet(State.STARTED, State.STOPPING) || this.state.compareAndSet(State.FAILED, State.STOPPING)) {
            try {
                this.exec.cancel(this.cancellationId);
            }
            catch (Throwable e2) {
                if (t == null) {
                    t = e2;
                }
                t.addSuppressed(e2);
            }
            try {
                this.frameContext.close();
            }
            catch (Throwable e2) {
                if (t == null) {
                    t = e2;
                }
                t.addSuppressed(e2);
            }
            try {
                this.notifyListener((Either<Throwable, Object>)Either.error((Object)(t != null ? t : new MSQException(CanceledFault.instance()))));
            }
            catch (Throwable e2) {
                if (t == null) {
                    t = e2;
                }
                t.addSuppressed(e2);
            }
            this.stopLatch.countDown();
        }
        this.stopLatch.await();
        if (t != null) {
            Throwables.throwIfInstanceOf((Throwable)t, InterruptedException.class);
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    public void stopUnchecked(@Nullable Throwable t) {
        try {
            this.stop(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public SettableFuture<ClusterByPartitions> getStagePartitionBoundariesFuture() {
        return this.stagePartitionBoundariesFuture;
    }

    private void makeInputSliceReader() {
        if (this.inputSliceReader != null) {
            throw new ISE("inputSliceReader already created", new Object[0]);
        }
        String queryId = this.workOrder.getQueryDefinition().getQueryId();
        InputChannelsImpl inputChannels = new InputChannelsImpl(this.workOrder.getQueryDefinition(), InputSlices.allReadablePartitions(this.workOrder.getInputs()), this.inputChannelFactory, () -> ArenaMemoryAllocator.createOnHeap((int)this.frameContext.memoryParameters().getFrameSize()), this.exec, this.cancellationId, this.counterTracker, this.removeNullBytes);
        this.inputSliceReader = new MapInputSliceReader((Map<Class<? extends InputSlice>, InputSliceReader>)ImmutableMap.builder().put(NilInputSlice.class, (Object)NilInputSliceReader.INSTANCE).put(StageInputSlice.class, (Object)new StageInputSliceReader(queryId, inputChannels)).put(ExternalInputSlice.class, (Object)new ExternalInputSliceReader(this.frameContext.tempDir("external"))).put(InlineInputSlice.class, (Object)new InlineInputSliceReader(this.frameContext.segmentWrangler())).put(LookupInputSlice.class, (Object)new LookupInputSliceReader(this.frameContext.segmentWrangler())).put(SegmentsInputSlice.class, (Object)new SegmentsInputSliceReader(this.frameContext, this.reindex)).build());
    }

    private void makeWorkOutputChannelFactory() {
        if (this.workOutputChannelFactory != null) {
            throw new ISE("processorOutputChannelFactory already created", new Object[0]);
        }
        Object baseOutputChannelFactory = this.workOrder.getStageDefinition().doesShuffle() ? new BlockingQueueOutputChannelFactory(this.frameContext.memoryParameters().getFrameSize()) : this.makeStageOutputChannelFactory();
        this.workOutputChannelFactory = new CountingOutputChannelFactory((OutputChannelFactory)baseOutputChannelFactory, this.counterTracker.channel(CounterNames.outputChannel()));
    }

    private void makeShuffleOutputChannelFactory() {
        this.shuffleOutputChannelFactory = new CountingOutputChannelFactory(this.makeStageOutputChannelFactory(), this.counterTracker.channel(CounterNames.shuffleChannel()));
    }

    private <FactoryType extends FrameProcessorFactory<ProcessorReturnType, ManagerReturnType, ExtraInfoType>, ProcessorReturnType, ManagerReturnType, ExtraInfoType> void makeAndRunWorkProcessors() throws IOException {
        if (this.workResultAndOutputChannels != null) {
            throw new ISE("workResultAndOutputChannels already set", new Object[0]);
        }
        FrameProcessorFactory processorFactory = this.workOrder.getStageDefinition().getProcessorFactory();
        ProcessorsAndChannels processors = processorFactory.makeProcessors(this.workOrder.getStageDefinition(), this.workOrder.getWorkerNumber(), this.workOrder.getInputs(), this.inputSliceReader, this.workOrder.getExtraInfo(), this.workOutputChannelFactory, this.frameContext, this.parallelism, this.counterTracker, this.listener::onWarning, this.removeNullBytes);
        ProcessorManager processorManager = processors.getProcessorManager();
        int maxOutstandingProcessors = processors.getOutputChannels().getAllChannels().isEmpty() ? Math.max(1, this.parallelism) : Math.max(1, Math.min(this.parallelism, processors.getOutputChannels().getAllChannels().size()));
        ListenableFuture workResultFuture = this.exec.runAllFully(this.counterTracker.trackCpu(processorManager, "main"), maxOutstandingProcessors, processorFactory.usesProcessingBuffers() ? this.frameContext.processingBuffers().getBouncer() : Bouncer.unlimited(), this.cancellationId);
        this.workResultAndOutputChannels = new ResultAndChannels(workResultFuture, processors.getOutputChannels());
    }

    private void makeAndRunShuffleProcessors() {
        if (this.stageOutputChannelsFuture != null) {
            throw new ISE("stageOutputChannelsFuture already set", new Object[0]);
        }
        ShuffleSpec shuffleSpec = this.workOrder.getStageDefinition().getShuffleSpec();
        ShufflePipelineBuilder shufflePipeline = new ShufflePipelineBuilder(this.workOrder, this.counterTracker, this.exec, this.cancellationId, this.frameContext);
        shufflePipeline.initialize(this.workResultAndOutputChannels);
        shufflePipeline.gatherResultKeyStatisticsAndReportDoneReadingInputIfNeeded();
        switch (shuffleSpec.kind()) {
            case MIX: {
                shufflePipeline.mix(this.shuffleOutputChannelFactory);
                break;
            }
            case HASH: {
                shufflePipeline.hashPartition(this.shuffleOutputChannelFactory);
                break;
            }
            case HASH_LOCAL_SORT: {
                Object hashOutputChannelFactory = shuffleSpec.partitionCount() == 1 ? new BlockingQueueOutputChannelFactory(this.frameContext.memoryParameters().getFrameSize()) : new FileOutputChannelFactory(this.frameContext.tempDir("hash-parts"), this.frameContext.memoryParameters().getFrameSize(), null);
                shufflePipeline.hashPartition((OutputChannelFactory)hashOutputChannelFactory);
                shufflePipeline.localSort(this.shuffleOutputChannelFactory);
                break;
            }
            case GLOBAL_SORT: {
                shufflePipeline.globalSort(this.shuffleOutputChannelFactory, this.makeGlobalSortPartitionBoundariesFuture());
                break;
            }
            default: {
                throw new UOE("Cannot handle shuffle kind [%s]", new Object[]{shuffleSpec.kind()});
            }
        }
        this.stageOutputChannelsFuture = shufflePipeline.build();
    }

    private ListenableFuture<ClusterByPartitions> makeGlobalSortPartitionBoundariesFuture() {
        if (this.workOrder.getStageDefinition().mustGatherResultKeyStatistics()) {
            if (this.stagePartitionBoundariesFuture != null) {
                throw new ISE("Cannot call 'makeGlobalSortPartitionBoundariesFuture' twice", new Object[0]);
            }
            this.stagePartitionBoundariesFuture = SettableFuture.create();
            return this.stagePartitionBoundariesFuture;
        }
        ClusterByPartitions boundaries = (ClusterByPartitions)this.workOrder.getStageDefinition().generatePartitionBoundariesForShuffle(null).valueOrThrow();
        return Futures.immediateFuture((Object)boundaries);
    }

    private void setUpCompletionCallbacks() {
        Futures.addCallback((ListenableFuture)Futures.allAsList(Arrays.asList(this.workResultAndOutputChannels.getResultFuture(), this.stageOutputChannelsFuture)), (FutureCallback)new FutureCallback<List<Object>>(){

            public void onSuccess(List<Object> workerResultAndOutputChannelsResolved) {
                Object resultObject = workerResultAndOutputChannelsResolved.get(0);
                OutputChannels outputChannels = (OutputChannels)workerResultAndOutputChannelsResolved.get(1);
                if (RunWorkOrder.this.workOrder.getOutputChannelMode() != OutputChannelMode.MEMORY) {
                    for (OutputChannel channel : outputChannels.getAllChannels()) {
                        RunWorkOrder.this.listener.onOutputChannelAvailable(channel);
                    }
                }
                if (RunWorkOrder.this.workOrder.getOutputChannelMode().isDurable()) {
                    RunWorkOrder.this.writeDurableStorageSuccessFile();
                }
                RunWorkOrder.this.notifyListener((Either<Throwable, Object>)Either.value((Object)resultObject));
            }

            public void onFailure(Throwable t) {
                if (RunWorkOrder.this.state.compareAndSet(State.STARTED, State.FAILED)) {
                    RunWorkOrder.this.notifyListener((Either<Throwable, Object>)Either.error((Object)t));
                }
            }
        }, (Executor)Execs.directExecutor());
    }

    private void notifyListener(Either<Throwable, Object> result) {
        if (this.resultForListener.compareAndSet(null, result)) {
            if (result.isError()) {
                this.listener.onFailure((Throwable)result.error());
            } else {
                this.listener.onSuccess(result.valueOrThrow());
            }
        }
    }

    private void writeDurableStorageSuccessFile() {
        DurableStorageOutputChannelFactory durableStorageOutputChannelFactory = this.makeDurableStorageOutputChannelFactory(this.frameContext.tempDir("durable"), this.frameContext.memoryParameters().getFrameSize(), this.workOrder.getOutputChannelMode() == OutputChannelMode.DURABLE_STORAGE_QUERY_RESULTS);
        try {
            durableStorageOutputChannelFactory.createSuccessFile(this.workerContext.workerId());
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Unable to create success file at location[%s]", new Object[]{durableStorageOutputChannelFactory.getSuccessFilePath()});
        }
    }

    private OutputChannelFactory makeStageOutputChannelFactory() {
        int frameSize = this.frameContext.memoryParameters().getFrameSize();
        OutputChannelMode outputChannelMode = this.workOrder.getOutputChannelMode();
        switch (outputChannelMode) {
            case MEMORY: {
                return new ListeningOutputChannelFactory((OutputChannelFactory)new BlockingQueueOutputChannelFactory(frameSize), this.listener::onOutputChannelAvailable);
            }
            case LOCAL_STORAGE: {
                File fileChannelDirectory = this.frameContext.tempDir(StringUtils.format((String)"output_stage_%06d", (Object[])new Object[]{this.workOrder.getStageNumber()}));
                return new FileOutputChannelFactory(fileChannelDirectory, frameSize, null);
            }
            case DURABLE_STORAGE_INTERMEDIATE: 
            case DURABLE_STORAGE_QUERY_RESULTS: {
                return this.makeDurableStorageOutputChannelFactory(this.frameContext.tempDir("durable"), frameSize, outputChannelMode == OutputChannelMode.DURABLE_STORAGE_QUERY_RESULTS);
            }
        }
        throw DruidException.defensive((String)"No handling for outputChannelMode[%s]", (Object[])new Object[]{outputChannelMode});
    }

    private OutputChannelFactory makeSuperSorterIntermediateOutputChannelFactory(File tmpDir) {
        int frameSize = this.frameContext.memoryParameters().getFrameSize();
        File fileChannelDirectory = new File(tmpDir, StringUtils.format((String)"intermediate_output_stage_%06d", (Object[])new Object[]{this.workOrder.getStageNumber()}));
        FileOutputChannelFactory fileOutputChannelFactory = new FileOutputChannelFactory(fileChannelDirectory, frameSize, this.intermediateSuperSorterLocalStorageTracker);
        if (this.workOrder.getOutputChannelMode().isDurable() && this.frameContext.storageParameters().isIntermediateStorageLimitConfigured()) {
            boolean isQueryResults = this.workOrder.getOutputChannelMode() == OutputChannelMode.DURABLE_STORAGE_QUERY_RESULTS;
            return new ComposingOutputChannelFactory((List)ImmutableList.of((Object)fileOutputChannelFactory, (Object)this.makeDurableStorageOutputChannelFactory(tmpDir, frameSize, isQueryResults)), frameSize);
        }
        return fileOutputChannelFactory;
    }

    private DurableStorageOutputChannelFactory makeDurableStorageOutputChannelFactory(File tmpDir, int frameSize, boolean isQueryResults) {
        return DurableStorageOutputChannelFactory.createStandardImplementation(this.workerContext.queryId(), this.workOrder.getWorkerNumber(), this.workOrder.getStageNumber(), this.workerContext.workerId(), frameSize, MSQTasks.makeStorageConnector(this.workerContext.injector()), tmpDir, isQueryResults);
    }

    private static interface ExceptionalFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    private static class ResultAndChannels<T> {
        private final ListenableFuture<T> resultFuture;
        private final OutputChannels outputChannels;

        public ResultAndChannels(ListenableFuture<T> resultFuture, OutputChannels outputChannels) {
            this.resultFuture = resultFuture;
            this.outputChannels = outputChannels;
        }

        public ListenableFuture<T> getResultFuture() {
            return this.resultFuture;
        }

        public OutputChannels getOutputChannels() {
            return this.outputChannels;
        }
    }

    private class ShufflePipelineBuilder {
        private final WorkOrder workOrder;
        private final CounterTracker counterTracker;
        private final FrameProcessorExecutor exec;
        private final String cancellationId;
        private final FrameContext frameContext;
        private ListenableFuture<ResultAndChannels<?>> pipelineFuture;

        public ShufflePipelineBuilder(WorkOrder workOrder, CounterTracker counterTracker, FrameProcessorExecutor exec, String cancellationId, FrameContext frameContext) {
            this.workOrder = workOrder;
            this.counterTracker = counterTracker;
            this.exec = exec;
            this.cancellationId = cancellationId;
            this.frameContext = frameContext;
        }

        public void initialize(ResultAndChannels<?> resultAndChannels) {
            if (this.pipelineFuture != null) {
                throw new ISE("already initialized", new Object[0]);
            }
            this.pipelineFuture = Futures.immediateFuture(resultAndChannels);
        }

        public void mix(OutputChannelFactory outputChannelFactory) {
            this.push(resultAndChannels -> {
                OutputChannel outputChannel = outputChannelFactory.openChannel(0);
                FrameChannelMixer mixer = new FrameChannelMixer(resultAndChannels.getOutputChannels().getAllReadableChannels(), outputChannel.getWritableChannel());
                return new ResultAndChannels(this.exec.runFully(this.counterTracker.trackCpu(mixer, "mixOutput"), this.cancellationId), OutputChannels.wrap(Collections.singletonList(outputChannel.readOnly())));
            });
        }

        public void gatherResultKeyStatisticsAndReportDoneReadingInputIfNeeded() {
            this.push(resultAndChannels -> {
                StageDefinition stageDefinition = this.workOrder.getStageDefinition();
                OutputChannels channels = resultAndChannels.getOutputChannels();
                if (channels.getAllChannels().isEmpty()) {
                    if (stageDefinition.mustGatherResultKeyStatistics()) {
                        RunWorkOrder.this.listener.onDoneReadingInput(ClusterByStatisticsSnapshot.empty());
                    } else {
                        RunWorkOrder.this.listener.onDoneReadingInput(null);
                    }
                    BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
                    channel.writable().close();
                    OutputChannel outputChannel = OutputChannel.readOnly((ReadableFrameChannel)channel.readable(), (int)-1);
                    return new ResultAndChannels(Futures.immediateFuture(null), OutputChannels.wrap(Collections.singletonList(outputChannel)));
                }
                if (stageDefinition.mustGatherResultKeyStatistics()) {
                    return this.gatherResultKeyStatistics(channels);
                }
                resultAndChannels.resultFuture.addListener(() -> RunWorkOrder.this.listener.onDoneReadingInput(null), (Executor)Execs.directExecutor());
                return resultAndChannels;
            });
        }

        public void globalSort(OutputChannelFactory outputChannelFactory, ListenableFuture<ClusterByPartitions> partitionBoundariesFuture) {
            this.pushAsync(resultAndChannels -> {
                StageDefinition stageDefinition = this.workOrder.getStageDefinition();
                File sorterTmpDir = this.frameContext.tempDir("super-sort");
                FileUtils.mkdirp((File)sorterTmpDir);
                if (!sorterTmpDir.isDirectory()) {
                    throw new IOException("Cannot create directory: " + sorterTmpDir);
                }
                WorkerMemoryParameters memoryParameters = this.frameContext.memoryParameters();
                SuperSorter sorter = new SuperSorter(resultAndChannels.getOutputChannels().getAllReadableChannels(), stageDefinition.getFrameReader(), stageDefinition.getSortKey(), partitionBoundariesFuture, this.exec, new FrameProcessorDecorator(){

                    public <T> FrameProcessor<T> decorate(FrameProcessor<T> processor) {
                        return ShufflePipelineBuilder.this.counterTracker.trackCpu(processor, "sortOutput");
                    }
                }, outputChannelFactory, RunWorkOrder.this.makeSuperSorterIntermediateOutputChannelFactory(sorterTmpDir), memoryParameters.getSuperSorterConcurrentProcessors(), memoryParameters.getSuperSorterMaxChannelsPerMerger(), stageDefinition.getShuffleSpec().limitHint(), this.cancellationId, this.counterTracker.sortProgress(), RunWorkOrder.this.removeNullBytes);
                return FutureUtils.transform((ListenableFuture)sorter.run(), sortedChannels -> new ResultAndChannels(Futures.immediateFuture(null), (OutputChannels)sortedChannels));
            });
        }

        public void hashPartition(OutputChannelFactory outputChannelFactory) {
            this.pushAsync(resultAndChannels -> {
                ShuffleSpec shuffleSpec = this.workOrder.getStageDefinition().getShuffleSpec();
                int partitions = shuffleSpec.partitionCount();
                ArrayList<OutputChannel> outputChannels = new ArrayList<OutputChannel>();
                for (int i = 0; i < partitions; ++i) {
                    outputChannels.add(outputChannelFactory.openChannel(i));
                }
                FrameChannelHashPartitioner partitioner = new FrameChannelHashPartitioner(resultAndChannels.getOutputChannels().getAllReadableChannels(), outputChannels.stream().map(OutputChannel::getWritableChannel).collect(Collectors.toList()), this.workOrder.getStageDefinition().getFrameReader(), this.workOrder.getStageDefinition().getClusterBy().getColumns().size(), FrameWriters.makeRowBasedFrameWriterFactory((MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(this.frameContext.memoryParameters().getFrameSize()), (RowSignature)this.workOrder.getStageDefinition().getSignature(), this.workOrder.getStageDefinition().getSortKey(), (boolean)RunWorkOrder.this.removeNullBytes));
                ListenableFuture partitionerFuture = this.exec.runFully(this.counterTracker.trackCpu(partitioner, "hashPartitionOutput"), this.cancellationId);
                ResultAndChannels retVal = new ResultAndChannels(partitionerFuture, OutputChannels.wrap(outputChannels));
                if (retVal.getOutputChannels().areReadableChannelsReady()) {
                    return Futures.immediateFuture(retVal);
                }
                return FutureUtils.transform((ListenableFuture)partitionerFuture, ignored -> retVal);
            });
        }

        public void localSort(final OutputChannelFactory outputChannelFactory) {
            this.pushAsync(resultAndChannels -> {
                StageDefinition stageDefinition = this.workOrder.getStageDefinition();
                OutputChannels channels = resultAndChannels.getOutputChannels();
                ArrayList<ListenableFuture> sortedChannelFutures = new ArrayList<ListenableFuture>();
                ListenableFuture nextFuture = Futures.immediateFuture(null);
                for (final OutputChannel channel : channels.getAllChannels()) {
                    File sorterTmpDir = this.frameContext.tempDir(StringUtils.format((String)"hash-parts-super-sort-%06d", (Object[])new Object[]{channel.getPartitionNumber()}));
                    FileUtils.mkdirp((File)sorterTmpDir);
                    OutputChannelFactory partitionOverrideOutputChannelFactory = new OutputChannelFactory(){

                        public OutputChannel openChannel(int expectedZero) throws IOException {
                            if (expectedZero != 0) {
                                throw new ISE("Unexpected part [%s]", new Object[]{expectedZero});
                            }
                            return outputChannelFactory.openChannel(channel.getPartitionNumber());
                        }

                        public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) {
                            throw new UnsupportedOperationException();
                        }

                        public OutputChannel openNilChannel(int expectedZero) {
                            if (expectedZero != 0) {
                                throw new ISE("Unexpected part [%s]", new Object[]{expectedZero});
                            }
                            return outputChannelFactory.openNilChannel(channel.getPartitionNumber());
                        }
                    };
                    nextFuture = Futures.transformAsync((ListenableFuture)nextFuture, ignored -> {
                        SuperSorter sorter = new SuperSorter(Collections.singletonList(channel.getReadableChannel()), stageDefinition.getFrameReader(), stageDefinition.getSortKey(), Futures.immediateFuture((Object)ClusterByPartitions.oneUniversalPartition()), this.exec, new FrameProcessorDecorator(){

                            public <T> FrameProcessor<T> decorate(FrameProcessor<T> processor) {
                                return ShufflePipelineBuilder.this.counterTracker.trackCpu(processor, "sortOutput");
                            }
                        }, partitionOverrideOutputChannelFactory, RunWorkOrder.this.makeSuperSorterIntermediateOutputChannelFactory(sorterTmpDir), 1, 2, -1L, this.cancellationId, new SuperSorterProgressTracker(), RunWorkOrder.this.removeNullBytes);
                        return FutureUtils.transform((ListenableFuture)sorter.run(), r -> (OutputChannel)Iterables.getOnlyElement((Iterable)r.getAllChannels()));
                    }, (Executor)MoreExecutors.directExecutor());
                    sortedChannelFutures.add(nextFuture);
                }
                return FutureUtils.transform((ListenableFuture)Futures.allAsList(sortedChannelFutures), sortedChannels -> new ResultAndChannels(Futures.immediateFuture(null), OutputChannels.wrap((List)sortedChannels)));
            });
        }

        public ListenableFuture<OutputChannels> build() {
            if (this.pipelineFuture == null) {
                throw new ISE("Not initialized", new Object[0]);
            }
            return Futures.transformAsync(this.pipelineFuture, resultAndChannels -> Futures.transform(resultAndChannels.getResultFuture(), input -> {
                this.sanityCheckOutputChannels(resultAndChannels.getOutputChannels());
                return resultAndChannels.getOutputChannels();
            }, (Executor)Execs.directExecutor()), (Executor)Execs.directExecutor());
        }

        private ResultAndChannels<?> gatherResultKeyStatistics(OutputChannels channels) {
            final StageDefinition stageDefinition = this.workOrder.getStageDefinition();
            ArrayList<OutputChannel> retVal = new ArrayList<OutputChannel>();
            int numOutputChannels = channels.getAllChannels().size();
            ArrayList<KeyStatisticsCollectionProcessor> processors = new ArrayList<KeyStatisticsCollectionProcessor>(numOutputChannels);
            for (OutputChannel outputChannel : channels.getAllChannels()) {
                BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
                retVal.add(OutputChannel.readOnly((ReadableFrameChannel)channel.readable(), (int)outputChannel.getPartitionNumber()));
                processors.add(new KeyStatisticsCollectionProcessor(outputChannel.getReadableChannel(), channel.writable(), stageDefinition.getFrameReader(), stageDefinition.getClusterBy(), stageDefinition.createResultKeyStatisticsCollector(this.frameContext.memoryParameters().getPartitionStatisticsMaxRetainedBytes() / 2 / numOutputChannels)));
            }
            ListenableFuture clusterByStatisticsCollectorFuture = this.exec.runAllFully(this.counterTracker.trackCpu(ProcessorManagers.of(processors).withAccumulation((Object)stageDefinition.createResultKeyStatisticsCollector(this.frameContext.memoryParameters().getPartitionStatisticsMaxRetainedBytes() / 2), ClusterByStatisticsCollector::addAll), "collectKeyStatistics"), processors.size(), Bouncer.unlimited(), this.cancellationId);
            Futures.addCallback((ListenableFuture)clusterByStatisticsCollectorFuture, (FutureCallback)new FutureCallback<ClusterByStatisticsCollector>(){

                public void onSuccess(ClusterByStatisticsCollector result) {
                    RunWorkOrder.this.listener.onDoneReadingInput(result.snapshot());
                }

                public void onFailure(Throwable t) {
                    RunWorkOrder.this.listener.onFailure(new ISE(t, "Failed to gather clusterBy statistics for stage[%s]", new Object[]{stageDefinition.getId()}));
                }
            }, (Executor)Execs.directExecutor());
            return new ResultAndChannels(clusterByStatisticsCollectorFuture, OutputChannels.wrap(retVal));
        }

        private void push(ExceptionalFunction<ResultAndChannels<?>, ResultAndChannels<?>> fn) {
            this.pushAsync(channels -> Futures.immediateFuture((Object)((ResultAndChannels)fn.apply((ResultAndChannels<?>)channels))));
        }

        private void pushAsync(ExceptionalFunction<ResultAndChannels<?>, ListenableFuture<ResultAndChannels<?>>> fn) {
            if (this.pipelineFuture == null) {
                throw new ISE("Not initialized", new Object[0]);
            }
            this.pipelineFuture = FutureUtils.transform((ListenableFuture)Futures.transformAsync(this.pipelineFuture, fn::apply, (Executor)Execs.directExecutor()), resultAndChannels -> new ResultAndChannels(resultAndChannels.getResultFuture(), resultAndChannels.getOutputChannels().readOnly()));
        }

        private void sanityCheckOutputChannels(OutputChannels outputChannels) {
            IntBidirectionalIterator intBidirectionalIterator = outputChannels.getPartitionNumbers().iterator();
            while (intBidirectionalIterator.hasNext()) {
                int partitionNumber = (Integer)intBidirectionalIterator.next();
                List outputChannelsForPartition = outputChannels.getChannelsForPartition(partitionNumber);
                Preconditions.checkState((partitionNumber >= 0 ? 1 : 0) != 0, (String)"Expected partitionNumber >= 0, but got [%s]", (int)partitionNumber);
                Preconditions.checkState((outputChannelsForPartition.size() == 1 ? 1 : 0) != 0, (String)"Expected one channel for partition [%s], but got [%s]", (int)partitionNumber, (int)outputChannelsForPartition.size());
            }
        }
    }

    static enum State {
        INIT,
        STARTED,
        FAILED,
        STOPPING,
        STOPPED;

    }
}

