/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.druid.frame.channel.ReadableByteChunksFrameChannel;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.WorkerRpcFailedFault;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.rpc.SketchEncoding;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;

public class ExceptionWrappingWorkerClient
implements WorkerClient {
    private final WorkerClient client;

    public ExceptionWrappingWorkerClient(WorkerClient client) {
        this.client = (WorkerClient)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    @Override
    public ListenableFuture<Void> postWorkOrder(String workerTaskId, WorkOrder workOrder) {
        return ExceptionWrappingWorkerClient.wrap(workerTaskId, this.client, c -> c.postWorkOrder(workerTaskId, workOrder));
    }

    @Override
    public ListenableFuture<ClusterByStatisticsSnapshot> fetchClusterByStatisticsSnapshot(String workerTaskId, StageId stageId, SketchEncoding sketchEncoding) {
        return ExceptionWrappingWorkerClient.wrap(workerTaskId, this.client, c -> c.fetchClusterByStatisticsSnapshot(workerTaskId, stageId, sketchEncoding));
    }

    @Override
    public ListenableFuture<ClusterByStatisticsSnapshot> fetchClusterByStatisticsSnapshotForTimeChunk(String workerTaskId, StageId stageId, long timeChunk, SketchEncoding sketchEncoding) {
        return ExceptionWrappingWorkerClient.wrap(workerTaskId, this.client, c -> c.fetchClusterByStatisticsSnapshotForTimeChunk(workerTaskId, stageId, timeChunk, sketchEncoding));
    }

    @Override
    public ListenableFuture<Void> postResultPartitionBoundaries(String workerTaskId, StageId stageId, ClusterByPartitions partitionBoundaries) {
        return ExceptionWrappingWorkerClient.wrap(workerTaskId, this.client, c -> c.postResultPartitionBoundaries(workerTaskId, stageId, partitionBoundaries));
    }

    @Override
    public ListenableFuture<Void> postCleanupStage(String workerTaskId, StageId stageId) {
        return ExceptionWrappingWorkerClient.wrap(workerTaskId, this.client, c -> c.postCleanupStage(workerTaskId, stageId));
    }

    @Override
    public ListenableFuture<Void> postFinish(String workerTaskId) {
        return ExceptionWrappingWorkerClient.wrap(workerTaskId, this.client, c -> c.postFinish(workerTaskId));
    }

    @Override
    public ListenableFuture<CounterSnapshotsTree> getCounters(String workerTaskId) {
        return ExceptionWrappingWorkerClient.wrap(workerTaskId, this.client, c -> c.getCounters(workerTaskId));
    }

    @Override
    public ListenableFuture<Boolean> fetchChannelData(String workerTaskId, StageId stageId, int partitionNumber, long offset, ReadableByteChunksFrameChannel channel) {
        return ExceptionWrappingWorkerClient.wrap(workerTaskId, this.client, c -> c.fetchChannelData(workerTaskId, stageId, partitionNumber, offset, channel));
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static <T> ListenableFuture<T> wrap(final String workerTaskId, WorkerClient client, ClientFn<T> clientFn) {
        ListenableFuture<T> clientFuture;
        final SettableFuture retVal = SettableFuture.create();
        try {
            clientFuture = clientFn.apply(client);
        }
        catch (Exception e) {
            throw new MSQException(e, new WorkerRpcFailedFault(workerTaskId));
        }
        Futures.addCallback(clientFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                retVal.set(result);
            }

            public void onFailure(Throwable t) {
                retVal.setException((Throwable)new MSQException(t, new WorkerRpcFailedFault(workerTaskId)));
            }
        }, (Executor)MoreExecutors.directExecutor());
        return retVal;
    }

    private static interface ClientFn<T> {
        public ListenableFuture<T> apply(WorkerClient var1);
    }
}

