/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import java.io.File;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.messages.server.Outbox;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.dart.worker.DartControllerClient;
import org.apache.druid.msq.dart.worker.DartFrameContext;
import org.apache.druid.msq.dart.worker.DartWorkerClient;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.exec.DataServerQueryHandlerFactory;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.exec.ProcessingBuffersSet;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.exec.WorkerStorageParameters;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.server.DruidNode;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class DartWorkerContext
implements WorkerContext {
    private final String queryId;
    private final String controllerHost;
    private final WorkerId workerId;
    private final DruidNode selfNode;
    private final ObjectMapper jsonMapper;
    private final Injector injector;
    private final DartWorkerClient workerClient;
    private final DruidProcessingConfig processingConfig;
    private final SegmentWrangler segmentWrangler;
    private final GroupingEngine groupingEngine;
    private final DataSegmentProvider dataSegmentProvider;
    private final MemoryIntrospector memoryIntrospector;
    private final ProcessingBuffersProvider processingBuffersProvider;
    private final Outbox<ControllerMessage> outbox;
    private final File tempDir;
    private final QueryContext queryContext;
    private volatile @MonotonicNonNull ResourceHolder<ProcessingBuffersSet> processingBuffersSet;

    DartWorkerContext(String queryId, String controllerHost, DruidNode selfNode, ObjectMapper jsonMapper, Injector injector, DartWorkerClient workerClient, DruidProcessingConfig processingConfig, SegmentWrangler segmentWrangler, GroupingEngine groupingEngine, DataSegmentProvider dataSegmentProvider, MemoryIntrospector memoryIntrospector, ProcessingBuffersProvider processingBuffersProvider, Outbox<ControllerMessage> outbox, File tempDir, QueryContext queryContext) {
        this.queryId = queryId;
        this.controllerHost = controllerHost;
        this.workerId = WorkerId.fromDruidNode(selfNode, queryId);
        this.selfNode = selfNode;
        this.jsonMapper = jsonMapper;
        this.injector = injector;
        this.workerClient = workerClient;
        this.processingConfig = processingConfig;
        this.segmentWrangler = segmentWrangler;
        this.groupingEngine = groupingEngine;
        this.dataSegmentProvider = dataSegmentProvider;
        this.memoryIntrospector = memoryIntrospector;
        this.processingBuffersProvider = processingBuffersProvider;
        this.outbox = outbox;
        this.tempDir = tempDir;
        this.queryContext = (QueryContext)Preconditions.checkNotNull((Object)queryContext, (Object)"queryContext");
    }

    @Override
    public String queryId() {
        return this.queryId;
    }

    @Override
    public String workerId() {
        return this.workerId.toString();
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public void registerWorker(Worker worker, Closer closer) {
        closer.register(() -> {
            DartWorkerContext dartWorkerContext = this;
            synchronized (dartWorkerContext) {
                if (this.processingBuffersSet != null) {
                    this.processingBuffersSet.close();
                    this.processingBuffersSet = null;
                }
            }
            this.workerClient.close();
        });
    }

    @Override
    public int maxConcurrentStages() {
        int retVal = MultiStageQueryContext.getMaxConcurrentStagesWithDefault(this.queryContext, -1);
        if (retVal <= 0) {
            throw new IAE("Illegal maxConcurrentStages[%s]", new Object[]{retVal});
        }
        return retVal;
    }

    @Override
    public ControllerClient makeControllerClient() {
        return new DartControllerClient(this.outbox, this.queryId, this.controllerHost);
    }

    @Override
    public WorkerClient makeWorkerClient() {
        return this.workerClient;
    }

    @Override
    public File tempDir() {
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameContext frameContext(WorkOrder workOrder) {
        if (this.processingBuffersSet == null) {
            DartWorkerContext dartWorkerContext = this;
            synchronized (dartWorkerContext) {
                if (this.processingBuffersSet == null) {
                    this.processingBuffersSet = this.processingBuffersProvider.acquire(workOrder.getQueryDefinition(), this.maxConcurrentStages());
                }
            }
        }
        WorkerMemoryParameters memoryParameters = WorkerMemoryParameters.createProductionInstance(workOrder, this.memoryIntrospector, this.maxConcurrentStages());
        WorkerStorageParameters storageParameters = WorkerStorageParameters.createInstance(-1L, false);
        return new DartFrameContext(workOrder.getStageDefinition().getId(), this, this.segmentWrangler, this.groupingEngine, this.dataSegmentProvider, ((ProcessingBuffersSet)this.processingBuffersSet.get()).acquireForStage(workOrder.getStageDefinition()), memoryParameters, storageParameters);
    }

    @Override
    public int threadCount() {
        return this.processingConfig.getNumThreads();
    }

    @Override
    public DataServerQueryHandlerFactory dataServerQueryHandlerFactory() {
        return null;
    }

    @Override
    public boolean includeAllCounters() {
        return true;
    }

    @Override
    public DruidNode selfNode() {
        return this.selfNode;
    }
}

