/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.google.inject.Inject;
import java.io.Closeable;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;

public class DartDataSegmentProvider
implements DataSegmentProvider {
    private final SegmentManager segmentManager;

    @Inject
    public DartDataSegmentProvider(SegmentManager segmentManager) {
        this.segmentManager = segmentManager;
    }

    @Override
    public Supplier<ResourceHolder<CompleteSegment>> fetchSegment(SegmentId segmentId, ChannelCounters channelCounters, boolean isReindex) {
        if (isReindex) {
            throw DruidException.defensive((String)"Got isReindex[%s], expected false", (Object[])new Object[]{isReindex});
        }
        return () -> {
            Optional timeline = this.segmentManager.getTimeline(new TableDataSource(segmentId.getDataSource()).getAnalysis());
            if (!timeline.isPresent()) {
                throw DartDataSegmentProvider.segmentNotFound(segmentId);
            }
            PartitionChunk chunk = ((VersionedIntervalTimeline)timeline.get()).findChunk(segmentId.getInterval(), (Object)segmentId.getVersion(), segmentId.getPartitionNum());
            if (chunk == null) {
                throw DartDataSegmentProvider.segmentNotFound(segmentId);
            }
            ReferenceCountingSegment segment = (ReferenceCountingSegment)chunk.getObject();
            Optional closeable = segment.acquireReferences();
            if (!closeable.isPresent()) {
                throw DartDataSegmentProvider.segmentNotFound(segmentId);
            }
            Closer closer = Closer.create();
            closer.register((Closeable)closeable.get());
            closer.register(() -> {
                PhysicalSegmentInspector inspector = (PhysicalSegmentInspector)segment.as(PhysicalSegmentInspector.class);
                channelCounters.addFile(inspector != null ? (long)inspector.getNumRows() : 0L, 0L);
            });
            return new ReferenceCountingResourceHolder((Object)new CompleteSegment(null, (Segment)segment), (Closeable)closer);
        };
    }

    private static DruidException segmentNotFound(SegmentId segmentId) {
        return DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Segment[%s] not found on this server. Please retry your query.", new Object[]{segmentId});
    }
}

