/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlParameter;

public class SqlQuery {
    private final String query;
    private final ResultFormat resultFormat;
    private final boolean header;
    private final boolean typesHeader;
    private final boolean sqlTypesHeader;
    private final Map<String, Object> context;
    private final List<SqlParameter> parameters;

    public static List<TypedValue> getParameterList(List<SqlParameter> parameters) {
        return parameters.stream().map(p -> p == null ? null : p.getTypedValue()).collect(Collectors.toList());
    }

    @JsonCreator
    public SqlQuery(@JsonProperty(value="query") String query, @JsonProperty(value="resultFormat") @Nullable ResultFormat resultFormat, @JsonProperty(value="header") boolean header, @JsonProperty(value="typesHeader") boolean typesHeader, @JsonProperty(value="sqlTypesHeader") boolean sqlTypesHeader, @JsonProperty(value="context") @Nullable Map<String, Object> context, @JsonProperty(value="parameters") @Nullable List<SqlParameter> parameters) {
        this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"query");
        this.resultFormat = resultFormat == null ? ResultFormat.DEFAULT_RESULT_FORMAT : resultFormat;
        this.header = header;
        this.typesHeader = typesHeader;
        this.sqlTypesHeader = sqlTypesHeader;
        this.context = context == null ? ImmutableMap.of() : context;
        Object object = this.parameters = parameters == null ? ImmutableList.of() : parameters;
        if (typesHeader && !header) {
            throw new ISE("Cannot include 'typesHeader' without 'header'", new Object[0]);
        }
        if (sqlTypesHeader && !header) {
            throw new ISE("Cannot include 'sqlTypesHeader' without 'header'", new Object[0]);
        }
    }

    public SqlQuery withOverridenContext(Map<String, Object> overridenContext) {
        return new SqlQuery(this.getQuery(), this.getResultFormat(), this.includeHeader(), this.includeTypesHeader(), this.includeSqlTypesHeader(), overridenContext, this.getParameters());
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    @JsonProperty(value="header")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean includeHeader() {
        return this.header;
    }

    @JsonProperty(value="typesHeader")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean includeTypesHeader() {
        return this.typesHeader;
    }

    @JsonProperty(value="sqlTypesHeader")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean includeSqlTypesHeader() {
        return this.sqlTypesHeader;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public QueryContext queryContext() {
        return QueryContext.of(this.context);
    }

    @JsonProperty
    public List<SqlParameter> getParameters() {
        return this.parameters;
    }

    public List<TypedValue> getParameterList() {
        return SqlQuery.getParameterList(this.parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlQuery sqlQuery = (SqlQuery)o;
        return this.header == sqlQuery.header && this.typesHeader == sqlQuery.typesHeader && this.sqlTypesHeader == sqlQuery.sqlTypesHeader && Objects.equals(this.query, sqlQuery.query) && this.resultFormat == sqlQuery.resultFormat && Objects.equals(this.context, sqlQuery.context) && Objects.equals(this.parameters, sqlQuery.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.resultFormat, this.header, this.typesHeader, this.sqlTypesHeader, this.context, this.parameters});
    }

    public String toString() {
        return "SqlQuery{query='" + this.query + "', resultFormat=" + this.resultFormat + ", header=" + this.header + ", typesHeader=" + this.typesHeader + ", sqlTypesHeader=" + this.sqlTypesHeader + ", context=" + this.context + ", parameters=" + this.parameters + "}";
    }
}

