/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.calcite.schema.Schema;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.calcite.schema.InformationSchema;
import org.apache.druid.sql.calcite.schema.LookupSchema;
import org.apache.druid.sql.calcite.schema.NamedDruidSchema;
import org.apache.druid.sql.calcite.schema.NamedLookupSchema;
import org.apache.druid.sql.calcite.schema.NamedSystemSchema;
import org.apache.druid.sql.calcite.schema.NamedViewSchema;
import org.apache.druid.sql.calcite.schema.RootSchemaProvider;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.guice.SqlBindings;

public class DruidCalciteSchemaModule
implements Module {
    private static final String DRUID_SCHEMA_NAME = "druid";
    private static final String INFORMATION_SCHEMA_NAME = "INFORMATION_SCHEMA";
    static final String INCOMPLETE_SCHEMA = "INCOMPLETE_SCHEMA";

    public void configure(Binder binder) {
        binder.bind(String.class).annotatedWith(DruidSchemaName.class).toInstance((Object)DRUID_SCHEMA_NAME);
        binder.bind(DruidSchemaCatalog.class).annotatedWith((Annotation)Names.named((String)INCOMPLETE_SCHEMA)).toProvider(RootSchemaProvider.class).in(Scopes.SINGLETON);
        LifecycleModule.register((Binder)binder, BrokerSegmentMetadataCache.class);
        binder.bind(DruidSchema.class).in(Scopes.SINGLETON);
        binder.bind(SystemSchema.class).in(Scopes.SINGLETON);
        binder.bind(InformationSchema.class).in(Scopes.SINGLETON);
        binder.bind(LookupSchema.class).in(Scopes.SINGLETON);
        SqlBindings.addSchema(binder, NamedDruidSchema.class);
        SqlBindings.addSchema(binder, NamedSystemSchema.class);
        SqlBindings.addSchema(binder, NamedLookupSchema.class);
        SqlBindings.addSchema(binder, NamedViewSchema.class);
    }

    @Provides
    @LazySingleton
    private DruidSchemaCatalog getRootSchema(@Named(value="INCOMPLETE_SCHEMA") DruidSchemaCatalog rootSchema, InformationSchema informationSchema) {
        rootSchema.getRootSchema().add(INFORMATION_SCHEMA_NAME, (Schema)informationSchema);
        return rootSchema;
    }
}

