/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.RequestInfo;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AllowAllAuthorizer;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.server.security.ResourceType;

public class AuthorizationUtils {
    static final ImmutableSet<String> RESTRICTION_APPLICABLE_RESOURCE_TYPES = ImmutableSet.of((Object)"DATASOURCE");
    public static final Function<String, ResourceAction> DATASOURCE_READ_RA_GENERATOR = input -> new ResourceAction(new Resource((String)input, "DATASOURCE"), Action.READ);
    public static final Function<String, ResourceAction> DATASOURCE_WRITE_RA_GENERATOR = input -> new ResourceAction(new Resource((String)input, "DATASOURCE"), Action.WRITE);
    public static final Function<String, ResourceAction> VIEW_READ_RA_GENERATOR = input -> new ResourceAction(new Resource((String)input, "VIEW"), Action.READ);
    public static final Function<Resource, ResourceAction> RESOURCE_READ_RA_GENERATOR = input -> new ResourceAction((Resource)input, Action.READ);

    public static AuthorizationResult authorizeResourceAction(HttpServletRequest request, ResourceAction resourceAction, AuthorizerMapper authorizerMapper) {
        return AuthorizationUtils.authorizeAllResourceActions(request, Collections.singletonList(resourceAction), authorizerMapper);
    }

    public static AuthenticationResult authenticationResultFromRequest(HttpServletRequest request) {
        AuthenticationResult authenticationResult = (AuthenticationResult)request.getAttribute("Druid-Authentication-Result");
        if (authenticationResult == null) {
            throw new ISE("Null authentication result", new Object[0]);
        }
        return authenticationResult;
    }

    public static String getAuthenticatedIdentity(HttpServletRequest request) {
        AuthenticationResult authenticationResult = (AuthenticationResult)request.getAttribute("Druid-Authentication-Result");
        if (authenticationResult == null) {
            return null;
        }
        return authenticationResult.getIdentity();
    }

    public static AuditInfo buildAuditInfo(HttpServletRequest request) {
        String author = request.getHeader("X-Druid-Author");
        String comment = request.getHeader("X-Druid-Comment");
        return new AuditInfo(author == null ? "" : author, AuthorizationUtils.getAuthenticatedIdentity(request), comment == null ? "" : comment, request.getRemoteAddr());
    }

    public static RequestInfo buildRequestInfo(String service, HttpServletRequest request) {
        return new RequestInfo(service, request.getMethod(), request.getRequestURI(), request.getQueryString());
    }

    public static AuthorizationResult authorizeAllResourceActions(AuthenticationResult authenticationResult, Iterable<ResourceAction> resourceActions, AuthorizerMapper authorizerMapper) {
        Authorizer authorizer = authorizerMapper.getAuthorizer(authenticationResult.getAuthorizerName());
        if (authorizer == null) {
            throw new ISE("No authorizer found with name: [%s].", new Object[]{authenticationResult.getAuthorizerName()});
        }
        HashSet<ResourceAction> resultCache = new HashSet<ResourceAction>();
        HashMap<String, Optional<Policy>> policyFilters = new HashMap<String, Optional<Policy>>();
        for (ResourceAction resourceAction : resourceActions) {
            if (resultCache.contains(resourceAction)) continue;
            Access access = authorizer.authorize(authenticationResult, resourceAction.getResource(), resourceAction.getAction());
            if (!access.isAllowed()) {
                return AuthorizationResult.deny(access.getMessage());
            }
            resultCache.add(resourceAction);
            if (resourceAction.getAction().equals((Object)Action.READ) && RESTRICTION_APPLICABLE_RESOURCE_TYPES.contains((Object)resourceAction.getResource().getType())) {
                policyFilters.put(resourceAction.getResource().getName(), access.getPolicy());
                continue;
            }
            if (!access.getPolicy().isPresent()) continue;
            throw DruidException.defensive((String)"Policy should only present when reading a table, but was present for a different kind of resource action [%s]", (Object[])new Object[]{resourceAction});
        }
        return AuthorizationResult.allowWithRestriction(policyFilters);
    }

    public static AuthorizationResult authorizeAllResourceActions(HttpServletRequest request, Iterable<ResourceAction> resourceActions, AuthorizerMapper authorizerMapper) {
        if (request.getAttribute("Druid-Allow-Unsecured-Path") != null) {
            return AuthorizationResult.ALLOW_NO_RESTRICTION;
        }
        if (request.getAttribute("Druid-Authorization-Checked") != null) {
            throw new ISE("Request already had authorization check.", new Object[0]);
        }
        AuthorizationResult authResult = AuthorizationUtils.authorizeAllResourceActions(AuthorizationUtils.authenticationResultFromRequest(request), resourceActions, authorizerMapper);
        request.setAttribute("Druid-Authorization-Checked", (Object)authResult.allowBasicAccess());
        return authResult;
    }

    public static void setRequestAuthorizationAttributeIfNeeded(HttpServletRequest request) {
        if (request.getAttribute("Druid-Allow-Unsecured-Path") != null) {
            return;
        }
        if (request.getAttribute("Druid-Authorization-Checked") != null) {
            throw DruidException.defensive((String)"Request already had authorization check.", (Object[])new Object[0]);
        }
        request.setAttribute("Druid-Authorization-Checked", (Object)true);
    }

    public static <ResType> Iterable<ResType> filterAuthorizedResources(HttpServletRequest request, Iterable<ResType> resources, Function<? super ResType, Iterable<ResourceAction>> resourceActionGenerator, AuthorizerMapper authorizerMapper) {
        if (request.getAttribute("Druid-Allow-Unsecured-Path") != null) {
            return resources;
        }
        if (request.getAttribute("Druid-Authorization-Checked") != null) {
            throw new ISE("Request already had authorization check.", new Object[0]);
        }
        AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest(request);
        Iterable<? super ResType> filteredResources = AuthorizationUtils.filterAuthorizedResources(authenticationResult, resources, resourceActionGenerator, authorizerMapper);
        request.setAttribute("Druid-Authorization-Checked", (Object)true);
        return filteredResources;
    }

    public static <ResType> Iterable<ResType> filterAuthorizedResources(AuthenticationResult authenticationResult, Iterable<ResType> resources, Function<? super ResType, Iterable<ResourceAction>> resourceActionGenerator, AuthorizerMapper authorizerMapper) {
        Authorizer authorizer = authorizerMapper.getAuthorizer(authenticationResult.getAuthorizerName());
        if (authorizer == null) {
            throw new ISE("No authorizer found with name: [%s].", new Object[]{authenticationResult.getAuthorizerName()});
        }
        HashMap resultCache = new HashMap();
        Iterable filteredResources = Iterables.filter(resources, resource -> {
            Iterable resourceActions = (Iterable)resourceActionGenerator.apply(resource);
            if (resourceActions == null) {
                return false;
            }
            if (authorizer instanceof AllowAllAuthorizer) {
                return true;
            }
            for (ResourceAction resourceAction : resourceActions) {
                Access access = resultCache.computeIfAbsent(resourceAction, ra -> authorizer.authorize(authenticationResult, ra.getResource(), ra.getAction()));
                if (access.isAllowed()) continue;
                return false;
            }
            return true;
        });
        return filteredResources;
    }

    public static <KeyType, ResType> Map<KeyType, List<ResType>> filterAuthorizedResources(HttpServletRequest request, Map<KeyType, List<ResType>> unfilteredResources, Function<? super ResType, Iterable<ResourceAction>> resourceActionGenerator, AuthorizerMapper authorizerMapper) {
        if (request.getAttribute("Druid-Allow-Unsecured-Path") != null) {
            return unfilteredResources;
        }
        if (request.getAttribute("Druid-Authorization-Checked") != null) {
            throw new ISE("Request already had authorization check.", new Object[0]);
        }
        AuthenticationResult authenticationResult = AuthorizationUtils.authenticationResultFromRequest(request);
        HashMap<KeyType, ArrayList> filteredResources = new HashMap<KeyType, ArrayList>();
        for (Map.Entry<KeyType, List<ResType>> entry : unfilteredResources.entrySet()) {
            ArrayList filteredList;
            if (entry.getValue() == null || (filteredList = Lists.newArrayList(AuthorizationUtils.filterAuthorizedResources(authenticationResult, (Iterable)entry.getValue(), resourceActionGenerator, authorizerMapper))).size() <= 0) continue;
            filteredResources.put(entry.getKey(), filteredList);
        }
        request.setAttribute("Druid-Authorization-Checked", (Object)true);
        return filteredResources;
    }

    public static List<ResourceAction> makeSuperUserPermissions() {
        ArrayList<ResourceAction> allReadAndWrite = new ArrayList<ResourceAction>(ResourceType.knownTypes().size() * 2);
        for (String type : ResourceType.knownTypes()) {
            allReadAndWrite.add(new ResourceAction(new Resource(".*", type), Action.READ));
            allReadAndWrite.add(new ResourceAction(new Resource(".*", type), Action.WRITE));
        }
        return allReadAndWrite;
    }
}

