/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.indexer.CompactionEngine;

public class CompactionSupervisorConfig {
    private static final CompactionSupervisorConfig DEFAULT = new CompactionSupervisorConfig(null, null);
    @JsonProperty
    private final boolean enabled;
    @JsonProperty
    private final CompactionEngine engine;

    public static CompactionSupervisorConfig defaultConfig() {
        return DEFAULT;
    }

    @JsonCreator
    public CompactionSupervisorConfig(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="engine") @Nullable CompactionEngine engine) {
        this.enabled = Configs.valueOrDefault((Boolean)enabled, (boolean)false);
        this.engine = (CompactionEngine)Configs.valueOrDefault((Object)engine, (Object)CompactionEngine.NATIVE);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CompactionEngine getEngine() {
        return this.engine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionSupervisorConfig that = (CompactionSupervisorConfig)o;
        return this.enabled == that.enabled && this.engine == that.engine;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.engine);
    }

    public String toString() {
        return "CompactionSchedulerConfig{enabled=" + this.enabled + "engine=" + this.engine + "}";
    }
}

