/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.indexing;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientKillUnusedSegmentsTaskQuery;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.IndexingWorkerInfo;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.indexing.SegmentUpdateResponse;
import org.apache.druid.server.compaction.CompactionProgressResponse;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.http.SegmentsToUpdateFilter;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public interface OverlordClient {
    public ListenableFuture<URI> findCurrentLeader();

    public ListenableFuture<Void> runTask(String var1, Object var2);

    default public ListenableFuture<String> runKillTask(String idPrefix, String dataSource, Interval interval, @Nullable List<String> versions, @Nullable Integer maxSegmentsToKill, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        String taskId = IdUtils.newTaskId((String)idPrefix, (String)"kill", (String)dataSource, (Interval)interval);
        ClientKillUnusedSegmentsTaskQuery taskQuery = new ClientKillUnusedSegmentsTaskQuery(taskId, dataSource, interval, versions, null, maxSegmentsToKill, maxUsedStatusLastUpdatedTime);
        return FutureUtils.transform(this.runTask(taskId, taskQuery), ignored -> taskId);
    }

    public ListenableFuture<Void> cancelTask(String var1);

    public ListenableFuture<CloseableIterator<TaskStatusPlus>> taskStatuses(@Nullable String var1, @Nullable String var2, @Nullable Integer var3);

    public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> var1);

    public ListenableFuture<TaskStatusResponse> taskStatus(String var1);

    public ListenableFuture<TaskReport.ReportMap> taskReportAsMap(String var1);

    public ListenableFuture<TaskPayloadResponse> taskPayload(String var1);

    public ListenableFuture<CloseableIterator<SupervisorStatus>> supervisorStatuses();

    public ListenableFuture<Map<String, List<Interval>>> findLockedIntervals(List<LockFilterPolicy> var1);

    public ListenableFuture<Integer> killPendingSegments(String var1, Interval var2);

    public ListenableFuture<List<IndexingWorkerInfo>> getWorkers();

    public ListenableFuture<IndexingTotalWorkerCapacityInfo> getTotalWorkerCapacity();

    public ListenableFuture<Boolean> isCompactionSupervisorEnabled();

    public ListenableFuture<CompactionProgressResponse> getBytesAwaitingCompaction(String var1);

    public ListenableFuture<CompactionStatusResponse> getCompactionSnapshots(@Nullable String var1);

    public ListenableFuture<SegmentUpdateResponse> markNonOvershadowedSegmentsAsUsed(String var1);

    public ListenableFuture<SegmentUpdateResponse> markNonOvershadowedSegmentsAsUsed(String var1, SegmentsToUpdateFilter var2);

    public ListenableFuture<SegmentUpdateResponse> markSegmentAsUsed(SegmentId var1);

    public ListenableFuture<SegmentUpdateResponse> markSegmentsAsUnused(String var1);

    public ListenableFuture<SegmentUpdateResponse> markSegmentsAsUnused(String var1, SegmentsToUpdateFilter var2);

    public ListenableFuture<SegmentUpdateResponse> markSegmentAsUnused(SegmentId var1);

    public OverlordClient withRetryPolicy(ServiceRetryPolicy var1);
}

