/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularity;

public class ClientCompactionTaskGranularitySpec {
    private final Granularity segmentGranularity;
    private final Granularity queryGranularity;
    private final Boolean rollup;

    @JsonCreator
    public ClientCompactionTaskGranularitySpec(@JsonProperty(value="segmentGranularity") @Nullable Granularity segmentGranularity, @JsonProperty(value="queryGranularity") @Nullable Granularity queryGranularity, @JsonProperty(value="rollup") @Nullable Boolean rollup) {
        this.queryGranularity = queryGranularity;
        this.segmentGranularity = segmentGranularity;
        this.rollup = rollup;
    }

    @JsonProperty
    @Nullable
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @JsonProperty
    @Nullable
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty
    @Nullable
    public Boolean isRollup() {
        return this.rollup;
    }

    public ClientCompactionTaskGranularitySpec withSegmentGranularity(Granularity segmentGranularity) {
        return new ClientCompactionTaskGranularitySpec(segmentGranularity, this.queryGranularity, this.rollup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionTaskGranularitySpec that = (ClientCompactionTaskGranularitySpec)o;
        return Objects.equals(this.segmentGranularity, that.segmentGranularity) && Objects.equals(this.queryGranularity, that.queryGranularity) && Objects.equals(this.rollup, that.rollup);
    }

    public int hashCode() {
        return Objects.hash(this.segmentGranularity, this.queryGranularity, this.rollup);
    }

    public String toString() {
        return "ClientCompactionTaskGranularitySpec{segmentGranularity=" + this.segmentGranularity + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + "}";
    }
}

