/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.options;

import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobBeginCopySourceRequestConditions;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.RehydratePriority;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;
import java.util.Map;

public class BlobBeginCopyOptions {
    private final String sourceUrl;
    private Map<String, String> metadata;
    private Map<String, String> tags;
    private AccessTier tier;
    private RehydratePriority rehydratePriority;
    private BlobBeginCopySourceRequestConditions sourceRequestConditions;
    private BlobRequestConditions destinationRequestConditions;
    private Duration pollInterval;
    private Boolean sealDestination;
    private BlobImmutabilityPolicy immutabilityPolicy;
    private Boolean legalHold;

    public BlobBeginCopyOptions(String sourceUrl) {
        StorageImplUtils.assertNotNull((String)"sourceUrl", (Object)sourceUrl);
        this.sourceUrl = sourceUrl;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlobBeginCopyOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public BlobBeginCopyOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AccessTier getTier() {
        return this.tier;
    }

    public BlobBeginCopyOptions setTier(AccessTier tier) {
        this.tier = tier;
        return this;
    }

    public RehydratePriority getRehydratePriority() {
        return this.rehydratePriority;
    }

    public BlobBeginCopyOptions setRehydratePriority(RehydratePriority rehydratePriority) {
        this.rehydratePriority = rehydratePriority;
        return this;
    }

    public BlobBeginCopySourceRequestConditions getSourceRequestConditions() {
        return this.sourceRequestConditions;
    }

    public BlobBeginCopyOptions setSourceRequestConditions(BlobBeginCopySourceRequestConditions sourceRequestConditions) {
        this.sourceRequestConditions = sourceRequestConditions;
        return this;
    }

    public BlobRequestConditions getDestinationRequestConditions() {
        return this.destinationRequestConditions;
    }

    public BlobBeginCopyOptions setDestinationRequestConditions(BlobRequestConditions destinationRequestConditions) {
        this.destinationRequestConditions = destinationRequestConditions;
        return this;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public BlobBeginCopyOptions setPollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    public Boolean isSealDestination() {
        return this.sealDestination;
    }

    public BlobBeginCopyOptions setSealDestination(Boolean sealDestination) {
        this.sealDestination = sealDestination;
        return this;
    }

    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return this.immutabilityPolicy;
    }

    public BlobBeginCopyOptions setImmutabilityPolicy(BlobImmutabilityPolicy immutabilityPolicy) {
        this.immutabilityPolicy = immutabilityPolicy;
        return this;
    }

    public Boolean isLegalHold() {
        return this.legalHold;
    }

    public BlobBeginCopyOptions setLegalHold(Boolean legalHold) {
        this.legalHold = legalHold;
        return this;
    }
}

