/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.segment.indexing.IOConfig;
import org.joda.time.DateTime;

public abstract class SeekableStreamIndexTaskIOConfig<PartitionIdType, SequenceOffsetType>
implements IOConfig {
    private static final boolean DEFAULT_USE_TRANSACTION = true;
    @Nullable
    private final Integer taskGroupId;
    private final String baseSequenceName;
    private final SeekableStreamStartSequenceNumbers<PartitionIdType, SequenceOffsetType> startSequenceNumbers;
    private final SeekableStreamEndSequenceNumbers<PartitionIdType, SequenceOffsetType> endSequenceNumbers;
    private final boolean useTransaction;
    private final Optional<DateTime> minimumMessageTime;
    private final Optional<DateTime> maximumMessageTime;
    private final InputFormat inputFormat;
    private final Long refreshRejectionPeriodsInMinutes;

    public SeekableStreamIndexTaskIOConfig(@Nullable Integer taskGroupId, String baseSequenceName, SeekableStreamStartSequenceNumbers<PartitionIdType, SequenceOffsetType> startSequenceNumbers, SeekableStreamEndSequenceNumbers<PartitionIdType, SequenceOffsetType> endSequenceNumbers, Boolean useTransaction, DateTime minimumMessageTime, DateTime maximumMessageTime, @Nullable InputFormat inputFormat, @Nullable Long refreshRejectionPeriodsInMinutes) {
        this.taskGroupId = taskGroupId;
        this.baseSequenceName = (String)Preconditions.checkNotNull((Object)baseSequenceName, (Object)"baseSequenceName");
        this.startSequenceNumbers = (SeekableStreamStartSequenceNumbers)Preconditions.checkNotNull(startSequenceNumbers, (Object)"startSequenceNumbers");
        this.endSequenceNumbers = (SeekableStreamEndSequenceNumbers)Preconditions.checkNotNull(endSequenceNumbers, (Object)"endSequenceNumbers");
        this.useTransaction = useTransaction != null ? useTransaction : true;
        this.minimumMessageTime = Optional.fromNullable((Object)minimumMessageTime);
        this.maximumMessageTime = Optional.fromNullable((Object)maximumMessageTime);
        this.inputFormat = inputFormat;
        this.refreshRejectionPeriodsInMinutes = refreshRejectionPeriodsInMinutes;
        Preconditions.checkArgument((boolean)startSequenceNumbers.getStream().equals(endSequenceNumbers.getStream()), (Object)"start topic/stream and end topic/stream must match");
        Preconditions.checkArgument((boolean)startSequenceNumbers.getPartitionSequenceNumberMap().keySet().equals(endSequenceNumbers.getPartitionSequenceNumberMap().keySet()), (Object)"start partition set and end partition set must match");
    }

    @Nullable
    @JsonProperty
    public Integer getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty
    public String getBaseSequenceName() {
        return this.baseSequenceName;
    }

    @JsonProperty
    public SeekableStreamStartSequenceNumbers<PartitionIdType, SequenceOffsetType> getStartSequenceNumbers() {
        return this.startSequenceNumbers;
    }

    @JsonProperty
    public SeekableStreamEndSequenceNumbers<PartitionIdType, SequenceOffsetType> getEndSequenceNumbers() {
        return this.endSequenceNumbers;
    }

    @JsonProperty
    public boolean isUseTransaction() {
        return this.useTransaction;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<DateTime> getMaximumMessageTime() {
        return this.maximumMessageTime;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<DateTime> getMinimumMessageTime() {
        return this.minimumMessageTime;
    }

    @Nullable
    @JsonProperty(value="inputFormat")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private InputFormat getGivenInputFormat() {
        return this.inputFormat;
    }

    @Nullable
    public InputFormat getInputFormat() {
        return this.inputFormat;
    }

    @Nullable
    @JsonProperty
    public Long getRefreshRejectionPeriodsInMinutes() {
        return this.refreshRejectionPeriodsInMinutes;
    }
}

