/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.EqualDistributionWorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerCategorySpec;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerSelectUtils;

public class EqualDistributionWithCategorySpecWorkerSelectStrategy
implements WorkerSelectStrategy {
    private final WorkerCategorySpec workerCategorySpec;

    @JsonCreator
    public EqualDistributionWithCategorySpecWorkerSelectStrategy(@JsonProperty(value="workerCategorySpec") WorkerCategorySpec workerCategorySpec) {
        this.workerCategorySpec = workerCategorySpec;
    }

    @JsonProperty
    public WorkerCategorySpec getWorkerCategorySpec() {
        return this.workerCategorySpec;
    }

    @Override
    @Nullable
    public ImmutableWorkerInfo findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        return WorkerSelectUtils.selectWorker(task, zkWorkers, config, this.workerCategorySpec, EqualDistributionWorkerSelectStrategy::selectFromEligibleWorkers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualDistributionWithCategorySpecWorkerSelectStrategy that = (EqualDistributionWithCategorySpecWorkerSelectStrategy)o;
        return Objects.equals(this.workerCategorySpec, that.workerCategorySpec);
    }

    public int hashCode() {
        return Objects.hash(this.workerCategorySpec);
    }

    public String toString() {
        return "EqualDistributionWithCategorySpecWorkerSelectStrategy{workerCategorySpec=" + this.workerCategorySpec + "}";
    }
}

