/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionStat;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.joda.time.Interval;

public class GenericPartitionStat
implements PartitionStat {
    public static final String TYPE = "local";
    static final String PROP_SHARD_SPEC = "shardSpec";
    private final String taskExecutorHost;
    private final int taskExecutorPort;
    private final boolean useHttps;
    private final Interval interval;
    @Nullable
    private final Integer numRows;
    @Nullable
    private final Long sizeBytes;
    private final BucketNumberedShardSpec shardSpec;

    @JsonCreator
    public GenericPartitionStat(@JsonProperty(value="taskExecutorHost") String taskExecutorHost, @JsonProperty(value="taskExecutorPort") int taskExecutorPort, @JsonProperty(value="useHttps") boolean useHttps, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="shardSpec") BucketNumberedShardSpec shardSpec, @JsonProperty(value="numRows") @Nullable Integer numRows, @JsonProperty(value="sizeBytes") @Nullable Long sizeBytes) {
        this.taskExecutorHost = taskExecutorHost;
        this.taskExecutorPort = taskExecutorPort;
        this.useHttps = useHttps;
        this.interval = interval;
        this.numRows = numRows == null ? 0 : numRows;
        this.sizeBytes = sizeBytes == null ? 0L : sizeBytes;
        this.shardSpec = shardSpec;
    }

    @JsonProperty
    public final String getTaskExecutorHost() {
        return this.taskExecutorHost;
    }

    @JsonProperty
    public final int getTaskExecutorPort() {
        return this.taskExecutorPort;
    }

    @JsonProperty
    public final boolean isUseHttps() {
        return this.useHttps;
    }

    @Override
    @JsonProperty
    public final Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public final Integer getNumRows() {
        return this.numRows;
    }

    @Nullable
    @JsonProperty
    public final Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public int getBucketId() {
        return this.shardSpec.getBucketId();
    }

    @Override
    @JsonProperty(value="shardSpec")
    public BucketNumberedShardSpec getSecondaryPartition() {
        return this.shardSpec;
    }

    @Override
    public GenericPartitionLocation toPartitionLocation(String subtaskId, BuildingShardSpec secondaryParition) {
        return new GenericPartitionLocation(this.getTaskExecutorHost(), this.getTaskExecutorPort(), this.isUseHttps(), subtaskId, this.getInterval(), secondaryParition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericPartitionStat that = (GenericPartitionStat)o;
        return this.taskExecutorPort == that.taskExecutorPort && this.useHttps == that.useHttps && this.taskExecutorHost.equals(that.taskExecutorHost) && this.interval.equals((Object)that.interval) && Objects.equals(this.numRows, that.numRows) && Objects.equals(this.sizeBytes, that.sizeBytes) && this.shardSpec.equals(that.shardSpec);
    }

    public int hashCode() {
        return Objects.hash(this.taskExecutorHost, this.taskExecutorPort, this.useHttps, this.interval, this.numRows, this.sizeBytes, this.shardSpec);
    }

    public String toString() {
        return "GenericPartitionStat{taskExecutorHost='" + this.taskExecutorHost + "', taskExecutorPort=" + this.taskExecutorPort + ", useHttps=" + this.useHttps + ", interval=" + this.interval + ", numRows=" + this.numRows + ", sizeBytes=" + this.sizeBytes + ", shardSpec=" + this.shardSpec + "}";
    }
}

