/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;
import org.apache.druid.indexing.appenderator.ActionBasedSegmentAllocator;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.SurrogateTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.LinearlyPartitionedSequenceNameFunction;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.TaskLockHelper;
import org.apache.druid.indexing.common.task.batch.parallel.SupervisorTaskAccess;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwritePartialShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.joda.time.Interval;

public class OverlordCoordinatingSegmentAllocator
implements SegmentAllocatorForBatch {
    private final ActionBasedSegmentAllocator internalAllocator;
    private final LinearlyPartitionedSequenceNameFunction sequenceNameFunction;

    OverlordCoordinatingSegmentAllocator(TaskToolbox toolbox, String taskId, @Nullable SupervisorTaskAccess supervisorTaskAccess, DataSchema dataSchema, TaskLockHelper taskLockHelper, AbstractTask.IngestionMode ingestionMode, PartitionsSpec partitionsSpec) {
        TaskActionClient taskActionClient = supervisorTaskAccess == null ? toolbox.getTaskActionClient() : new SurrogateTaskActionClient(supervisorTaskAccess.getSupervisorTaskId(), toolbox.getTaskActionClient());
        this.internalAllocator = new ActionBasedSegmentAllocator(taskActionClient, dataSchema, (schema, row, sequenceName, previousSegmentId, skipSegmentLineageCheck) -> {
            GranularitySpec granularitySpec = schema.getGranularitySpec();
            Interval interval = (Interval)granularitySpec.bucketInterval(row.getTimestamp()).or((Object)granularitySpec.getSegmentGranularity().bucket(row.getTimestamp()));
            PartialShardSpec partialShardSpec = OverlordCoordinatingSegmentAllocator.createPartialShardSpec(ingestionMode, partitionsSpec, taskLockHelper, interval);
            return new SegmentAllocateAction(schema.getDataSource(), row.getTimestamp(), schema.getGranularitySpec().getQueryGranularity(), schema.getGranularitySpec().getSegmentGranularity(), sequenceName, previousSegmentId, skipSegmentLineageCheck, partialShardSpec, taskLockHelper.getLockGranularityToUse(), taskLockHelper.getLockTypeToUse());
        });
        this.sequenceNameFunction = new LinearlyPartitionedSequenceNameFunction(taskId);
    }

    @Nullable
    public SegmentIdWithShardSpec allocate(InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        return this.internalAllocator.allocate(row, sequenceName, previousSegmentId, skipSegmentLineageCheck);
    }

    private static PartialShardSpec createPartialShardSpec(AbstractTask.IngestionMode ingestionMode, PartitionsSpec partitionsSpec, TaskLockHelper taskLockHelper, Interval interval) {
        if (partitionsSpec.getType() == SecondaryPartitionType.LINEAR) {
            if (taskLockHelper.isUseSegmentLock() && taskLockHelper.hasOverwritingRootGenerationPartition(interval) && ingestionMode != AbstractTask.IngestionMode.APPEND) {
                TaskLockHelper.OverwritingRootGenerationPartitions overwritingRootGenerationPartitions = taskLockHelper.getOverwritingRootGenerationPartition(interval);
                if (overwritingRootGenerationPartitions == null) {
                    throw new ISE("Can't find overwritingSegmentMeta for interval[%s]", new Object[]{interval});
                }
                return new NumberedOverwritePartialShardSpec(overwritingRootGenerationPartitions.getStartRootPartitionId(), overwritingRootGenerationPartitions.getEndRootPartitionId(), overwritingRootGenerationPartitions.getMinorVersionForNewSegments());
            }
            return NumberedPartialShardSpec.instance();
        }
        throw new ISE("%s is not supported for partitionsSpec[%s]", new Object[]{OverlordCoordinatingSegmentAllocator.class.getName(), partitionsSpec.getClass().getName()});
    }

    @Override
    public SequenceNameFunction getSequenceNameFunction() {
        return this.sequenceNameFunction;
    }
}

