/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import org.apache.druid.indexing.appenderator.ActionBasedPublishedSegmentRetriever;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.PublishedSegmentRetriever;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;

public final class BatchAppenderators {
    public static Appenderator newAppenderator(String taskId, AppenderatorsManager appenderatorsManager, SegmentGenerationMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, AppenderatorConfig appenderatorConfig, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, boolean useMaxMemoryEstimates) {
        return BatchAppenderators.newAppenderator(taskId, appenderatorsManager, metrics, toolbox, dataSchema, appenderatorConfig, toolbox.getSegmentPusher(), rowIngestionMeters, parseExceptionHandler, useMaxMemoryEstimates);
    }

    public static Appenderator newAppenderator(String taskId, AppenderatorsManager appenderatorsManager, SegmentGenerationMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, AppenderatorConfig appenderatorConfig, DataSegmentPusher segmentPusher, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, boolean useMaxMemoryEstimates) {
        return appenderatorsManager.createBatchAppenderatorForTask(taskId, dataSchema, appenderatorConfig.withBasePersistDirectory(toolbox.getPersistDir()), metrics, segmentPusher, toolbox.getJsonMapper(), toolbox.getIndexIO(), (IndexMerger)toolbox.getIndexMergerV9(), rowIngestionMeters, parseExceptionHandler, useMaxMemoryEstimates, toolbox.getCentralizedTableSchemaConfig());
    }

    public static BatchAppenderatorDriver newDriver(Appenderator appenderator, TaskToolbox toolbox, SegmentAllocator segmentAllocator) {
        return new BatchAppenderatorDriver(appenderator, segmentAllocator, (PublishedSegmentRetriever)new ActionBasedPublishedSegmentRetriever(toolbox.getTaskActionClient()), toolbox.getDataSegmentKiller());
    }

    private BatchAppenderators() {
    }
}

