/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.bloom.sql;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.bloom.BloomFilterAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DefaultOperandTypeChecker;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class BloomFilterSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction FUNCTION_INSTANCE = new BloomFilterSqlAggFunction();
    private static final String NAME = "BLOOM_FILTER";

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        DefaultDimensionSpec spec;
        RexNode inputOperand = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(0)).intValue());
        DruidExpression input = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)inputAccessor.getInputRowSignature(), (RexNode)inputOperand);
        if (input == null) {
            return null;
        }
        RexNode maxNumEntriesOperand = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(1)).intValue());
        if (!maxNumEntriesOperand.isA(SqlKind.LITERAL)) {
            return null;
        }
        int maxNumEntries = ((Number)((Object)RexLiteral.value((RexNode)maxNumEntriesOperand))).intValue();
        for (Aggregation existing : existingAggregations) {
            for (AggregatorFactory factory : existing.getAggregatorFactories()) {
                if (!(factory instanceof BloomFilterAggregatorFactory)) continue;
                BloomFilterAggregatorFactory theFactory = (BloomFilterAggregatorFactory)factory;
                DruidExpression virtualInput = virtualColumnRegistry.findVirtualColumnExpressions(theFactory.requiredFields()).stream().findFirst().orElse(null);
                boolean inputMatches = virtualInput == null ? (input.isDirectColumnAccess() ? input.getDirectColumn().equals(theFactory.getField().getDimension()) : input.getSimpleExtraction().getColumn().equals(theFactory.getField().getDimension()) && input.getSimpleExtraction().getExtractionFn().equals(theFactory.getField().getExtractionFn())) : virtualInput.equals((Object)input);
                boolean matches = inputMatches && theFactory.getMaxNumEntries() == maxNumEntries;
                if (!matches) continue;
                return Aggregation.create((AggregatorFactory)theFactory);
            }
        }
        ColumnType valueType = Calcites.getColumnTypeForRelDataType((RelDataType)inputOperand.getType());
        if (input.isDirectColumnAccess()) {
            spec = new DefaultDimensionSpec(input.getSimpleExtraction().getColumn(), StringUtils.format((String)"%s:%s", (Object[])new Object[]{name, input.getSimpleExtraction().getColumn()}), valueType);
        } else if (input.isSimpleExtraction()) {
            spec = new ExtractionDimensionSpec(input.getSimpleExtraction().getColumn(), StringUtils.format((String)"%s:%s", (Object[])new Object[]{name, input.getSimpleExtraction().getColumn()}), valueType, input.getSimpleExtraction().getExtractionFn());
        } else {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(input, inputOperand.getType());
            spec = new DefaultDimensionSpec(virtualColumnName, StringUtils.format((String)"%s:%s", (Object[])new Object[]{name, virtualColumnName}));
        }
        BloomFilterAggregatorFactory aggregatorFactory = new BloomFilterAggregatorFactory(name, (DimensionSpec)spec, maxNumEntries);
        return Aggregation.create((AggregatorFactory)aggregatorFactory);
    }

    private static class BloomFilterSqlAggFunction
    extends SqlAggFunction {
        BloomFilterSqlAggFunction() {
            super(BloomFilterSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, Calcites.complexReturnTypeWithNullability((ColumnType)BloomFilterAggregatorFactory.TYPE, (boolean)false), null, (SqlOperandTypeChecker)DefaultOperandTypeChecker.builder().operandNames(new String[]{"column", "maxNumEntries"}).operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC}).literalOperands(new int[]{1}).requiredOperandCount(Integer.valueOf(2)).build(), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.FORBIDDEN);
        }
    }
}

