/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;

@ApplicationScoped
public class ProjectStageProducer
implements Serializable {
    public static final String[] CONFIG_SETTING_KEYS = new String[]{"org.apache.deltaspike.ProjectStage", "javax.faces.PROJECT_STAGE", "faces.PROJECT_STAGE"};
    protected static final Logger LOG = Logger.getLogger(ProjectStageProducer.class.getName());
    private static final long serialVersionUID = -2987762608635612074L;
    private static volatile ProjectStage projectStage;
    private static volatile ProjectStageProducer projectStageProducer;

    protected ProjectStageProducer() {
    }

    @Produces
    @Dependent
    @Default
    public ProjectStage getProjectStage() {
        if (projectStage == null) {
            ProjectStageProducer.getInstance();
        }
        return projectStage;
    }

    public static ProjectStageProducer getInstance() {
        if (projectStageProducer == null) {
            ProjectStageProducer.lazyInit();
        }
        if (projectStage == null) {
            projectStageProducer.initProjectStage();
        }
        return projectStageProducer;
    }

    private static synchronized void lazyInit() {
        if (projectStageProducer != null) {
            return;
        }
        ProjectStageProducer newProjectStageProducer = new ProjectStageProducer();
        newProjectStageProducer.initProjectStage();
        projectStageProducer = newProjectStageProducer;
    }

    protected ProjectStage resolveProjectStage() {
        for (String configLocation : CONFIG_SETTING_KEYS) {
            String stageName = ConfigResolver.getPropertyValue(configLocation);
            if (stageName == null || stageName.isEmpty()) continue;
            return ProjectStage.valueOf(stageName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initProjectStage() {
        Class<ProjectStageProducer> clazz = ProjectStageProducer.class;
        synchronized (ProjectStageProducer.class) {
            if (projectStage == null) {
                projectStage = this.resolveProjectStage();
                if (projectStage == null) {
                    projectStage = ProjectStage.Production;
                }
                LOG.info("Computed the following DeltaSpike ProjectStage: " + projectStage);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void reset() {
        ProjectStageProducer.resetCache();
    }

    private static void resetCache() {
        projectStage = null;
        projectStageProducer = null;
    }

    public static void setProjectStage(ProjectStage ps) {
        if (projectStage == null) {
            LOG.info("change project-stage to " + ps);
        } else if (!projectStage.equals(ps)) {
            LOG.info("change project-stage from " + projectStage + " to " + ps);
        }
        projectStage = ps;
    }
}

