/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.reflect.Converter;
import org.apache.cayenne.reflect.EnumConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConverterFactory {
    static final ConverterFactory factory = new ConverterFactory();
    private Map<String, Converter> converters;
    private EnumConverter enumConveter = new EnumConverter();
    static final Converter noopConverter = new Converter(){

        @Override
        Object convert(Object object, Class<?> type) {
            return object;
        }
    };

    private ConverterFactory() {
        Converter stringConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                return object != null ? object.toString() : null;
            }
        };
        Converter booleanConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return type.isPrimitive() ? Boolean.FALSE : null;
                }
                if (object instanceof Boolean) {
                    return object;
                }
                return "true".equalsIgnoreCase(object.toString()) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        Converter intConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return type.isPrimitive() ? Integer.valueOf(0) : null;
                }
                if (object instanceof Integer) {
                    return object;
                }
                return new Integer(object.toString());
            }
        };
        Converter byteConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return type.isPrimitive() ? Byte.valueOf((byte)0) : null;
                }
                if (object instanceof Byte) {
                    return object;
                }
                return new Byte(object.toString());
            }
        };
        Converter shortConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return type.isPrimitive() ? Short.valueOf((short)0) : null;
                }
                if (object instanceof Short) {
                    return object;
                }
                return new Short(object.toString());
            }
        };
        Converter charConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return type.isPrimitive() ? Character.valueOf('\u0000') : null;
                }
                if (object instanceof Character) {
                    return object;
                }
                String string = object.toString();
                return Character.valueOf(string.length() > 0 ? string.charAt(0) : (char)'\u0000');
            }
        };
        Converter doubleConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return type.isPrimitive() ? new Double(0.0) : null;
                }
                if (object instanceof Double) {
                    return object;
                }
                return new Double(object.toString());
            }
        };
        Converter floatConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return type.isPrimitive() ? new Float(0.0f) : null;
                }
                if (object instanceof Float) {
                    return object;
                }
                return new Float(object.toString());
            }
        };
        Converter bigDecimalConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return null;
                }
                if (object instanceof BigDecimal) {
                    return object;
                }
                return new BigDecimal(object.toString());
            }
        };
        Converter bigIntegerConverter = new Converter(){

            @Override
            Object convert(Object object, Class<?> type) {
                if (object == null) {
                    return null;
                }
                if (object instanceof BigInteger) {
                    return object;
                }
                return new BigInteger(object.toString());
            }
        };
        this.converters = new HashMap<String, Converter>();
        this.converters.put(Boolean.class.getName(), booleanConverter);
        this.converters.put("boolean", booleanConverter);
        this.converters.put(Short.class.getName(), shortConverter);
        this.converters.put("short", shortConverter);
        this.converters.put(Byte.class.getName(), byteConverter);
        this.converters.put("byte", byteConverter);
        this.converters.put(Integer.class.getName(), intConverter);
        this.converters.put("int", intConverter);
        this.converters.put(Double.class.getName(), doubleConverter);
        this.converters.put("double", doubleConverter);
        this.converters.put(Float.class.getName(), floatConverter);
        this.converters.put("float", floatConverter);
        this.converters.put(Character.class.getName(), charConverter);
        this.converters.put("char", charConverter);
        this.converters.put(BigDecimal.class.getName(), bigDecimalConverter);
        this.converters.put(BigInteger.class.getName(), bigIntegerConverter);
        this.converters.put(Number.class.getName(), bigDecimalConverter);
        this.converters.put(String.class.getName(), stringConverter);
    }

    Converter getConverter(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (type.isEnum()) {
            return this.enumConveter;
        }
        Converter c = this.converters.get(type.getName());
        return c != null ? c : noopConverter;
    }
}

