/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ObjEntityValidator
extends ConfigurationNodeValidator {
    ObjEntityValidator() {
    }

    void validate(ObjEntity entity, ValidationResult validationResult) {
        this.validateName(entity, validationResult);
        this.validateClassName(entity, validationResult);
        this.validateSuperClassName(entity, validationResult);
        if (entity.getDbEntity() == null && !entity.isAbstract()) {
            this.addFailure(validationResult, entity, "ObjEntity '%s' has no DbEntity mapping", entity.getName());
        }
    }

    void validateClassName(ObjEntity entity, ValidationResult validationResult) {
        String className = entity.getClassName();
        if (Util.isEmptyString((String)className)) {
            return;
        }
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(className);
        if (invalidChars != null) {
            this.addFailure(validationResult, entity, "ObjEntity '%s' Java class '%s' contains invalid characters: %s", entity.getName(), className, invalidChars);
        } else if (helper.invalidDataObjectClass(className)) {
            this.addFailure(validationResult, entity, "Java class '%s' of ObjEntity '%s' is a reserved word", className, entity.getName());
        } else if (className.indexOf(46) < 0) {
            this.addFailure(validationResult, entity, "Java class '%s' of ObjEntity '%s' is in a default package", className, entity.getName());
        }
    }

    void validateSuperClassName(ObjEntity entity, ValidationResult validationResult) {
        DataMap map;
        String superClassName = entity.getSuperClassName();
        if (Util.isEmptyString((String)superClassName)) {
            return;
        }
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(superClassName);
        if (invalidChars != null) {
            this.addFailure(validationResult, entity, "ObjEntity '%s' Java superclass '%s' contains invalid characters: %s", entity.getName(), superClassName, invalidChars);
        } else if (helper.invalidDataObjectClass(superClassName)) {
            this.addFailure(validationResult, entity, "ObjEntity '%s' Java superclass '%s' is a reserved word", entity.getName(), superClassName);
        }
        if (entity.getDbEntityName() != null && entity.getSuperEntityName() != null) {
            this.addFailure(validationResult, entity, "Sub ObjEntity '%s' has database table declaration different from super ObjEntity '%s'", entity.getName(), entity.getSuperEntityName());
        }
        if ((map = entity.getDataMap()) == null) {
            return;
        }
    }

    void validateName(ObjEntity entity, ValidationResult validationResult) {
        DataChannelDescriptor domain;
        String name = entity.getName();
        if (Util.isEmptyString((String)name)) {
            this.addFailure(validationResult, entity, "Unnamed ObjEntity", new Object[0]);
            return;
        }
        DataMap map = entity.getDataMap();
        if (map == null) {
            return;
        }
        for (ObjEntity otherEnt : map.getObjEntities()) {
            if (otherEnt == entity || !name.equals(otherEnt.getName())) continue;
            this.addFailure(validationResult, entity, "Duplicate ObjEntity name: '%s'", name);
            break;
        }
        if ((domain = entity.getDataMap().getDataChannelDescriptor()) != null) {
            for (DataMap nextMap : domain.getDataMaps()) {
                ObjEntity conflictingEntity;
                if (nextMap == map || (conflictingEntity = nextMap.getObjEntity(name)) == null || Util.nullSafeEquals((Object)conflictingEntity.getClassName(), (Object)entity.getClassName())) continue;
                this.addFailure(validationResult, entity, "Duplicate ObjEntity name in another DataMap: '%s'", name);
                break;
            }
        }
    }
}

