/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileFilters {
    protected static final FileFilter applicationFilter = new ApplicationFileFilter();
    protected static final FileFilter velotemplateFilter = new VelotemplateFileFilter();
    protected static final FileFilter eomodelFilter = new EOModelFileFilter();
    protected static final FileFilter eomodelSelectFilter = new EOModelSelectFilter();
    protected static final FileFilter dataMapFilter = new DataMapFileFilter();
    protected static final FileFilter classArchiveFilter = new JavaClassArchiveFilter();
    private static final String DATA_MAP_LOCATION_SUFFIX = ".map.xml";

    public static FileFilter getClassArchiveFilter() {
        return classArchiveFilter;
    }

    public static FileFilter getApplicationFilter() {
        return applicationFilter;
    }

    public static FileFilter getDataMapFilter() {
        return dataMapFilter;
    }

    public static FileFilter getVelotemplateFilter() {
        return velotemplateFilter;
    }

    public static FileFilter getEOModelFilter() {
        return eomodelFilter;
    }

    public static FileFilter getEOModelSelectFilter() {
        return eomodelSelectFilter;
    }

    public static FileFilter getExtensionFileFilter(String ext, String description) {
        return new ExtensionFileFilter(ext, description);
    }

    static final class ExtensionFileFilter
    extends FileFilter {
        String ext;
        String description;

        ExtensionFileFilter(String ext, String description) {
            this.ext = ext;
            this.description = description;
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith("." + this.ext);
        }

        public String getDescription() {
            return this.description + "(." + this.ext + ")";
        }
    }

    static final class EOModelSelectFilter
    extends FileFilter {
        EOModelSelectFilter() {
        }

        public boolean accept(File f) {
            File parent;
            return f.isDirectory() ? f.getName().endsWith(".eomodeld") && new File(f, "index.eomodeld").exists() : f.isFile() && (parent = f.getParentFile()) != null && parent.getName().endsWith(".eomodeld") && "index.eomodeld".equals(f.getName());
        }

        public String getDescription() {
            return "*.eomodeld";
        }
    }

    static final class EOModelFileFilter
    extends FileFilter {
        static final String EOM_SUFFIX = ".eomodeld";
        static final String EOM_INDEX = "index.eomodeld";

        EOModelFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            File parent = f.getParentFile();
            return parent != null && parent.getName().endsWith(EOM_SUFFIX) && EOM_INDEX.equals(f.getName());
        }

        public String getDescription() {
            return "*.eomodeld";
        }
    }

    static final class DataMapFileFilter
    extends FileFilter {
        DataMapFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.endsWith(FileFilters.DATA_MAP_LOCATION_SUFFIX) && !name.equals(FileFilters.DATA_MAP_LOCATION_SUFFIX);
        }

        public String getDescription() {
            return "DataMaps (*.map.xml)";
        }
    }

    static final class ApplicationFileFilter
    extends FileFilter {
        ApplicationFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().startsWith("cayenne") && f.getName().endsWith(".xml");
        }

        public String getDescription() {
            return "Cayenne Applications (cayenne*.xml)";
        }
    }

    static final class VelotemplateFileFilter
    extends FileFilter {
        VelotemplateFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.endsWith(".vm") && !name.equals(".vm");
        }

        public String getDescription() {
            return "Velocity Templates (*.vm)";
        }
    }

    static final class JavaClassArchiveFilter
    extends FileFilter {
        JavaClassArchiveFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            return name.length() > 4 && (name.endsWith(".jar") || name.endsWith(".zip"));
        }

        public String getDescription() {
            return "Java Class Archive (*.jar,*.zip)";
        }
    }
}

