/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateNodeUndoableEdit
extends CayenneUndoableEdit {
    private DataNodeDescriptor node;
    private DataChannelDescriptor domain = (DataChannelDescriptor)Application.getInstance().getProject().getRootNode();

    public String getPresentationName() {
        return "Create DataNode";
    }

    public CreateNodeUndoableEdit(Application application, DataNodeDescriptor node) {
        this.node = node;
    }

    public void undo() throws CannotUndoException {
        RemoveAction action = this.actionManager.getAction(RemoveAction.class);
        action.removeDataNode(this.node);
    }

    public void redo() throws CannotRedoException {
        this.domain.getNodeDescriptors().add(this.node);
        CreateNodeAction action = this.actionManager.getAction(CreateNodeAction.class);
        action.createDataNode(this.node);
    }
}

