/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubclassTypeFactory
implements ExtendedTypeFactory {
    private ExtendedType type;
    private Class<?> javaClass;

    SubclassTypeFactory(ExtendedType type) {
        this.type = type;
        try {
            this.javaClass = Util.getJavaClass(type.getClassName());
            if (this.javaClass.isArray() || this.javaClass.equals(Object.class) || this.javaClass.isPrimitive()) {
                this.javaClass = null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public ExtendedType getType(Class<?> objectClass) {
        if (this.javaClass != null && this.javaClass.isAssignableFrom(objectClass)) {
            return this.type;
        }
        return null;
    }
}

