/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLExpression;

public class EJBQLSelectTranslator
extends EJBQLBaseVisitor {
    protected EJBQLTranslationContext context;

    protected EJBQLSelectTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    EJBQLTranslationContext getContext() {
        return this.context;
    }

    public boolean visitDistinct(EJBQLExpression expression) {
        this.context.pushMarker(this.context.makeDistinctMarker(), true);
        this.context.append(" DISTINCT");
        this.context.popMarker();
        return true;
    }

    public boolean visitFrom(EJBQLExpression expression, int finishedChildIndex) {
        this.context.append(" FROM");
        this.context.setAppendingResultColumns(false);
        expression.visit(this.context.getTranslatorFactory().getFromTranslator(this.context));
        this.context.markCurrentPosition(this.context.makeWhereMarker());
        this.context.markCurrentPosition(this.context.makeEntityQualifierMarker());
        return false;
    }

    public boolean visitGroupBy(EJBQLExpression expression) {
        this.context.append(" GROUP BY");
        expression.visit(this.context.getTranslatorFactory().getGroupByTranslator(this.context));
        return false;
    }

    public boolean visitHaving(EJBQLExpression expression) {
        this.context.append(" HAVING");
        expression.visit(this.context.getTranslatorFactory().getConditionTranslator(this.context));
        return false;
    }

    public boolean visitOrderBy(EJBQLExpression expression) {
        this.context.append(" ORDER BY");
        expression.visit(this.context.getTranslatorFactory().getOrderByTranslator(this.context));
        return false;
    }

    public boolean visitSelect(EJBQLExpression expression) {
        this.context.setAppendingResultColumns(true);
        return true;
    }

    public boolean visitSelectClause(EJBQLExpression expression) {
        this.context.append("SELECT");
        this.context.markCurrentPosition(this.context.makeDistinctMarker());
        return true;
    }

    public boolean visitSelectExpressions(EJBQLExpression expression) {
        expression.visit(this.context.getTranslatorFactory().getSelectColumnsTranslator(this.context));
        return false;
    }

    public boolean visitWhere(EJBQLExpression expression) {
        this.context.pushMarker(this.context.makeWhereMarker(), true);
        this.context.append(" WHERE");
        this.context.popMarker();
        if (this.context.findOrCreateMarkedBuffer(this.context.makeEntityQualifierMarker()).length() > 0) {
            this.context.append(" AND");
        }
        expression.visit(this.context.getTranslatorFactory().getConditionTranslator(this.context));
        return false;
    }
}

