/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.federated;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.commons.configuration2.Configuration;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientUtils;
import org.apache.distributedlog.callback.NamespaceListener;
import org.apache.distributedlog.exceptions.LogExistsException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.impl.federated.FederatedZKLogMetadataStore;
import org.apache.distributedlog.util.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestFederatedZKLogMetadataStore
extends TestDistributedLogBase {
    private static final int zkSessionTimeoutMs = 2000;
    private static final int maxLogsPerSubnamespace = 10;
    @Rule
    public TestName runtime = new TestName();
    protected final DistributedLogConfiguration baseConf = new DistributedLogConfiguration().setFederatedMaxLogsPerSubnamespace(10);
    protected ZooKeeperClient zkc;
    protected FederatedZKLogMetadataStore metadataStore;
    protected OrderedScheduler scheduler;
    protected URI uri;

    @Override
    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createDLMURI("/")).sessionTimeoutMs(2000).build();
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-zk-logmetadata-store").numThreads(2).build();
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.addConfiguration((Configuration)this.baseConf);
        this.uri = this.createDLMURI("/" + this.runtime.getMethodName());
        FederatedZKLogMetadataStore.createFederatedNamespace((URI)this.uri, (ZooKeeperClient)this.zkc);
        this.metadataStore = new FederatedZKLogMetadataStore(conf, this.uri, this.zkc, this.scheduler);
    }

    @Override
    @After
    public void teardown() throws Exception {
        if (null != this.zkc) {
            this.zkc.close();
        }
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    private void deleteLog(String logName) throws Exception {
        Optional logUriOptional = (Optional)Utils.ioResult((CompletableFuture)this.metadataStore.getLogLocation(logName));
        Assert.assertTrue((boolean)logUriOptional.isPresent());
        URI logUri = (URI)logUriOptional.get();
        this.zkc.get().delete(logUri.getPath() + "/" + logName, -1);
    }

    @Test(timeout=60000L)
    public void testBasicOperations() throws Exception {
        TestNamespaceListener listener = new TestNamespaceListener();
        this.metadataStore.registerNamespaceListener((NamespaceListener)listener);
        String logName = "test-log-1";
        URI logUri = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
        Assert.assertEquals((Object)this.uri, (Object)logUri);
        Optional logLocation = (Optional)Utils.ioResult((CompletableFuture)this.metadataStore.getLogLocation(logName));
        Assert.assertTrue((boolean)logLocation.isPresent());
        Assert.assertEquals((Object)this.uri, logLocation.get());
        Optional notExistLogLocation = (Optional)Utils.ioResult((CompletableFuture)this.metadataStore.getLogLocation("non-existent-log"));
        Assert.assertFalse((boolean)notExistLogLocation.isPresent());
        listener.waitForDone();
        Iterator<String> logsIter = listener.getResult();
        Assert.assertTrue((boolean)logsIter.hasNext());
        Assert.assertEquals((Object)logName, (Object)logsIter.next());
        Assert.assertFalse((boolean)logsIter.hasNext());
        Iterator newLogsIter = (Iterator)Utils.ioResult((CompletableFuture)this.metadataStore.getLogs(""));
        Assert.assertTrue((boolean)newLogsIter.hasNext());
        Assert.assertEquals((Object)logName, newLogsIter.next());
        Assert.assertFalse((boolean)newLogsIter.hasNext());
    }

    @Test(timeout=60000L)
    public void testMultipleListeners() throws Exception {
        TestNamespaceListener listener1 = new TestNamespaceListener();
        TestNamespaceListener listener2 = new TestNamespaceListener();
        this.metadataStore.registerNamespaceListener((NamespaceListener)listener1);
        this.metadataStore.registerNamespaceListener((NamespaceListener)listener2);
        String logName = "test-multiple-listeners";
        URI logUri = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
        Assert.assertEquals((Object)this.uri, (Object)logUri);
        listener1.waitForDone();
        listener2.waitForDone();
        Iterator<String> logsIter1 = listener1.getResult();
        Iterator<String> logsIter2 = listener2.getResult();
        Assert.assertTrue((boolean)Iterators.elementsEqual(logsIter1, logsIter2));
    }

    @Test(timeout=60000L)
    public void testCreateLog() throws Exception {
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.addConfiguration((Configuration)this.baseConf);
        ZooKeeperClient anotherZkc = TestZooKeeperClientBuilder.newBuilder().uri(this.uri).sessionTimeoutMs(2000).build();
        FederatedZKLogMetadataStore anotherMetadataStore = new FederatedZKLogMetadataStore(conf, this.uri, anotherZkc, this.scheduler);
        for (int i = 0; i < 20; ++i) {
            FederatedZKLogMetadataStore checkStore;
            FederatedZKLogMetadataStore createStore;
            if (i % 2 == 0) {
                createStore = this.metadataStore;
                checkStore = anotherMetadataStore;
            } else {
                createStore = anotherMetadataStore;
                checkStore = this.metadataStore;
            }
            String logName = "test-create-log-" + i;
            URI logUri = (URI)Utils.ioResult((CompletableFuture)createStore.createLog(logName));
            Optional logLocation = (Optional)Utils.ioResult((CompletableFuture)checkStore.getLogLocation(logName));
            Assert.assertTrue((String)("Log " + logName + " doesn't exist"), (boolean)logLocation.isPresent());
            Assert.assertEquals((String)("Different log location " + logLocation.get() + " is found"), (Object)logUri, logLocation.get());
        }
        Assert.assertEquals((long)2L, (long)this.metadataStore.getSubnamespaces().size());
        Assert.assertEquals((long)2L, (long)anotherMetadataStore.getSubnamespaces().size());
    }

    @Test(timeout=60000L)
    public void testDuplicatedLogs() throws Exception {
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.addConfiguration((Configuration)this.baseConf);
        String logName = "test-log";
        Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
        URI subNs1 = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createSubNamespace());
        URI subNs2 = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createSubNamespace());
        String duplicatedLogName = "test-duplicated-logs";
        this.metadataStore.createLogInNamespaceSync(subNs1, duplicatedLogName);
        this.metadataStore.createLogInNamespaceSync(subNs2, duplicatedLogName);
        try {
            Utils.ioResult((CompletableFuture)this.metadataStore.createLog("non-existent-log"));
            Assert.fail((String)"should throw exception when duplicated log found");
        }
        catch (UnexpectedException ue) {
            Assert.assertTrue((boolean)this.metadataStore.duplicatedLogFound.get());
        }
        try {
            Utils.ioResult((CompletableFuture)this.metadataStore.getLogLocation(logName));
            Assert.fail((String)"should throw exception when duplicated log found");
        }
        catch (UnexpectedException ue) {
            Assert.assertTrue((boolean)this.metadataStore.duplicatedLogFound.get());
        }
        try {
            Utils.ioResult((CompletableFuture)this.metadataStore.getLogLocation("non-existent-log"));
            Assert.fail((String)"should throw exception when duplicated log found");
        }
        catch (UnexpectedException ue) {
            Assert.assertTrue((boolean)this.metadataStore.duplicatedLogFound.get());
        }
        try {
            Utils.ioResult((CompletableFuture)this.metadataStore.getLogLocation(duplicatedLogName));
            Assert.fail((String)"should throw exception when duplicated log found");
        }
        catch (UnexpectedException ue) {
            Assert.assertTrue((boolean)this.metadataStore.duplicatedLogFound.get());
        }
        try {
            Utils.ioResult((CompletableFuture)this.metadataStore.getLogs(""));
            Assert.fail((String)"should throw exception when duplicated log found");
        }
        catch (UnexpectedException ue) {
            Assert.assertTrue((boolean)this.metadataStore.duplicatedLogFound.get());
        }
    }

    @Test(timeout=60000L)
    public void testGetLogLocationWhenCacheMissed() throws Exception {
        String logName = "test-get-location-when-cache-missed";
        URI logUri = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
        Assert.assertEquals((Object)this.uri, (Object)logUri);
        this.metadataStore.removeLogFromCache(logName);
        Optional logLocation = (Optional)Utils.ioResult((CompletableFuture)this.metadataStore.getLogLocation(logName));
        Assert.assertTrue((boolean)logLocation.isPresent());
        Assert.assertEquals((Object)logUri, logLocation.get());
    }

    @Test(timeout=60000L, expected=LogExistsException.class)
    public void testCreateLogWhenCacheMissed() throws Exception {
        String logName = "test-create-log-when-cache-missed";
        URI logUri = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
        Assert.assertEquals((Object)this.uri, (Object)logUri);
        this.metadataStore.removeLogFromCache(logName);
        Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
    }

    @Test(timeout=60000L, expected=LogExistsException.class)
    public void testCreateLogWhenLogExists() throws Exception {
        String logName = "test-create-log-when-log-exists";
        URI logUri = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
        Assert.assertEquals((Object)this.uri, (Object)logUri);
        Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
    }

    private Set<String> createLogs(int numLogs, String prefix) throws Exception {
        TreeSet expectedLogs = Sets.newTreeSet();
        for (int i = 0; i < numLogs; ++i) {
            String logName = prefix + i;
            Utils.ioResult((CompletableFuture)this.metadataStore.createLog(logName));
            expectedLogs.add(logName);
        }
        return expectedLogs;
    }

    private Set<String> createLogs(URI uri, int numLogs, String prefix) throws Exception {
        TreeSet expectedLogs = Sets.newTreeSet();
        for (int i = 0; i < numLogs; ++i) {
            String logName = prefix + i;
            this.metadataStore.createLogInNamespaceSync(uri, logName);
            expectedLogs.add(logName);
        }
        return expectedLogs;
    }

    @Test(timeout=60000L)
    public void testGetLogs() throws Exception {
        TreeSet receivedLogs;
        int numLogs = 30;
        Set<String> expectedLogs = this.createLogs(numLogs, "test-get-logs");
        do {
            TimeUnit.MILLISECONDS.sleep(20L);
            receivedLogs = new TreeSet();
            Iterator logs = (Iterator)Utils.ioResult((CompletableFuture)this.metadataStore.getLogs(""));
            receivedLogs.addAll(Lists.newArrayList((Iterator)logs));
        } while (receivedLogs.size() < numLogs);
        Assert.assertEquals((long)numLogs, (long)receivedLogs.size());
        Assert.assertTrue((boolean)Sets.difference(expectedLogs, receivedLogs).isEmpty());
    }

    @Test(timeout=60000L)
    public void testNamespaceListener() throws Exception {
        int numLogs = 30;
        TestNamespaceListenerWithExpectedSize listener = new TestNamespaceListenerWithExpectedSize(numLogs);
        this.metadataStore.registerNamespaceListener((NamespaceListener)listener);
        Set<String> expectedLogs = this.createLogs(numLogs, "test-namespace-listener");
        listener.waitForDone();
        Set<String> receivedLogs = listener.getResult();
        Assert.assertEquals((long)numLogs, (long)receivedLogs.size());
        Assert.assertTrue((boolean)Sets.difference(expectedLogs, receivedLogs).isEmpty());
        Random r = new Random(System.currentTimeMillis());
        int logId = r.nextInt(numLogs);
        String logName = "test-namespace-listener" + logId;
        TestNamespaceListener deleteListener = new TestNamespaceListener();
        this.metadataStore.registerNamespaceListener((NamespaceListener)deleteListener);
        this.deleteLog(logName);
        deleteListener.waitForDone();
        TreeSet logsAfterDeleted = Sets.newTreeSet((Iterable)Lists.newArrayList(deleteListener.getResult()));
        Assert.assertEquals((long)(numLogs - 1), (long)logsAfterDeleted.size());
        expectedLogs.remove(logName);
        Assert.assertTrue((boolean)Sets.difference(expectedLogs, receivedLogs).isEmpty());
    }

    @Test(timeout=60000L)
    public void testCreateLogPickingFirstAvailableSubNamespace() throws Exception {
        Set<Object> receivedLogs;
        URI subNs1 = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createSubNamespace());
        URI subNs2 = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createSubNamespace());
        Set<String> logs0 = this.createLogs(this.uri, 9, "test-ns0-");
        Set<String> logs1 = this.createLogs(subNs1, 10, "test-ns1-");
        Set<String> logs2 = this.createLogs(subNs2, 10, "test-ns2-");
        TreeSet allLogs = Sets.newTreeSet();
        allLogs.addAll(logs0);
        allLogs.addAll(logs1);
        allLogs.addAll(logs2);
        do {
            TimeUnit.MILLISECONDS.sleep(20L);
            receivedLogs = new TreeSet();
            Iterator logs = (Iterator)Utils.ioResult((CompletableFuture)this.metadataStore.getLogs(""));
            receivedLogs.addAll(Lists.newArrayList((Iterator)logs));
        } while (receivedLogs.size() < 29);
        TestNamespaceListenerWithExpectedSize listener = new TestNamespaceListenerWithExpectedSize(31);
        this.metadataStore.registerNamespaceListener((NamespaceListener)listener);
        Set uris = (Set)Utils.ioResult((CompletableFuture)this.metadataStore.fetchSubNamespaces(null));
        Assert.assertEquals((long)3L, (long)uris.size());
        String testLogName = "test-pick-first-available-ns";
        URI createdURI = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createLog(testLogName));
        allLogs.add(testLogName);
        Assert.assertEquals((Object)this.uri, (Object)createdURI);
        uris = (Set)Utils.ioResult((CompletableFuture)this.metadataStore.fetchSubNamespaces(null));
        Assert.assertEquals((long)3L, (long)uris.size());
        testLogName = "test-create-new-ns";
        URI newURI = (URI)Utils.ioResult((CompletableFuture)this.metadataStore.createLog(testLogName));
        allLogs.add(testLogName);
        Assert.assertFalse((boolean)uris.contains(newURI));
        uris = (Set)Utils.ioResult((CompletableFuture)this.metadataStore.fetchSubNamespaces(null));
        Assert.assertEquals((long)4L, (long)uris.size());
        listener.waitForDone();
        receivedLogs = listener.getResult();
        Assert.assertEquals((long)31L, (long)receivedLogs.size());
        Assert.assertEquals((Object)allLogs, receivedLogs);
    }

    @Test(timeout=60000L)
    public void testZooKeeperSessionExpired() throws Exception {
        Set<String> allLogs = this.createLogs(20, "test-zookeeper-session-expired-");
        TestNamespaceListenerWithExpectedSize listener = new TestNamespaceListenerWithExpectedSize(21);
        this.metadataStore.registerNamespaceListener((NamespaceListener)listener);
        ZooKeeperClientUtils.expireSession(this.zkc, BKNamespaceDriver.getZKServersFromDLUri((URI)this.uri), 2000);
        String testLogName = "test-log-name";
        allLogs.add(testLogName);
        DistributedLogConfiguration anotherConf = new DistributedLogConfiguration();
        anotherConf.addConfiguration((Configuration)this.baseConf);
        ZooKeeperClient anotherZkc = TestZooKeeperClientBuilder.newBuilder().uri(this.uri).sessionTimeoutMs(2000).build();
        FederatedZKLogMetadataStore anotherMetadataStore = new FederatedZKLogMetadataStore(anotherConf, this.uri, anotherZkc, this.scheduler);
        Utils.ioResult((CompletableFuture)anotherMetadataStore.createLog(testLogName));
        listener.waitForDone();
        Set<String> receivedLogs = listener.getResult();
        Assert.assertEquals((long)21L, (long)receivedLogs.size());
        Assert.assertEquals(allLogs, receivedLogs);
    }

    static class TestNamespaceListenerWithExpectedSize
    implements NamespaceListener {
        final int expectedSize;
        final CountDownLatch doneLatch = new CountDownLatch(1);
        final AtomicReference<Set<String>> resultHolder = new AtomicReference();

        TestNamespaceListenerWithExpectedSize(int expectedSize) {
            this.expectedSize = expectedSize;
        }

        Set<String> getResult() {
            return this.resultHolder.get();
        }

        public void onStreamsChanged(Iterator<String> logsIter) {
            ArrayList logList = Lists.newArrayList(logsIter);
            if (logList.size() < this.expectedSize) {
                return;
            }
            this.resultHolder.set(Sets.newTreeSet((Iterable)logList));
            this.doneLatch.countDown();
        }

        void waitForDone() throws InterruptedException {
            this.doneLatch.await();
        }
    }

    static class TestNamespaceListener
    implements NamespaceListener {
        final CountDownLatch doneLatch = new CountDownLatch(1);
        final AtomicReference<Iterator<String>> resultHolder = new AtomicReference();

        TestNamespaceListener() {
        }

        public void onStreamsChanged(Iterator<String> streams) {
            this.resultHolder.set(streams);
            if (streams.hasNext()) {
                this.doneLatch.countDown();
            }
        }

        Iterator<String> getResult() {
            return this.resultHolder.get();
        }

        void waitForDone() throws InterruptedException {
            this.doneLatch.await();
        }
    }
}

