/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.channel;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServerChannelManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StorageServerChannelManager.class);
    private final ReentrantReadWriteLock lock;
    private boolean closed = false;
    private final ConcurrentMap<Endpoint, StorageServerChannel> channels = new ConcurrentHashMap<Endpoint, StorageServerChannel>();
    private final Function<Endpoint, StorageServerChannel> channelFactory;

    public StorageServerChannelManager(StorageClientSettings settings) {
        this(StorageServerChannel.factory(settings));
    }

    @VisibleForTesting
    public StorageServerChannelManager(Function<Endpoint, StorageServerChannel> channelFactory) {
        this.lock = new ReentrantReadWriteLock();
        this.channelFactory = channelFactory;
    }

    @VisibleForTesting
    int getNumChannels() {
        return this.channels.size();
    }

    @VisibleForTesting
    boolean contains(Endpoint endpoint) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.channels.containsKey(endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStorageServer(Endpoint endpoint, StorageServerChannel channel) {
        this.lock.readLock().lock();
        try {
            if (this.closed) {
                log.warn("Skip adding channel {} of range server {} since the channel manager is already closed", (Object)channel, (Object)endpoint);
                channel.close();
                boolean bl = false;
                return bl;
            }
            StorageServerChannel oldChannel = this.channels.putIfAbsent(endpoint, channel);
            if (null != oldChannel) {
                log.debug("KeyRange server ({}) already existed in the channel manager.");
                channel.close();
                boolean bl = false;
                return bl;
            }
            log.info("Added range server ({}) into the channel manager.", (Object)endpoint);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public StorageServerChannel getOrCreateChannel(Endpoint endpoint) {
        StorageServerChannel channel = this.getChannel(endpoint);
        if (null != channel) {
            return channel;
        }
        StorageServerChannel newChannel = this.channelFactory.apply(endpoint);
        this.addStorageServer(endpoint, newChannel);
        return this.getChannel(endpoint);
    }

    @Nullable
    public StorageServerChannel getChannel(Endpoint endpoint) {
        this.lock.readLock().lock();
        try {
            StorageServerChannel storageServerChannel = (StorageServerChannel)this.channels.get(endpoint);
            return storageServerChannel;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public StorageServerChannel removeChannel(Endpoint endpoint, StorageServerChannel channel) {
        this.lock.readLock().lock();
        try {
            if (this.closed) {
                log.warn("Skip removing channel {} of range server {} since the channel manager is already closed", (Object)channel, (Object)endpoint);
                StorageServerChannel storageServerChannel = null;
                return storageServerChannel;
            }
            StorageServerChannel channelRemoved = null == channel ? (StorageServerChannel)this.channels.remove(endpoint) : (this.channels.remove(endpoint, channel) ? channel : null);
            if (null == channelRemoved) {
                log.debug("No channel associated with endpoint {} to be removed.");
            } else {
                log.info("Removed channel {} for range server {} successfully", (Object)channelRemoved, (Object)endpoint);
            }
            if (null != channelRemoved) {
                channelRemoved.close();
            }
            StorageServerChannel storageServerChannel = channelRemoved;
            return storageServerChannel;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.channels.values().forEach(StorageServerChannel::close);
        this.channels.clear();
    }
}

