/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.DeleteTxn;
import org.apache.zookeeper.txn.MultiTxn;
import org.apache.zookeeper.txn.Txn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFromLogNoServerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(LoadFromLogNoServerTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxnFailure() throws Exception {
        try {
            ZooKeeperServer.setDigestEnabled((boolean)true);
            long count = 1L;
            File tmpDir = ClientBase.createTmpDir();
            FileTxnSnapLog logFile = new FileTxnSnapLog(tmpDir, tmpDir);
            DataTree dt = new DataTree();
            dt.createNode("/test", new byte[0], null, 0L, -1, 1L, 1L);
            for (count = 1L; count <= 3L; ++count) {
                dt.createNode("/test/" + count, new byte[0], null, 0L, -1, count, Time.currentElapsedTime());
            }
            long digestBefore = dt.getTreeDigest();
            DataNode zk = dt.getNode("/test");
            LOG.info("Attempting to create /test/{}", (Object)(count - 1L));
            this.doOp(logFile, 1, "/test/" + (count - 1L), dt, zk, -1);
            Assert.assertNotEquals((long)digestBefore, (long)dt.getTreeDigest());
            LOG.info("Attempting to create /test/{}", (Object)(count - 1L));
            digestBefore = dt.getTreeDigest();
            this.doOp(logFile, 1, "/test/" + (count - 1L), dt, zk, zk.stat.getCversion() + 1);
            Assert.assertNotEquals((long)digestBefore, (long)dt.getTreeDigest());
            LOG.info("Attempting to create /test/{}", (Object)(count - 1L));
            digestBefore = dt.getTreeDigest();
            this.doOp(logFile, 14, "/test/" + (count - 1L), dt, zk, zk.stat.getCversion() + 1);
            Assert.assertNotEquals((long)digestBefore, (long)dt.getTreeDigest());
            LOG.info("Attempting to create /test/{}", (Object)(count - 1L));
            digestBefore = dt.getTreeDigest();
            this.doOp(logFile, 14, "/test/" + (count - 1L), dt, zk, -1);
            Assert.assertNotEquals((long)digestBefore, (long)dt.getTreeDigest());
        }
        finally {
            ZooKeeperServer.setDigestEnabled((boolean)false);
        }
    }

    private void doOp(FileTxnSnapLog logFile, int type, String path, DataTree dt, DataNode parent, int cversion) throws Exception {
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        int prevCversion = parent.stat.getCversion();
        long prevPzxid = parent.stat.getPzxid();
        List child = dt.getChildren(parentName, null, null);
        StringBuilder childStr = new StringBuilder();
        for (String s : child) {
            childStr.append(s).append(" ");
        }
        LOG.info("Children: {} for {}", (Object)childStr, (Object)parentName);
        LOG.info("(cverions, pzxid): {}, {}", (Object)prevCversion, (Object)prevPzxid);
        DeleteTxn txn = null;
        TxnHeader txnHeader = null;
        if (type == 2) {
            txn = new DeleteTxn(path);
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, Time.currentElapsedTime(), 2);
        } else if (type == 1) {
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, Time.currentElapsedTime(), 1);
            txn = new CreateTxn(path, new byte[0], null, false, cversion);
        } else if (type == 14) {
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, Time.currentElapsedTime(), 1);
            txn = new CreateTxn(path, new byte[0], null, false, cversion);
            ArrayList<Txn> txnList = new ArrayList<Txn>();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
            txn.serialize((OutputArchive)boa, "request");
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            Txn txact = new Txn(1, bb.array());
            txnList.add(txact);
            txn = new MultiTxn(txnList);
            txnHeader = new TxnHeader(43981L, 291, prevPzxid + 1L, Time.currentElapsedTime(), 14);
        }
        logFile.processTransaction(txnHeader, dt, null, (Record)txn);
        int newCversion = parent.stat.getCversion();
        long newPzxid = parent.stat.getPzxid();
        child = dt.getChildren(parentName, null, null);
        childStr = new StringBuilder();
        for (String s : child) {
            childStr.append(s).append(" ");
        }
        LOG.info("Children: {} for {}", (Object)childStr, (Object)parentName);
        LOG.info("(cverions, pzxid): {}, {}", (Object)newCversion, (Object)newPzxid);
        Assert.assertTrue((String)(type + " <cversion, pzxid> verification failed. Expected: <" + (prevCversion + 1) + ", " + (prevPzxid + 1L) + ">, found: <" + newCversion + ", " + newPzxid + ">"), (newCversion == prevCversion + 1 && newPzxid == prevPzxid + 1L ? 1 : 0) != 0);
    }

    @Test
    public void testPad() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        FileTxnLog txnLog = new FileTxnLog(tmpDir);
        TxnHeader txnHeader = new TxnHeader(43981L, 291, 291L, Time.currentElapsedTime(), 1);
        CreateTxn txn = new CreateTxn("/Test", new byte[0], null, false, 1);
        txnLog.append(txnHeader, (Record)txn);
        FileInputStream in = new FileInputStream(tmpDir.getPath() + "/log." + Long.toHexString(txnHeader.getZxid()));
        BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)in);
        FileHeader header = new FileHeader();
        header.deserialize((InputArchive)ia, "fileheader");
        LOG.info("Received magic : {} Expected : {}", (Object)header.getMagic(), (Object)FileTxnLog.TXNLOG_MAGIC);
        Assert.assertTrue((String)"Missing magic number ", (header.getMagic() == FileTxnLog.TXNLOG_MAGIC ? 1 : 0) != 0);
    }
}

