/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.server.command.FourLetterCommands;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourLetterWordsWhiteListTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(FourLetterWordsWhiteListTest.class);

    @Test(timeout=30000L)
    public void testFourLetterWordsAllDisabledByDefault() throws Exception {
        this.stopServer();
        FourLetterCommands.resetWhiteList();
        System.setProperty("zookeeper.4lw.commands.whitelist", "stat");
        this.startServer();
        this.verifyAllCommandsFail();
        TestableZooKeeper zk = this.createClient();
        this.verifyAllCommandsFail();
        zk.getData("/", true, null);
        this.verifyAllCommandsFail();
        zk.close();
        this.verifyFuzzyMatch("stat", "Outstanding");
        this.verifyAllCommandsFail();
    }

    @Test(timeout=30000L)
    public void testFourLetterWordsEnableSomeCommands() throws Exception {
        this.stopServer();
        FourLetterCommands.resetWhiteList();
        System.setProperty("zookeeper.4lw.commands.whitelist", "stat, ruok, isro");
        this.startServer();
        this.verifyFuzzyMatch("stat", "Outstanding");
        this.verifyExactMatch("ruok", "imok");
        this.verifyExactMatch("isro", "rw");
        this.verifyExactMatch("conf", this.generateExpectedMessage("conf"));
        this.verifyExactMatch("cons", this.generateExpectedMessage("cons"));
        this.verifyExactMatch("crst", this.generateExpectedMessage("crst"));
        this.verifyExactMatch("dirs", this.generateExpectedMessage("dirs"));
        this.verifyExactMatch("dump", this.generateExpectedMessage("dump"));
        this.verifyExactMatch("envi", this.generateExpectedMessage("envi"));
        this.verifyExactMatch("gtmk", this.generateExpectedMessage("gtmk"));
        this.verifyExactMatch("stmk", this.generateExpectedMessage("stmk"));
        this.verifyExactMatch("srst", this.generateExpectedMessage("srst"));
        this.verifyExactMatch("wchc", this.generateExpectedMessage("wchc"));
        this.verifyExactMatch("wchp", this.generateExpectedMessage("wchp"));
        this.verifyExactMatch("wchs", this.generateExpectedMessage("wchs"));
        this.verifyExactMatch("mntr", this.generateExpectedMessage("mntr"));
    }

    @Test(timeout=30000L)
    public void testISROEnabledWhenReadOnlyModeEnabled() throws Exception {
        this.stopServer();
        FourLetterCommands.resetWhiteList();
        System.setProperty("zookeeper.4lw.commands.whitelist", "stat");
        System.setProperty("readonlymode.enabled", "true");
        this.startServer();
        this.verifyExactMatch("isro", "rw");
        System.clearProperty("readonlymode.enabled");
    }

    @Test(timeout=30000L)
    public void testFourLetterWordsInvalidConfiguration() throws Exception {
        this.stopServer();
        FourLetterCommands.resetWhiteList();
        System.setProperty("zookeeper.4lw.commands.whitelist", "foo bar foo,,, bar :.,@#$%^&*() , , , , bar, bar, stat,        ");
        this.startServer();
        this.verifyAllCommandsFail();
        this.verifyFuzzyMatch("stat", "Outstanding");
    }

    @Test(timeout=30000L)
    public void testFourLetterWordsEnableAllCommandsThroughAsterisk() throws Exception {
        this.stopServer();
        FourLetterCommands.resetWhiteList();
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        this.startServer();
        this.verifyAllCommandsSuccess();
    }

    @Test(timeout=30000L)
    public void testFourLetterWordsEnableAllCommandsThroughExplicitList() throws Exception {
        this.stopServer();
        FourLetterCommands.resetWhiteList();
        System.setProperty("zookeeper.4lw.commands.whitelist", "ruok, envi, conf, stat, srvr, cons, dump,wchs, wchp, wchc, srst, crst, dirs, mntr, gtmk, isro, stmk");
        this.startServer();
        this.verifyAllCommandsSuccess();
    }

    private void verifyAllCommandsSuccess() throws Exception {
        this.verifyExactMatch("ruok", "imok");
        this.verifyFuzzyMatch("envi", "java.version");
        this.verifyFuzzyMatch("conf", "clientPort");
        this.verifyFuzzyMatch("stat", "Outstanding");
        this.verifyFuzzyMatch("srvr", "Outstanding");
        this.verifyFuzzyMatch("cons", "queued");
        this.verifyFuzzyMatch("dump", "Session");
        this.verifyFuzzyMatch("wchs", "watches");
        this.verifyFuzzyMatch("wchp", "");
        this.verifyFuzzyMatch("wchc", "");
        this.verifyFuzzyMatch("srst", "reset");
        this.verifyFuzzyMatch("crst", "reset");
        this.verifyFuzzyMatch("stat", "Outstanding");
        this.verifyFuzzyMatch("srvr", "Outstanding");
        this.verifyFuzzyMatch("cons", "queued");
        this.verifyFuzzyMatch("gtmk", "306");
        this.verifyFuzzyMatch("isro", "rw");
        TestableZooKeeper zk = this.createClient();
        String sid = FourLetterWordsWhiteListTest.getHexSessionId(zk.getSessionId());
        this.verifyFuzzyMatch("stat", "queued");
        this.verifyFuzzyMatch("srvr", "Outstanding");
        this.verifyFuzzyMatch("cons", sid);
        this.verifyFuzzyMatch("dump", sid);
        this.verifyFuzzyMatch("dirs", "size");
        zk.getData("/", true, null);
        this.verifyFuzzyMatch("stat", "queued");
        this.verifyFuzzyMatch("srvr", "Outstanding");
        this.verifyFuzzyMatch("cons", sid);
        this.verifyFuzzyMatch("dump", sid);
        this.verifyFuzzyMatch("wchs", "watching 1");
        this.verifyFuzzyMatch("wchp", sid);
        this.verifyFuzzyMatch("wchc", sid);
        this.verifyFuzzyMatch("dirs", "size");
        zk.close();
        this.verifyExactMatch("ruok", "imok");
        this.verifyFuzzyMatch("envi", "java.version");
        this.verifyFuzzyMatch("conf", "clientPort");
        this.verifyFuzzyMatch("stat", "Outstanding");
        this.verifyFuzzyMatch("srvr", "Outstanding");
        this.verifyFuzzyMatch("cons", "queued");
        this.verifyFuzzyMatch("dump", "Session");
        this.verifyFuzzyMatch("wchs", "watch");
        this.verifyFuzzyMatch("wchp", "");
        this.verifyFuzzyMatch("wchc", "");
        this.verifyFuzzyMatch("srst", "reset");
        this.verifyFuzzyMatch("crst", "reset");
        this.verifyFuzzyMatch("stat", "Outstanding");
        this.verifyFuzzyMatch("srvr", "Outstanding");
        this.verifyFuzzyMatch("cons", "queued");
        this.verifyFuzzyMatch("mntr", "zk_server_state\tstandalone");
        this.verifyFuzzyMatch("mntr", "num_alive_connections");
        this.verifyFuzzyMatch("stat", "Connections");
        this.verifyFuzzyMatch("srvr", "Connections");
        this.verifyFuzzyMatch("dirs", "size");
    }

    private void verifyAllCommandsFail() throws Exception {
        this.verifyExactMatch("ruok", this.generateExpectedMessage("ruok"));
        this.verifyExactMatch("conf", this.generateExpectedMessage("conf"));
        this.verifyExactMatch("cons", this.generateExpectedMessage("cons"));
        this.verifyExactMatch("crst", this.generateExpectedMessage("crst"));
        this.verifyExactMatch("dirs", this.generateExpectedMessage("dirs"));
        this.verifyExactMatch("dump", this.generateExpectedMessage("dump"));
        this.verifyExactMatch("envi", this.generateExpectedMessage("envi"));
        this.verifyExactMatch("gtmk", this.generateExpectedMessage("gtmk"));
        this.verifyExactMatch("stmk", this.generateExpectedMessage("stmk"));
        this.verifyExactMatch("srst", this.generateExpectedMessage("srst"));
        this.verifyExactMatch("wchc", this.generateExpectedMessage("wchc"));
        this.verifyExactMatch("wchp", this.generateExpectedMessage("wchp"));
        this.verifyExactMatch("wchs", this.generateExpectedMessage("wchs"));
        this.verifyExactMatch("mntr", this.generateExpectedMessage("mntr"));
        this.verifyExactMatch("isro", this.generateExpectedMessage("isro"));
        this.verifyFuzzyMatch("srvr", "Outstanding");
    }

    private String sendRequest(String cmd) throws IOException, X509Exception.SSLContextException {
        ClientBase.HostPort hpobj = ClientBase.parseHostPortList(this.hostPort).get(0);
        return FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)cmd);
    }

    private void verifyFuzzyMatch(String cmd, String expected) throws IOException, X509Exception.SSLContextException {
        String resp = this.sendRequest(cmd);
        LOG.info("cmd {} expected {} got {}", new Object[]{cmd, expected, resp});
        Assert.assertTrue((boolean)resp.contains(expected));
    }

    private String generateExpectedMessage(String command) {
        return command + " is not executed because it is not in the whitelist.";
    }

    private void verifyExactMatch(String cmd, String expected) throws IOException, X509Exception.SSLContextException {
        String resp = this.sendRequest(cmd);
        LOG.info("cmd {} expected an exact match of {}; got {}", new Object[]{cmd, expected, resp});
        Assert.assertTrue((boolean)resp.trim().equals(expected));
    }
}

