/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.zookeeper.server.quorum.auth.KerberosSecurityTestcase;
import org.apache.zookeeper.server.quorum.auth.MiniKdc;
import org.junit.Assert;
import org.junit.Test;

public class MiniKdcTest
extends KerberosSecurityTestcase {
    private static final boolean IBM_JAVA = System.getProperty("java.vendor").contains("IBM");

    @Test(timeout=60000L)
    public void testMiniKdcStart() {
        MiniKdc kdc = MiniKdcTest.getKdc();
        Assert.assertNotSame((Object)0, (Object)kdc.getPort());
    }

    @Test(timeout=60000L)
    public void testKeytabGen() throws Exception {
        MiniKdc kdc = MiniKdcTest.getKdc();
        File workDir = MiniKdcTest.getWorkDir();
        kdc.createPrincipal(new File(workDir, "keytab"), "foo/bar", "bar/foo");
        List principalNameList = Keytab.loadKeytab((File)new File(workDir, "keytab")).getPrincipals();
        HashSet<String> principals = new HashSet<String>();
        for (PrincipalName principalName : principalNameList) {
            principals.add(principalName.getName());
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo/bar@" + kdc.getRealm(), "bar/foo@" + kdc.getRealm())), principals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testKerberosLogin() throws Exception {
        MiniKdc kdc = MiniKdcTest.getKdc();
        File workDir = MiniKdcTest.getWorkDir();
        LoginContext loginContext = null;
        try {
            String principal = "foo";
            File keytab = new File(workDir, "foo.keytab");
            kdc.createPrincipal(keytab, principal);
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, KerberosConfiguration.createClientConfig(principal, keytab));
            loginContext.login();
            subject = loginContext.getSubject();
            Assert.assertEquals((long)1L, (long)subject.getPrincipals().size());
            Assert.assertEquals(KerberosPrincipal.class, subject.getPrincipals().iterator().next().getClass());
            Assert.assertEquals((Object)(principal + "@" + kdc.getRealm()), (Object)subject.getPrincipals().iterator().next().getName());
            loginContext.logout();
            subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, KerberosConfiguration.createServerConfig(principal, keytab));
            loginContext.login();
            subject = loginContext.getSubject();
            Assert.assertEquals((long)1L, (long)subject.getPrincipals().size());
            Assert.assertEquals(KerberosPrincipal.class, subject.getPrincipals().iterator().next().getClass());
            Assert.assertEquals((Object)(principal + "@" + kdc.getRealm()), (Object)subject.getPrincipals().iterator().next().getName());
            loginContext.logout();
        }
        finally {
            if (loginContext != null && loginContext.getSubject() != null && !loginContext.getSubject().getPrincipals().isEmpty()) {
                loginContext.logout();
            }
        }
    }

    private static class KerberosConfiguration
    extends Configuration {
        private String principal;
        private String keytab;
        private boolean isInitiator;

        private KerberosConfiguration(String principal, File keytab, boolean client) {
            this.principal = principal;
            this.keytab = keytab.getAbsolutePath();
            this.isInitiator = client;
        }

        public static Configuration createClientConfig(String principal, File keytab) {
            return new KerberosConfiguration(principal, keytab, true);
        }

        public static Configuration createServerConfig(String principal, File keytab) {
            return new KerberosConfiguration(principal, keytab, false);
        }

        private static String getKrb5LoginModuleName() {
            return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("principal", this.principal);
            options.put("refreshKrb5Config", "true");
            if (IBM_JAVA) {
                options.put("useKeytab", this.keytab);
                options.put("credsType", "both");
            } else {
                options.put("keyTab", this.keytab);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("isInitiator", Boolean.toString(this.isInitiator));
            }
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                options.put("ticketCache", ticketCache);
            }
            options.put("debug", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosConfiguration.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

