/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MultiOperationRecord;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.ReconfigRequest;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderBeanTest;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.ErrorTxn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepRequestProcessorTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(PrepRequestProcessorTest.class);
    private static final int CONNECTION_TIMEOUT = 3000;
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private CountDownLatch pLatch;
    private ZooKeeperServer zks;
    private ServerCnxnFactory servcnxnf;
    private PrepRequestProcessor processor;
    private Request outcome;
    private boolean isReconfigEnabledPreviously;
    private boolean isStandaloneEnabledPreviously;

    @Before
    public void setup() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        this.zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        this.servcnxnf = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        this.servcnxnf.startup(this.zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        this.zks.sessionTracker = new MySessionTracker();
        this.isReconfigEnabledPreviously = QuorumPeerConfig.isReconfigEnabled();
        this.isStandaloneEnabledPreviously = QuorumPeerConfig.isStandaloneEnabled();
    }

    @After
    public void teardown() throws Exception {
        if (this.servcnxnf != null) {
            this.servcnxnf.shutdown();
        }
        if (this.zks != null) {
            this.zks.shutdown();
        }
        QuorumPeerConfig.setReconfigEnabled((boolean)this.isReconfigEnabledPreviously);
        QuorumPeerConfig.setStandaloneEnabled((boolean)this.isStandaloneEnabledPreviously);
    }

    @Test
    public void testPRequest() throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, (RequestProcessor)new MyRequestProcessor());
        Request foo = new Request(null, 1L, 1, 1, ByteBuffer.allocate(3), null);
        this.processor.pRequest(foo);
        Assert.assertEquals((String)"Request should have marshalling error", (Object)new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue()), (Object)this.outcome.getTxn());
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
    }

    private Request createRequest(Record record, int opCode) throws IOException {
        return this.createRequest(record, opCode, 1L);
    }

    private Request createRequest(Record record, int opCode, long sessionId) throws IOException {
        return this.createRequest(record, opCode, sessionId, false);
    }

    private Request createRequest(Record record, int opCode, boolean admin) throws IOException {
        return this.createRequest(record, opCode, 1L, admin);
    }

    private Request createRequest(Record record, int opCode, long sessionId, boolean admin) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        record.serialize((OutputArchive)boa, "request");
        baos.close();
        List<Id> ids = Arrays.asList(admin ? new Id("super", "super user") : ZooDefs.Ids.ANYONE_ID_UNSAFE);
        return new Request(null, sessionId, 0, opCode, ByteBuffer.wrap(baos.toByteArray()), ids);
    }

    private void process(List<Op> ops) throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, (RequestProcessor)new MyRequestProcessor());
        MultiOperationRecord record = new MultiOperationRecord(ops);
        Request req = this.createRequest((Record)record, 14, false);
        this.processor.pRequest(req);
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testMultiOutstandingChange() throws Exception {
        this.zks.getZKDatabase().dataTree.createNode("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        Assert.assertNull(this.zks.outstandingChangesForPath.get("/foo"));
        this.process(Arrays.asList(Op.setData((String)"/foo", (byte[])new byte[0], (int)-1)));
        ZooKeeperServer.ChangeRecord cr = (ZooKeeperServer.ChangeRecord)this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertNotNull((String)"Change record wasn't set", (Object)cr);
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)1L, (long)cr.zxid);
        this.process(Arrays.asList(Op.delete((String)"/foo", (int)-1)));
        cr = (ZooKeeperServer.ChangeRecord)this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)2L, (long)cr.zxid);
        this.process(Arrays.asList(Op.delete((String)"/foo", (int)-1)));
        cr = (ZooKeeperServer.ChangeRecord)this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)2L, (long)cr.zxid);
    }

    @Test
    public void testReconfigWithAnotherOutstandingChange() throws Exception {
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        QuorumPeerConfig.setStandaloneEnabled((boolean)false);
        QuorumPeer qp = new QuorumPeer();
        QuorumVerifier quorumVerifierMock = (QuorumVerifier)Mockito.mock(QuorumVerifier.class);
        Mockito.when((Object)quorumVerifierMock.getAllMembers()).thenReturn(LeaderBeanTest.getMockedPeerViews(qp.getId()));
        qp.setQuorumVerifier(quorumVerifierMock, false);
        FileTxnSnapLog snapLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        LeaderZooKeeperServer lzks = new LeaderZooKeeperServer(snapLog, qp, new ZKDatabase(snapLog));
        qp.leader = new Leader(qp, lzks);
        lzks.sessionTracker = new MySessionTracker();
        ZooKeeperServer.setDigestEnabled((boolean)true);
        this.processor = new PrepRequestProcessor((ZooKeeperServer)lzks, (RequestProcessor)new MyRequestProcessor());
        CreateRequest record = new CreateRequest("/foo", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT.toFlag());
        this.pLatch = new CountDownLatch(1);
        this.processor.pRequest(this.createRequest((Record)record, 1, false));
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
        String newMember = "server.0=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant";
        record = new ReconfigRequest(null, null, newMember, 0L);
        this.pLatch = new CountDownLatch(1);
        this.processor.pRequest(this.createRequest((Record)record, 16, true));
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((long)this.outcome.getHdr().getType(), (long)16L);
    }

    @Test
    public void testMultiRollbackNoLastChange() throws Exception {
        this.zks.getZKDatabase().dataTree.createNode("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        this.zks.getZKDatabase().dataTree.createNode("/foo/bar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        Assert.assertNull(this.zks.outstandingChangesForPath.get("/foo"));
        this.process(Arrays.asList(Op.setData((String)"/foo", (byte[])new byte[0], (int)-1), Op.delete((String)"/foo", (int)-1)));
        Assert.assertNull(this.zks.outstandingChangesForPath.get("/foo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseSessionTxn() throws Exception {
        boolean before = ZooKeeperServer.isCloseSessionTxnEnabled();
        ZooKeeperServer.setCloseSessionTxnEnabled((boolean)true);
        try {
            long ephemeralOwner = 1L;
            DataTree dt = this.zks.getZKDatabase().dataTree;
            dt.createNode("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, ephemeralOwner, 0, 0L, 0L);
            dt.createNode("/bar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, ephemeralOwner, 0, 0L, 0L);
            RequestHeader header = new RequestHeader();
            header.setType(-11);
            final FinalRequestProcessor frq = new FinalRequestProcessor(this.zks);
            final CountDownLatch latch = new CountDownLatch(1);
            this.processor = new PrepRequestProcessor(this.zks, new RequestProcessor(){

                public void processRequest(Request request) {
                    frq.processRequest(request);
                    latch.countDown();
                }

                public void shutdown() {
                }
            });
            this.processor.pRequest(this.createRequest((Record)header, -11, ephemeralOwner));
            Assert.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
            Assert.assertEquals(null, (Object)dt.getNode("/foo"));
            Assert.assertEquals(null, (Object)dt.getNode("/bar"));
        }
        finally {
            ZooKeeperServer.setCloseSessionTxnEnabled((boolean)before);
        }
    }

    @Test
    public void testInvalidPath() throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, (RequestProcessor)new MyRequestProcessor());
        SetDataRequest record = new SetDataRequest("", new byte[0], -1);
        Request req = this.createRequest((Record)record, 5, false);
        this.processor.pRequest(req);
        this.pLatch.await();
        Assert.assertEquals((long)this.outcome.getHdr().getType(), (long)-1L);
        Assert.assertEquals((Object)this.outcome.getException().code(), (Object)KeeperException.Code.BADARGUMENTS);
    }

    private class MySessionTracker
    implements SessionTracker {
        private MySessionTracker() {
        }

        public boolean trackSession(long id, int to) {
            return false;
        }

        public boolean commitSession(long id, int to) {
            return false;
        }

        public void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        }

        public long createSession(int sessionTimeout) {
            return 0L;
        }

        public void dumpSessions(PrintWriter pwriter) {
        }

        public void removeSession(long sessionId) {
        }

        public int upgradeSession(long sessionId) {
            return 0;
        }

        public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        }

        public void shutdown() {
        }

        public boolean touchSession(long sessionId, int sessionTimeout) {
            return false;
        }

        public void setSessionClosing(long sessionId) {
        }

        public boolean isTrackingSession(long sessionId) {
            return false;
        }

        public void checkGlobalSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        }

        public Map<Long, Set<Long>> getSessionExpiryMap() {
            return new HashMap<Long, Set<Long>>();
        }

        public long getLocalSessionCount() {
            return 0L;
        }

        public boolean isLocalSessionsEnabled() {
            return false;
        }
    }

    private class MyRequestProcessor
    implements RequestProcessor {
        private MyRequestProcessor() {
        }

        public void processRequest(Request request) {
            PrepRequestProcessorTest.this.outcome = request;
            PrepRequestProcessorTest.this.pLatch.countDown();
        }

        public void shutdown() {
        }
    }
}

