/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ClusterTopologyChangeMessage
extends PacketImpl {
    protected boolean exit;
    protected String nodeID;
    protected Pair<TransportConfiguration, TransportConfiguration> pair;
    protected boolean last;

    public ClusterTopologyChangeMessage(String nodeID, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last) {
        super((byte)110);
        this.nodeID = nodeID;
        this.pair = pair;
        this.last = last;
        this.exit = false;
    }

    public ClusterTopologyChangeMessage(String nodeID) {
        super((byte)110);
        this.exit = true;
        this.nodeID = nodeID;
    }

    public ClusterTopologyChangeMessage() {
        super((byte)110);
    }

    public ClusterTopologyChangeMessage(byte clusterTopologyV2) {
        super(clusterTopologyV2);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public Pair<TransportConfiguration, TransportConfiguration> getPair() {
        return this.pair;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isExit() {
        return this.exit;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.exit);
        buffer.writeString(this.nodeID);
        if (!this.exit) {
            if (this.pair.getA() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getA()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            if (this.pair.getB() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getB()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(this.last);
        }
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.exit = buffer.readBoolean();
        this.nodeID = buffer.readString();
        if (!this.exit) {
            TransportConfiguration b;
            TransportConfiguration a;
            boolean hasPrimary = buffer.readBoolean();
            if (hasPrimary) {
                a = new TransportConfiguration();
                a.decode(buffer);
            } else {
                a = null;
            }
            boolean hasBackup = buffer.readBoolean();
            if (hasBackup) {
                b = new TransportConfiguration();
                b.decode(buffer);
            } else {
                b = null;
            }
            this.pair = new Pair((Object)a, (Object)b);
            this.last = buffer.readBoolean();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.exit, this.last, this.nodeID, this.pair);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", exit=" + this.exit);
        sb.append(", last=" + this.last);
        sb.append(", nodeID=" + this.nodeID);
        sb.append(", pair=" + String.valueOf(this.pair));
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClusterTopologyChangeMessage)) {
            return false;
        }
        ClusterTopologyChangeMessage other = (ClusterTopologyChangeMessage)obj;
        return this.exit == other.exit && this.last == other.last && Objects.equals(this.nodeID, other.nodeID) && Objects.equals(this.pair, other.pair);
    }
}

