/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class Redirector {
    public static final String HAWTIO_REDIRECT_SCHEME = "hawtio.redirect.scheme";
    private String scheme = System.getProperty("hawtio.redirect.scheme");
    private String applicationContextPath = "";

    public void doRedirect(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        Object redirectUrl = "";
        if (this.scheme == null) {
            this.scheme = request.getServletContext().getInitParameter("scheme");
        }
        if (this.scheme != null) {
            int port = request.getServerPort();
            redirectUrl = port == 80 || port == 443 ? String.format("%s://%s", this.scheme, request.getServerName()) : String.format("%s://%s:%s", this.scheme, request.getServerName(), port);
        }
        redirectUrl = (String)redirectUrl + request.getContextPath() + this.applicationContextPath + path;
        response.sendRedirect((String)redirectUrl);
    }

    public void doForward(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        request.getRequestDispatcher(this.applicationContextPath + path).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void setApplicationContextPath(String applicationContextPath) {
        this.applicationContextPath = applicationContextPath;
    }
}

