/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StringUtil {
    public static String joinStringList(Collection<String> strList, String delimit) {
        Iterator<String> entries = strList.iterator();
        StringBuilder builder = new StringBuilder();
        while (entries.hasNext()) {
            builder.append(entries.next());
            if (!entries.hasNext()) continue;
            builder.append(delimit);
        }
        return builder.toString();
    }

    public static List<String> splitStringList(String strList, String delimit) {
        ArrayList<String> list = new ArrayList<String>();
        if (strList != null && !strList.isEmpty()) {
            for (String string : strList.split(delimit)) {
                list.add(string.trim());
            }
        }
        return list;
    }

    public static String convertPascalCaseToKebabCase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    builder.append('-');
                }
                builder.append(Character.toLowerCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

