.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbTranslateKeyCode __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbTranslateKeyCode \-  Translate a keycode to a key symbol and modifiers
.SH SYNOPSIS
.B Bool XkbTranslateKeyCode
(
.I xkb,
.I key,
.I mods,
.I mods_rtrn,
.I keysym_rtrn
)
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      KeyCode \fIkey\fP\^;
.br
      unsigned int \fImods\fP\^;
.br
      unsigned int * \fImods_rtrn\fP\^;
.br
      KeySym * \fIkeysym_rtrn\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description to use for translation
.TP
.I \- key
keycode to translate
.TP
.I \- mods
modifiers to apply when translating key
.TP
.I \- mods_rtrn
backfilled with unconsumed modifiers
.TP
.I \- keysym_rtrn
keysym resulting from translation
.SH DESCRIPTION
.LP
.I mods_rtrn 
is backfilled with the modifiers consumed by the translation process. 
.I mods 
is a bitwise inclusive OR of the legal modifier masks: ShiftMask, LockMask, 
ControlMask, Mod1Mask, Mod2Mask, Mod3Mask, Mod4Mask, Mod5Mask.The 
AlwaysConsumeShiftAndLock library control (see below), if enabled, causes
.I XkbTranslateKeyCode 
to consume shift and lock. 
.I XkbTranslateKeyCode 
returns True if the translation resulted in a keysym, and False if it resulted 
in NoSymbol.

The AlwaysConsumeShiftAndLock control, if enabled, forces 
.I XLookupString 
to consume the Shift and Lock modifiers when processing all keys, even if the 
definition for the key type does not specify these modifiers. The 
AlwaysConsumeShiftAndLock control is unset by default. 
.SH "SEE ALSO"
.BR XLookupString (3X11)
