/* -*- mesa-c++  -*-
 *
 * Copyright (c) 2018 Collabora LTD
 *
 * Author: Gert Wollny <gert.wollny@collabora.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "sfn_alu_defines.h"

namespace r600 {

const std::map<EAluOp, AluOp> alu_ops = {
   {op0_nop                 ,AluOp(0, 0, AluOp::a,"NOP")},
   {op0_group_barrier       ,AluOp(0, 0, AluOp::a,"GROUP_BARRIER")},
   {op0_group_seq_begin     ,AluOp(0, 0, AluOp::a,"GROUP_SEQ_BEGIN")},
   {op0_group_seq_end       ,AluOp(0, 0, AluOp::a,"GROUP_SEQ_END")},
   {op0_pred_set_clr        ,AluOp(0, 1, AluOp::a,"PRED_SET_CLR")},
   {op0_store_flags         ,AluOp(0, 0, AluOp::v,"STORE_FLAGS")},
   {op0_lds_1a              ,AluOp(0, 0, AluOp::v,"LDS_1A")},
   {op0_lds_1a1d            ,AluOp(0, 0, AluOp::v,"LDS_1A1D")},
   {op0_lds_2a              ,AluOp(0, 0, AluOp::v,"LDS_2A")},

   {op1_bcnt_int            ,AluOp(1, 0, AluOp::v,"BCNT_INT")},
   {op1_bcnt_accum_prev_int ,AluOp(1, 0, AluOp::v,"BCNT_ACCUM_PREV_INT")},
   {op1_bfrev_int           ,AluOp(1, 0, AluOp::a,"BFREV_INT")},
   {op1_ceil                ,AluOp(1, 1, AluOp::a,"CEIL")},
   {op1_cos                 ,AluOp(1, 1, AluOp::t,"COS")},
   {op1_exp_ieee            ,AluOp(1, 1, AluOp::t,"EXP_IEEE")},
   {op1_floor               ,AluOp(1, 1, AluOp::a,"FLOOR")},
   {op1_flt_to_int          ,AluOp(1, 0, AluOp::a,"FLT_TO_INT")},
   {op1_flt_to_uint         ,AluOp(1, 1, AluOp::t,"FLT_TO_UINT")},
   {op1_flt_to_int_rpi      ,AluOp(1, 1, AluOp::v,"FLT_TO_INT_RPI")},
   {op1_flt_to_int_floor    ,AluOp(1, 1, AluOp::v,"FLT_TO_INT_FLOOR")},
   {op1_flt16_to_flt32      ,AluOp(1, 1, AluOp::v,"FLT16_TO_FLT32")},
   {op1_flt32_to_flt16      ,AluOp(1, 1, AluOp::v,"FLT32_TO_FLT16")},
   {op1_flt32_to_flt64      ,AluOp(1, 1, AluOp::v,"FLT32_TO_FLT64")},
   {op1_flt64_to_flt32      ,AluOp(1, 1, AluOp::a,"FLT64_TO_FLT32")},
   {op1_fract               ,AluOp(1, 1, AluOp::a,"FRACT")},
   {op1_fract_64            ,AluOp(1, 1, AluOp::v,"FRACT_64")},
   {op1_frexp_64            ,AluOp(1, 1, AluOp::v,"FREXP_64")},
   {op1_int_to_flt          ,AluOp(1, 0, AluOp::t,"INT_TO_FLT")},
   {op1_ldexp_64            ,AluOp(1, 1, AluOp::v,"LDEXP_64")},
   {op1_interp_load_p0      ,AluOp(1, 1, AluOp::v,"INTERP_LOAD_P0")},
   {op1_interp_load_p10     ,AluOp(1, 1, AluOp::v,"INTERP_LOAD_P10")},
   {op1_interp_load_p20     ,AluOp(1, 1, AluOp::v,"INTERP_LOAD_P20")},
   {op1_load_store_flags    ,AluOp(1, 0, AluOp::v,"LOAD_STORE_FLAGS")},
   {op1_log_clamped         ,AluOp(1, 1, AluOp::t,"LOG_CLAMPED")},
   {op1_log_ieee            ,AluOp(1, 1, AluOp::t,"LOG_IEEE")},
   {op1_max4                ,AluOp(1, 1, AluOp::v,"MAX4")},
   {op1_mbcnt_32hi_int      ,AluOp(1, 0, AluOp::v,"MBCNT_32HI_INT")},
   {op1_mbcnt_32lo_accum_prev_int ,AluOp(1, 0, AluOp::v,"MBCNT_32LO_ACCUM_PREV_INT")},
   {op1_mov                 ,AluOp(1, 0, AluOp::a,"MOV")},
   {op1_mova_int            ,AluOp(1, 0, AluOp::v,"MOVA_INT")},
   {op1_not_int             ,AluOp(1, 0, AluOp::a,"NOT_INT")},
   {op1_offset_to_flt       ,AluOp(1, 0, AluOp::v,"OFFSET_TO_FLT")},
   {op1_pred_set_inv        ,AluOp(1, 1, AluOp::a,"PRED_SET_INV")},
   {op1_pred_set_restore    ,AluOp(1, 1, AluOp::a,"PRED_SET_RESTORE")},
   {op1_set_cf_idx0         ,AluOp(1, 0, AluOp::a,"SET_CF_IDX0")}, /* Reads from AR register? */
   {op1_set_cf_idx1         ,AluOp(1, 0, AluOp::a,"SET_CF_IDX1")}, /* Reads from AR register? */
   {op1_recip_clamped       ,AluOp(1, 1, AluOp::t,"RECIP_CLAMPED")},
   {op1_recip_ff            ,AluOp(1, 1, AluOp::t,"RECIP_FF")},
   {op1_recip_ieee          ,AluOp(1, 1, AluOp::t,"RECIP_IEEE")},
   {op1_recipsqrt_clamped   ,AluOp(1, 1, AluOp::t,"RECIPSQRT_CLAMPED")},
   {op1_recipsqrt_ff        ,AluOp(1, 1, AluOp::t,"RECIPSQRT_FF")},
   {op1_recipsqrt_ieee1     ,AluOp(1, 1, AluOp::t,"RECIPSQRT_IEEE")},
   {op1_recip_int           ,AluOp(1, 0, AluOp::t,"RECIP_INT")},
   {op1_recip_uint          ,AluOp(1, 0, AluOp::t,"RECIP_UINT")},
   {op1_recip_64            ,AluOp(1, 1, AluOp::t,"RECIP_64")},
   {op1_recip_clamped_64    ,AluOp(1, 1, AluOp::t,"RECIP_CLAMPED_64")},
   {op1_recipsqrt_64        ,AluOp(1, 1, AluOp::t,"RECIPSQRT_64")},
   {op1_recipsqrt_clamped_64,AluOp(1, 1, AluOp::t,"RECIPSQRT_CLAMPED_64")},
   {op1_rndne               ,AluOp(1, 1, AluOp::a,"RNDNE")},
   {op1_sqrt_ieee           ,AluOp(1, 1, AluOp::t,"SQRT_IEEE")},
   {op1_sin                 ,AluOp(1, 1, AluOp::t,"SIN")},
   {op1_trunc               ,AluOp(1, 1, AluOp::a,"TRUNC")},
   {op1_sqrt_64             ,AluOp(1, 1, AluOp::t,"SQRT_64")},
   {op1_ubyte0_flt          ,AluOp(1, 1, AluOp::v,"UBYTE0_FLT")},
   {op1_ubyte1_flt          ,AluOp(1, 1, AluOp::v,"UBYTE1_FLT")},
   {op1_ubyte2_flt          ,AluOp(1, 1, AluOp::v,"UBYTE2_FLT")},
   {op1_ubyte3_flt          ,AluOp(1, 1, AluOp::v,"UBYTE3_FLT")},
   {op1_uint_to_flt         ,AluOp(1, 0, AluOp::t,"UINT_TO_FLT")},
   {op1_ffbh_uint           ,AluOp(1, 0, AluOp::v,"FFBH_UINT")},
   {op1_ffbl_int            ,AluOp(1, 0, AluOp::v,"FFBL_INT")},
   {op1_ffbh_int            ,AluOp(1, 0, AluOp::v,"FFBH_INT")},
   {op1_flt_to_uint4        ,AluOp(1, 1, AluOp::v,"FLT_TO_UINT4")},
   {op1v_flt32_to_flt64     ,AluOp(1, 1, AluOp::a,"FLT32_TO_FLT64")},
   {op1v_flt64_to_flt32     ,AluOp(1, 1, AluOp::v,"FLT64_TO_FLT32")},

   {op2_add                 ,AluOp(2, 1, AluOp::a,"ADD")},
   {op2_bfm_int             ,AluOp(2, 0, AluOp::v,"BFM_INT")},
   {op2_mul                 ,AluOp(2, 1, AluOp::a,"MUL")},
   {op2_mul_ieee            ,AluOp(2, 1, AluOp::a,"MUL_IEEE")},
   {op2_max                 ,AluOp(2, 1, AluOp::a,"MAX")},
   {op2_min                 ,AluOp(2, 1, AluOp::a,"MIN")},
   {op2_max_dx10            ,AluOp(2, 1, AluOp::a,"MAX_DX10")},
   {op2_min_dx10            ,AluOp(2, 1, AluOp::a,"MIN_DX10")},
   {op2_sete                ,AluOp(2, 1, AluOp::a,"SETE")},
   {op2_setgt               ,AluOp(2, 1, AluOp::a,"SETGT")},
   {op2_setge               ,AluOp(2, 1, AluOp::a,"SETGE")},
   {op2_setne               ,AluOp(2, 1, AluOp::a,"SETNE")},
   {op2_sete_dx10           ,AluOp(2, 1, AluOp::a,"SETE_DX10")},
   {op2_setgt_dx10          ,AluOp(2, 1, AluOp::a,"SETGT_DX10")},
   {op2_setge_dx10          ,AluOp(2, 1, AluOp::a,"SETGE_DX10")},
   {op2_setne_dx10          ,AluOp(2, 1, AluOp::a,"SETNE_DX10")},
   {op2_ashr_int            ,AluOp(2, 0, AluOp::a,"ASHR_INT")},
   {op2_lshr_int            ,AluOp(2, 0, AluOp::a,"LSHR_INT")},
   {op2_lshl_int            ,AluOp(2, 0, AluOp::a,"LSHL_INT")},
   {op2_mul_64              ,AluOp(2, 1, AluOp::a,"MUL_64")},
   {op2_pred_setgt_uint     ,AluOp(2, 0, AluOp::a,"PRED_SETGT_UINT")},
   {op2_pred_setge_uint     ,AluOp(2, 0, AluOp::a,"PRED_SETGE_UINT")},
   {op2_pred_sete           ,AluOp(2, 1, AluOp::a,"PRED_SETE")},
   {op2_pred_setgt          ,AluOp(2, 1, AluOp::a,"PRED_SETGT")},
   {op2_pred_setge          ,AluOp(2, 1, AluOp::a,"PRED_SETGE")},
   {op2_pred_setne          ,AluOp(2, 1, AluOp::a,"PRED_SETNE")},
   {op2_pred_set_pop        ,AluOp(2, 1, AluOp::a,"PRED_SET_POP")},
   {op2_pred_sete_push      ,AluOp(2, 1, AluOp::a,"PRED_SETE_PUSH")},
   {op2_pred_setgt_push     ,AluOp(2, 1, AluOp::a,"PRED_SETGT_PUSH")},
   {op2_pred_setge_push     ,AluOp(2, 1, AluOp::a,"PRED_SETGE_PUSH")},
   {op2_pred_setne_push     ,AluOp(2, 1, AluOp::a,"PRED_SETNE_PUSH")},
   {op2_kille               ,AluOp(2, 1, AluOp::a,"KILLE")},
   {op2_killgt              ,AluOp(2, 1, AluOp::a,"KILLGT")},
   {op2_killge              ,AluOp(2, 1, AluOp::a,"KILLGE")},
   {op2_killne              ,AluOp(2, 1, AluOp::a,"KILLNE")},
   {op2_and_int             ,AluOp(2, 0, AluOp::a,"AND_INT")},
   {op2_or_int              ,AluOp(2, 0, AluOp::a,"OR_INT")},
   {op2_xor_int             ,AluOp(2, 0, AluOp::a,"XOR_INT")},
   {op2_add_int             ,AluOp(2, 0, AluOp::a,"ADD_INT")},
   {op2_sub_int             ,AluOp(2, 0, AluOp::a,"SUB_INT")},
   {op2_max_int             ,AluOp(2, 0, AluOp::a,"MAX_INT")},
   {op2_min_int             ,AluOp(2, 0, AluOp::a,"MIN_INT")},
   {op2_max_uint            ,AluOp(2, 0, AluOp::a,"MAX_UINT")},
   {op2_min_uint            ,AluOp(2, 0, AluOp::a,"MIN_UINT")},
   {op2_sete_int            ,AluOp(2, 0, AluOp::a,"SETE_INT")},
   {op2_setgt_int           ,AluOp(2, 0, AluOp::a,"SETGT_INT")},
   {op2_setge_int           ,AluOp(2, 0, AluOp::a,"SETGE_INT")},
   {op2_setne_int           ,AluOp(2, 0, AluOp::a,"SETNE_INT")},
   {op2_setgt_uint          ,AluOp(2, 0, AluOp::a,"SETGT_UINT")},
   {op2_setge_uint          ,AluOp(2, 0, AluOp::a,"SETGE_UINT")},
   {op2_killgt_uint         ,AluOp(2, 0, AluOp::a,"KILLGT_UINT")},
   {op2_killge_uint         ,AluOp(2, 0, AluOp::a,"KILLGE_UINT")},
   {op2_prede_int           ,AluOp(2, 0, AluOp::a,"PREDE_INT")},
   {op2_pred_setgt_int      ,AluOp(2, 0, AluOp::a,"PRED_SETGT_INT")},
   {op2_pred_setge_int      ,AluOp(2, 0, AluOp::a,"PRED_SETGE_INT")},
   {op2_pred_setne_int      ,AluOp(2, 0, AluOp::a,"PRED_SETNE_INT")},
   {op2_kille_int           ,AluOp(2, 0, AluOp::a,"KILLE_INT")},
   {op2_killgt_int          ,AluOp(2, 0, AluOp::a,"KILLGT_INT")},
   {op2_killge_int          ,AluOp(2, 0, AluOp::a,"KILLGE_INT")},
   {op2_killne_int          ,AluOp(2, 0, AluOp::a,"KILLNE_INT")},
   {op2_pred_sete_push_int  ,AluOp(2, 0, AluOp::a,"PRED_SETE_PUSH_INT")},
   {op2_pred_setgt_push_int ,AluOp(2, 0, AluOp::a,"PRED_SETGT_PUSH_INT")},
   {op2_pred_setge_push_int ,AluOp(2, 0, AluOp::a,"PRED_SETGE_PUSH_INT")},
   {op2_pred_setne_push_int ,AluOp(2, 0, AluOp::a,"PRED_SETNE_PUSH_INT")},
   {op2_pred_setlt_push_int ,AluOp(2, 0, AluOp::a,"PRED_SETLT_PUSH_INT")},
   {op2_pred_setle_push_int ,AluOp(2, 0, AluOp::a,"PRED_SETLE_PUSH_INT")},
   {op2_addc_uint           ,AluOp(2, 0, AluOp::a,"ADDC_UINT")},
   {op2_subb_uint           ,AluOp(2, 0, AluOp::a,"SUBB_UINT")},
   {op2_set_mode            ,AluOp(2, 0, AluOp::a,"SET_MODE")},
   {op2_set_lds_size        ,AluOp(2, 0, AluOp::a,"SET_LDS_SIZE")},
   {op2_mullo_int           ,AluOp(2, 0, AluOp::t,"MULLO_INT")},
   {op2_mulhi_int           ,AluOp(2, 0, AluOp::t,"MULHI_INT")},
   {op2_mullo_uint          ,AluOp(2, 0, AluOp::t,"MULLO_UINT")},
   {op2_mulhi_uint          ,AluOp(2, 0, AluOp::t,"MULHI_UINT")},
   {op2_dot_ieee            ,AluOp(2, 1, AluOp::v,"DOT_IEEE")},
   {op2_mulhi_uint24        ,AluOp(2, 0, AluOp::v,"MULHI_UINT24")},
   {op2_mul_uint24          ,AluOp(2, 0, AluOp::v,"MUL_UINT24")},
   {op2_sete_64             ,AluOp(2, 1, AluOp::v,"SETE_64")},
   {op2_setne_64            ,AluOp(2, 1, AluOp::v,"SETNE_64")},
   {op2_setgt_64            ,AluOp(2, 1, AluOp::v,"SETGT_64")},
   {op2_setge_64            ,AluOp(2, 1, AluOp::v,"SETGE_64")},
   {op2_min_64              ,AluOp(2, 1, AluOp::v,"MIN_64")},
   {op2_max_64              ,AluOp(2, 1, AluOp::v,"MAX_64")},
   {op2_dot4                ,AluOp(2, 1, AluOp::v,"DOT4")},
   {op2_dot4_ieee           ,AluOp(2, 1, AluOp::v,"DOT4_IEEE")},
   {op2_cube                ,AluOp(2, 1, AluOp::v,"CUBE")},
   {op2_pred_setgt_64       ,AluOp(2, 1, AluOp::v,"PRED_SETGT_64")},
   {op2_pred_sete_64        ,AluOp(2, 1, AluOp::v,"PRED_SETE_64")},
   {op2_pred_setge_64       ,AluOp(2, 1, AluOp::v,"PRED_SETGE_64")},
   {OP2V_MUL_64             ,AluOp(2, 1, AluOp::v,"MUL_64")},
   {op2_add_64              ,AluOp(2, 1, AluOp::v,"ADD_64")},
   {op2_sad_accum_prev_uint ,AluOp(2, 0, AluOp::v,"SAD_ACCUM_PREV_UINT")},
   {op2_dot                 ,AluOp(2, 1, AluOp::v,"DOT")},
   {op2_mul_prev            ,AluOp(2, 1, AluOp::v,"MUL_PREV")},
   {op2_mul_ieee_prev       ,AluOp(2, 1, AluOp::v,"MUL_IEEE_PREV")},
   {op2_add_prev            ,AluOp(2, 1, AluOp::v,"ADD_PREV")},
   {op2_muladd_prev         ,AluOp(2, 1, AluOp::v,"MULADD_PREV")},
   {op2_muladd_ieee_prev    ,AluOp(2, 1, AluOp::v,"MULADD_IEEE_PREV")},
   {op2_interp_xy           ,AluOp(2, 1, AluOp::v,"INTERP_XY")},
   {op2_interp_zw           ,AluOp(2, 1, AluOp::v,"INTERP_ZW")},
   {op2_interp_x            ,AluOp(2, 1, AluOp::v,"INTERP_X")},
   {op2_interp_z            ,AluOp(2, 1, AluOp::v,"INTERP_Z")},

   {op3_bfe_uint            ,AluOp(3, 0, AluOp::v,"BFE_UINT")},
   {op3_bfe_int             ,AluOp(3, 0, AluOp::v,"BFE_INT")},
   {op3_bfi_int             ,AluOp(3, 0, AluOp::v,"BFI_INT")},
   {op3_fma                 ,AluOp(3, 1, AluOp::v,"FMA")},
   {op3_cndne_64            ,AluOp(3, 1, AluOp::v,"CNDNE_64")},
   {op3_fma_64              ,AluOp(3, 1, AluOp::v,"FMA_64")},
   {op3_lerp_uint           ,AluOp(3, 0, AluOp::v,"LERP_UINT")},
   {op3_bit_align_int       ,AluOp(3, 0, AluOp::v,"BIT_ALIGN_INT")},
   {op3_byte_align_int      ,AluOp(3, 0, AluOp::v,"BYTE_ALIGN_INT")},
   {op3_sad_accum_uint      ,AluOp(3, 0, AluOp::v,"SAD_ACCUM_UINT")},
   {op3_sad_accum_hi_uint   ,AluOp(3, 0, AluOp::v,"SAD_ACCUM_HI_UINT")},
   {op3_muladd_uint24       ,AluOp(3, 0, AluOp::v,"MULADD_UINT24")},
   {op3_lds_idx_op          ,AluOp(3, 0, AluOp::x,"LDS_IDX_OP")},
   {op3_muladd              ,AluOp(3, 1, AluOp::a,"MULADD")},
   {op3_muladd_m2           ,AluOp(3, 1, AluOp::a,"MULADD_M2")},
   {op3_muladd_m4           ,AluOp(3, 1, AluOp::a,"MULADD_M4")},
   {op3_muladd_d2           ,AluOp(3, 1, AluOp::a,"MULADD_D2")},
   {op3_muladd_ieee         ,AluOp(3, 1, AluOp::a,"MULADD_IEEE")},
   {op3_cnde                ,AluOp(3, 1, AluOp::a,"CNDE")},
   {op3_cndgt               ,AluOp(3, 1, AluOp::a,"CNDGT")},
   {op3_cndge               ,AluOp(3, 1, AluOp::a,"CNDGE")},
   {op3_cnde_int            ,AluOp(3, 0, AluOp::a,"CNDE_INT")},
   {op3_cndgt_int           ,AluOp(3, 0, AluOp::a,"CNDGT_INT")},
   {op3_cndge_int           ,AluOp(3, 0, AluOp::a,"CNDGE_INT")},
   {op3_mul_lit             ,AluOp(3, 1, AluOp::t,"MUL_LIT")}
};

const std::map<AluInlineConstants, AluInlineConstantDescr> alu_src_const = {
   {ALU_SRC_LDS_OQ_A, {false, "LDS_OQ_A"}},
   {ALU_SRC_LDS_OQ_B, {false, "LDS_OQ_B"}},
   {ALU_SRC_LDS_OQ_A_POP, {false, "LDS_OQ_A_POP"}},
   {ALU_SRC_LDS_OQ_B_POP, {false, "LDS_OQ_B_POP"}},
   {ALU_SRC_LDS_DIRECT_A, {false, "LDS_DIRECT_A"}},
   {ALU_SRC_LDS_DIRECT_B, {false, "LDS_DIRECT_B"}},
   {ALU_SRC_TIME_HI, {false, "TIME_HI"}},
   {ALU_SRC_TIME_LO, {false, "TIME_LO"}},
   {ALU_SRC_MASK_HI, {false, "MASK_HI"}},
   {ALU_SRC_MASK_LO, {false, "MASK_LO"}},
   {ALU_SRC_HW_WAVE_ID, {false, "HW_WAVE_ID"}},
   {ALU_SRC_SIMD_ID, {false, "SIMD_ID"}},
   {ALU_SRC_SE_ID, {false, "SE_ID"}},
   {ALU_SRC_HW_THREADGRP_ID, {false, "HW_THREADGRP_ID"}},
   {ALU_SRC_WAVE_ID_IN_GRP, {false, "WAVE_ID_IN_GRP"}},
   {ALU_SRC_NUM_THREADGRP_WAVES, {false, "NUM_THREADGRP_WAVES"}},
   {ALU_SRC_HW_ALU_ODD, {false, "HW_ALU_ODD"}},
   {ALU_SRC_LOOP_IDX, {false, "LOOP_IDX"}},
   {ALU_SRC_PARAM_BASE_ADDR, {false, "PARAM_BASE_ADDR"}},
   {ALU_SRC_NEW_PRIM_MASK, {false, "NEW_PRIM_MASK"}},
   {ALU_SRC_PRIM_MASK_HI, {false, "PRIM_MASK_HI"}},
   {ALU_SRC_PRIM_MASK_LO, {false, "PRIM_MASK_LO"}},
   {ALU_SRC_1_DBL_L, {false, "1.0L"}},
   {ALU_SRC_1_DBL_M, {false, "1.0H"}},
   {ALU_SRC_0_5_DBL_L, {false, "0.5L"}},
   {ALU_SRC_0_5_DBL_M, {false, "0.5H"}},
   {ALU_SRC_0, {false, "0"}},
   {ALU_SRC_1, {false, "1.0"}},
   {ALU_SRC_1_INT, {false, "1"}},
   {ALU_SRC_M_1_INT, {false, "-1"}},
   {ALU_SRC_0_5, {false, "0.5"}},
   {ALU_SRC_LITERAL, {true, "ALU_SRC_LITERAL"}},
   {ALU_SRC_PV, {true, "PV"}},
   {ALU_SRC_PS, {false, "PS"}}
};

const std::map<ESDOp, LDSOp> lds_ops = {
   {DS_OP_ADD           , {2, "DS_ADD"}},
   {DS_OP_SUB           , {2, "DS_SUB"}},
   {DS_OP_RSUB          , {2, "DS_RSUB"}},
   {DS_OP_INC           , {2, "DS_INC"}},
   {DS_OP_DEC           , {2, "DS_DEC"}},
   {DS_OP_MIN_INT       , {2, "DS_MIN_INT"}},
   {DS_OP_MAX_INT       , {2, "DS_MAX_INT"}},
   {DS_OP_MIN_UINT      , {2, "DS_MIN_UINT"}},
   {DS_OP_MAX_UINT      , {2, "DS_MAX_UINT"}},
   {DS_OP_AND           , {2, "DS_AND"}},
   {DS_OP_OR            , {2, "DS_OR"}},
   {DS_OP_XOR           , {2, "DS_XOR"}},
   {DS_OP_MSKOR         , {3, "DS_MSKOR"}},
   {DS_OP_WRITE         , {2, "DS_WRITE"}},
   {DS_OP_WRITE_REL     , {3, "DS_WRITE_REL"}},
   {DS_OP_WRITE2        , {3, "DS_WRITE2"}},
   {DS_OP_CMP_STORE     , {3, "DS_CMP_STORE"}},
   {DS_OP_CMP_STORE_SPF , {3, "DS_CMP_STORE_SPF"}},
   {DS_OP_BYTE_WRITE    , {2, "DS_BYTE_WRITE"}},
   {DS_OP_SHORT_WRITE   , {2, "DS_SHORT_WRITE"}},
   {DS_OP_ADD_RET       , {2, "DS_ADD_RET"}},
   {DS_OP_SUB_RET       , {2, "DS_SUB_RET"}},
   {DS_OP_RSUB_RET      , {2, "DS_RSUB_RET"}},
   {DS_OP_INC_RET       , {2, "DS_INC_RET"}},
   {DS_OP_DEC_RET       , {2, "DS_DEC_RET"}},
   {DS_OP_MIN_INT_RET   , {2, "DS_MIN_INT_RET"}},
   {DS_OP_MAX_INT_RET   , {2, "DS_MAX_INT_RET"}},
   {DS_OP_MIN_UINT_RET  , {2, "DS_MIN_UINT_RET"}},
   {DS_OP_MAX_UINT_RET  , {2, "DS_MAX_UINT_RET"}},
   {DS_OP_AND_RET       , {2, "DS_AND_RET"}},
   {DS_OP_OR_RET        , {2, "DS_OR_RET"}},
   {DS_OP_XOR_RET       , {2, "DS_XOR_RET"}},
   {DS_OP_MSKOR_RET     , {3, "DS_MSKOR_RET"}},
   {DS_OP_XCHG_RET      , {2, "DS_XCHG_RET"}},
   {DS_OP_XCHG_REL_RET  , {3, "DS_XCHG_REL_RET"}},
   {DS_OP_XCHG2_RET     , {3, "DS_XCHG2_RET"}},
   {DS_OP_CMP_XCHG_RET  , {3, "DS_CMP_XCHG_RET"}},
   {DS_OP_CMP_XCHG_SPF_RET, {3, "DS_CMP_XCHG_SPF_RET"}},
   {DS_OP_READ_RET      , {1, "DS_READ_RET"}},
   {DS_OP_READ_REL_RET  , {1, "DS_READ_REL_RET"}},
   {DS_OP_READ2_RET     , {2, "DS_READ2_RET"}},
   {DS_OP_READWRITE_RET , {3, "DS_READWRITE_RET"}},
   {DS_OP_BYTE_READ_RET , {1, "DS_BYTE_READ_RET"}},
   {DS_OP_UBYTE_READ_RET, {1, "DS_UBYTE_READ_RET"}},
   {DS_OP_SHORT_READ_RET, {1, "DS_SHORT_READ_RET"}},
   {DS_OP_USHORT_READ_RET, {1, "DS_USHORT_READ_RET"}},
   {DS_OP_ATOMIC_ORDERED_ALLOC_RET , {3, "DS_ATOMIC_ORDERED_ALLOC_RET"}}
};

}
