.\" 
.\" $Id: xexit.man,v 1.3 1994/06/06 14:29:19 stumpf Exp $
.\" 
.\" Copyright (c) 1992-1994   Markus Stumpf
.\" 
.\" The X Consortium, and any party obtaining a copy of these files from
.\" the X Consortium, directly or indirectly, is granted, free of charge, a
.\" full and unrestricted irrevocable, world-wide, paid up, royalty-free,
.\" nonexclusive right and license to deal in this software and
.\" documentation files (the "Software"), including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons who receive
.\" copies from any such party to do so.  This license includes without
.\" limitation a license to do the foregoing actions under any patents of
.\" the party supplying this software to the X Consortium.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM OR THE AUTHOR BE LIABLE FOR ANY CLAIM,
.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.TH XEXIT 1 "Release 6" "X Version 11"
.SH NAME
xexit \- terminate all clients of a X session and exit
.SH SYNOPSIS
.ta 8n
\fBxexit\fP [ \fB\-version\fP ] [ \fB\-showVersion\fP ] [ \fB\-noConfirm\fP ]
.SH DESCRIPTION
The
.I xexit 
program consists of a (small) window sitting somewhere on your screen.
When clicking into it with the mouse pointer
.I xexit
tries to gracefully terminate all clients of the current session.
.PP
It first sends all clients participating in that protocol a WM_SAVE_YOURSELF
message. After that, a WM_DELETE_WINDOW message is sent.
All clients still having windows, are now shut down with XKillClient().
.PP
For convenience reasons
.I xexit
per default pops up a confirmation dialog box.
This however can be suppressed either by commandline option or resource.
.PP
.I Xexit
is assumed to be the last client in the .xsession file and not be sent
in the background, though this is not strictly required.
.SH OPTIONS
.I Xexit
accepts all of the standard X Toolkit command line options along with the 
additional options listed below:
.TP 8
.B \-version
This option forces
.I xexit
to only write its version to stdout and exit.
.TP 8
.B \-showVersion 
A small window is popped up in the upper left corner of the screen
showing version and author information.
This is the same behaviour as setting the \fBshowVersion\fP resource
to \fBtrue\fP (see section \fBX DEFAULTS\fP below).
.TP 8
.B \-noConfirm
No confirmation dialog box is popped up. Clicking into the
.I xexit
window with the mouse pointer causes
.I xexit
to immediately terminate all clients and exit itself.
This is the same behaviour as setting the \fBconfirmExit\fP resource
to \fBfalse\fP (see section \fBX DEFAULTS\fP below).
.SH X DEFAULTS
This program understands all of the core resource names and classes as well as:
.PP
.TP 8
.B showVersion \fP(class\fB ShowVersion \fP) default:\fB false
If set to true, a small window is openend additionally in the upper left
corner of the screen, showing version and author information.
This window can be popped down by clicking into it with the mouse
pointer.
.TP 8
.B confirmExit \fP(class\fB ConfirmExit \fP) default:\fB true
If set to true, a confirmation dialog box is popped up and the user
is given the choice of really terminating the session, or to cancel
the request and continue with the session.
.PP
Some other resources you may wish to modify are:
.TP 8
.B Xexit*exitButton.bitmap \fP default:\fB exit_sess.xbm
.TP 8
.B Xexit*confirmWarn.bitmap \fP default:\fB Excl
.TP 8
.B Xexit*confirmLabel.label \fP default:\fB "Session ..."
.TP 8
.B Xexit*confirmOk.label \fP default:\fB "terminate"
.TP 8
.B Xexit*confirmCancel.label \fP default:\fB "continue"
.PP
.SH WIDGETS
Xexit is based on the Athena Widget Set (Xaw).
In order to specify resources, it is useful to know the hierarchy of
the widgets which compose \fIxexit\fR.  In the notation below,
indentation indicates hierarchical structure.  The widget instance name
is given first, followed by the widget class name.
.sp
.nf
.TA .5i 
.ta .5i 
xexit  (Xexit)
    version  (Shell)
        versionForm  (Form)
            versionLabel  (Command)
    confirm  (Shell)
        confirmForm  (Form)
            confirmWarn    (Label)
            confirmLabel   (Label)
            confirmOk      (Command)
            confirmCancel  (Command)
    exitButton  (Command)
.fi
.fi
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH FILES
<XRoot>/lib/X11/app-defaults/Xexit - specifies required resources
.br
<XRoot>/include/X11/bitmaps/Excl
.br
<XRoot>/include/X11/bitmaps/ExitSess.xbm
.br
<XRoot>/include/X11/bitmaps/HaveSess.xbm - bitmaps used
.SH "SEE ALSO"
X(1), xrdb(1)
.SH BUGS
.I Xexit
cannot terminate clients that don\'t have windows.
.SH AUTHOR
Markus Stumpf
<stumpf@informatik.tu-muenchen.de>
.br
http://www.informatik.tu-muenchen.de/~stumpf/
