/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import vlcskineditor.ActionEditor;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.ImageEditEvent;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.resources.ImageResource;

public class Image
extends Item
implements ActionListener {
    public final String RESIZE_DEFAULT = "mosaic";
    public final String ACTION_DEFAULT = "none";
    public final String ACTION2_DEFAULT = "none";
    public String image;
    public String resize = "mosaic";
    public String action = "none";
    public String action2 = "none";
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField image_tf;
    JTextField action2_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JComboBox resize_cb;
    JComboBox action_cb;
    JButton visible_btn;
    JButton action2_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    ActionEditor action2_ae;
    ImageResource image_res;

    public Image(Node node, Skin skin) {
        this.type = Language.get("IMAGE");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.image = XML.getStringAttributeValue(node, "image", this.image);
        this.action = XML.getStringAttributeValue(node, "action", this.action);
        this.action2 = XML.getStringAttributeValue(node, "action2", this.action2);
        this.resize = XML.getStringAttributeValue(node, "resize", this.resize);
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.lefttop = XML.getStringAttributeValue(node, "lefttop", this.lefttop);
        this.rightbottom = XML.getStringAttributeValue(node, "rightbottom", this.rightbottom);
        this.xkeepratio = XML.getBoolAttributeValue(node, "xkeepratio", this.xkeepratio);
        this.ykeepratio = XML.getBoolAttributeValue(node, "ykeepratio", this.ykeepratio);
        this.visible = XML.getStringAttributeValue(node, "visible", this.visible);
        this.help = XML.getStringAttributeValue(node, "help", this.help);
        this.image_res = this.s.getImageResource(this.image);
        this.created = true;
    }

    public Image(String string, Skin skin) {
        this.type = Language.get("IMAGE");
        this.s = skin;
        this.image = XML.getValue(string, "image");
        this.image_res = this.s.getImageResource(this.image);
        if (string.indexOf("resize=\"") != -1) {
            this.resize = XML.getValue(string, "resize");
        }
        if (string.indexOf("action=\"") != -1) {
            this.action = XML.getValue(string, "action");
        }
        if (string.indexOf("action2=\"") != -1) {
            this.action2 = XML.getValue(string, "action2");
        }
        if (string.indexOf("x=\"") != -1) {
            this.x = XML.getIntValue(string, "x");
        }
        if (string.indexOf("y=\"") != -1) {
            this.y = XML.getIntValue(string, "y");
        }
        this.id = string.indexOf("id=\"") != -1 ? XML.getValue(string, "id") : Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        if (string.indexOf("lefttop=\"") != -1) {
            this.lefttop = XML.getValue(string, "lefttop");
        }
        if (string.indexOf("rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(string, "rightbottom");
        }
        if (string.indexOf("xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(string, "xkeepratio");
        }
        if (string.indexOf("ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(string, "ykeepratio");
        }
        if (string.indexOf(" visible=\"") != -1) {
            this.visible = XML.getValue(string, "visible");
        }
        this.created = true;
    }

    public Image(Skin skin) {
        this.type = Language.get("IMAGE");
        this.s = skin;
        this.image = "";
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.showOptions();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.image = this.image_tf.getText();
            this.resize = this.resize_cb.getSelectedItem().toString();
            this.action = this.action_cb.getSelectedItem().toString();
            this.action2 = this.action2_tf.getText();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(2);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            ImageEditEvent imageEditEvent = new ImageEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.image = this.image_tf.getText();
            this.resize = this.resize_cb.getSelectedItem().toString();
            this.action = this.action_cb.getSelectedItem().toString();
            this.action2 = this.action2_tf.getText();
            this.s.updateItems();
            this.s.expandItem(this.id);
            imageEditEvent.setNew();
            this.s.m.hist.addEvent(imageEditEvent);
        }
        this.updateToGlobalVariables();
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_IMAGE_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel(Language.get("WIN_ITEM_LEFTTOP"));
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText(Language.get("WIN_ITEM_LEFTTOP_TIP"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_ITEM_RIGHTBOTTOM"));
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText(Language.get("WIN_ITEM_RIGHTBOTTOM_TIP"));
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel(Language.get("WIN_ITEM_XKEEPRATIO"));
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText(Language.get("WIN_ITEM_XKEEPRATIO_TIP"));
            JLabel jLabel7 = new JLabel(Language.get("WIN_ITEM_YKEEPRATIO"));
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText(Language.get("WIN_ITEM_YKEEPRATIO_TIP"));
            JLabel jLabel8 = new JLabel(Language.get("WIN_ITEM_VISIBLE"));
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", Main.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel(Language.get("WIN_ITEM_HELP"));
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText(Language.get("WIN_ITEM_HELP_TIP"));
            JLabel jLabel10 = new JLabel(Language.get("WIN_IMAGE_IMAGE"));
            this.image_tf = new JTextField();
            this.image_tf.setToolTipText(Language.get("WIN_IMAGE_IMAGE_TIP"));
            JLabel jLabel11 = new JLabel(Language.get("WIN_IMAGE_RESIZE"));
            String[] stringArray2 = new String[]{"mosaic", "scale"};
            this.resize_cb = new JComboBox<String>(stringArray2);
            this.resize_cb.setToolTipText(Language.get("WIN_IMAGE_RESIZE_TIP"));
            JLabel jLabel12 = new JLabel(Language.get("WIN_IMAGE_ACTION"));
            String[] stringArray3 = new String[]{"none", "move", "resizeE", "resizeS", "resizeSE"};
            this.action_cb = new JComboBox<String>(stringArray3);
            this.action_cb.setToolTipText(Language.get("WIN_IMAGE_ACTION_TIP"));
            JLabel jLabel13 = new JLabel(Language.get("WIN_IMAGE_ACTION2"));
            this.action2_tf = new JTextField();
            this.action2_tf.setToolTipText(Language.get("WIN_IMAGE_ACTION2_TIP"));
            this.action2_btn = new JButton("", Main.editor_icon);
            this.action2_btn.addActionListener(this);
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            JLabel jLabel14 = new JLabel(Language.get("NOTE_STARRED"));
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7, jLabel8, jLabel9, jLabel10, jLabel11, jLabel12, jLabel13};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)this.id_tf);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.x_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.x_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.x_tf);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.y_tf);
            springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.lefttop_cb, 0, "VerticalCenter", (Component)jLabel4);
            springLayout.putConstraint("West", (Component)this.lefttop_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.lefttop_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel5, 10, "South", (Component)this.lefttop_cb);
            springLayout.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.rightbottom_cb, 0, "VerticalCenter", (Component)jLabel5);
            springLayout.putConstraint("West", (Component)this.rightbottom_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.rightbottom_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.rightbottom_cb);
            springLayout.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.xkeepratio_cb, 0, "VerticalCenter", (Component)jLabel6);
            springLayout.putConstraint("West", (Component)this.xkeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.xkeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel7, 10, "South", (Component)this.xkeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.ykeepratio_cb, 0, "VerticalCenter", (Component)jLabel7);
            springLayout.putConstraint("West", (Component)this.ykeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.ykeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel8, 10, "South", (Component)this.ykeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel8, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_tf, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("West", (Component)this.visible_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.visible_tf, -5, "West", (Component)this.visible_btn);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_btn, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("East", (Component)this.visible_btn, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel9, 10, "South", (Component)this.visible_btn);
            springLayout.putConstraint("West", (Component)jLabel9, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.help_tf, 0, "VerticalCenter", (Component)jLabel9);
            springLayout.putConstraint("West", (Component)this.help_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.help_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.help_tf);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel10);
            jPanel2.add(this.image_tf);
            this.image_tf.setPreferredSize(new Dimension(n2, this.image_tf.getPreferredSize().height));
            jPanel2.add(jLabel11);
            jPanel2.add(this.resize_cb);
            jPanel2.add(jLabel12);
            jPanel2.add(this.action_cb);
            jPanel2.add(jLabel13);
            jPanel2.add(this.action2_tf);
            jPanel2.add(this.action2_btn);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_IMAGE_ATTR")));
            SpringLayout springLayout2 = new SpringLayout();
            springLayout2.putConstraint("North", (Component)jLabel10, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel10, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.image_tf, 0, "VerticalCenter", (Component)jLabel10);
            springLayout2.putConstraint("West", (Component)this.image_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("North", (Component)jLabel11, 10, "South", (Component)this.image_tf);
            springLayout2.putConstraint("West", (Component)jLabel11, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.resize_cb, 0, "VerticalCenter", (Component)jLabel11);
            springLayout2.putConstraint("West", (Component)this.resize_cb, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.resize_cb, 0, "East", (Component)this.image_tf);
            springLayout2.putConstraint("North", (Component)jLabel12, 10, "South", (Component)this.resize_cb);
            springLayout2.putConstraint("West", (Component)jLabel12, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.action_cb, 0, "VerticalCenter", (Component)jLabel12);
            springLayout2.putConstraint("West", (Component)this.action_cb, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.action_cb, 0, "East", (Component)this.image_tf);
            springLayout2.putConstraint("North", (Component)jLabel13, 10, "South", (Component)this.action_cb);
            springLayout2.putConstraint("West", (Component)jLabel13, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.action2_tf, 0, "VerticalCenter", (Component)jLabel13);
            springLayout2.putConstraint("West", (Component)this.action2_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.action2_tf, -5, "West", (Component)this.action2_btn);
            springLayout2.putConstraint("VerticalCenter", (Component)this.action2_btn, 0, "VerticalCenter", (Component)jLabel13);
            springLayout2.putConstraint("East", (Component)this.action2_btn, 0, "East", (Component)this.image_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.image_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.action2_btn);
            jPanel2.setLayout(springLayout2);
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel14);
            SpringLayout springLayout3 = new SpringLayout();
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 10, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jLabel14, 10, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)jLabel14, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 10, "South", (Component)jLabel14);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 0, "North", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("North", (Component)this.help_btn, 0, "North", (Component)this.cancel_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 10, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.setLayout(springLayout3);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.image_tf.setText(this.image);
        this.resize_cb.setSelectedItem(this.resize);
        this.action_cb.setSelectedItem(this.action);
        this.action2_tf.setText(this.action2);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            this.image_res = this.s.getImageResource(this.image_tf.getText());
            if (this.image_res == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.image_tf.getText() + "\" does not exist!", "Image not valid", 1);
                this.image_res = this.s.getImageResource(this.image);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-image.html");
        } else if (actionEvent.getSource().equals(this.action2_btn)) {
            if (this.action2_ae == null) {
                this.action2_ae = new ActionEditor(this);
            }
            this.action2_ae.editAction(this.action2_tf.getText());
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/boolexpr.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public void actionWasEdited(ActionEditor actionEditor) {
        if (actionEditor == this.action2_ae) {
            this.action2_tf.setText(this.action2_ae.getCode());
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Image";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        string2 = string2 + " image=\"" + this.image + "\"";
        if (!this.action.equals("none")) {
            string2 = string2 + " action=\"" + this.action + "\"";
        }
        if (!this.action2.equals("none")) {
            string2 = string2 + " action2=\"" + this.action2 + "\"";
        }
        if (!this.resize.equals("mosaic")) {
            string2 = string2 + " resize=\"" + this.resize + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        BufferedImage bufferedImage = this.image_res.image;
        if (this.vis) {
            graphics2D.drawImage(bufferedImage, (this.x + n) * n3, (this.y + n2) * n3, bufferedImage.getWidth() * n3, bufferedImage.getHeight() * n3, null);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, bufferedImage.getWidth() * n3 - 1, bufferedImage.getHeight() * n3 - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        BufferedImage bufferedImage = this.image_res.image;
        return n >= this.x + this.offsetx && n <= this.x + bufferedImage.getWidth() + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + bufferedImage.getHeight() + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Image: " + this.id);
        return defaultMutableTreeNode;
    }

    @Override
    public boolean uses(String string) {
        return this.image.equals(string);
    }
}

