/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.io.File;
import spec.reporter.Report;
import spec.reporter.TextiReport;

public class Reporter {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static boolean opta = false;
    private static boolean opte = true;
    private static boolean opth = false;
    private static boolean opts = false;
    private static String optl;
    private static String optn;
    private static String opto;
    private static String optr;
    private static String optc;
    private static boolean optv;

    public static void main(String[] stringArray) {
        String string = System.setProperty("java.awt.headless", "true");
        if (!Reporter.getOpt(stringArray)) {
            return;
        }
        if (opta) {
            TextiReport textiReport = new TextiReport(optn, optr, opts);
            if (opto == null) {
                textiReport.print(System.out);
            } else {
                textiReport.print(opto);
            }
        } else {
            String string2 = ".";
            string2 = opto == null ? "." : new File(opto).getParent();
            if (string2 == null) {
                string2 = ".";
            }
            Report report = new Report(opte, opts, optn, optr, optv, optc, optl, opth, string2);
            if (opto == null) {
                report.print(System.out);
            } else {
                report.print(opto);
            }
            System.out.println(report.messages());
        }
    }

    private static boolean getOpt(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-a")) {
                    opta = true;
                    continue;
                }
                if (stringArray[i].equals("-e")) {
                    opte = false;
                    continue;
                }
                if (stringArray[i].equals("-h")) {
                    opth = true;
                    continue;
                }
                if (stringArray[i].equals("-s")) {
                    opts = true;
                    continue;
                }
                if (stringArray[i].equals("-l")) {
                    optl = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-n")) {
                    optn = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-o")) {
                    opto = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-r")) {
                    optr = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-c")) {
                    optc = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    optv = true;
                    continue;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Reporter.usage();
            return false;
        }
        if (optr != null) {
            return true;
        }
        Reporter.usage();
        return false;
    }

    private static void usage() {
        System.out.println("Usage: java spec.reporter.Reporter [options]\nRequired options are:\n-r Results        A SPEC results file, generated by a benchmark run.\n                    May be in a mail message with mail headers.\nOther options are:\n-a                Plain ASCII text output\n                    default: generate HTML output with JPG graph\n-c              Second raw file, to compare\n                    default: none\n-e                Do NOT echo raw results properties in HTML output\n                    default: raw results inserted as HTML comments\n-h                Create graph in HTML rather than JPG\n                    default: use JPG if have Java2-l Label          Label to infix into the JPG name: SPECjbb.label.jpg\n                    default: a random number\n-o Output         Output file for generated HTML\n                    default: written to System.out\n-v                Verbose. List extra spec.testx.* properties\n                    default: extra properties are not reported\n");
    }

    static {
        optv = false;
    }
}

