/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import uk.me.nxg.unity.Dimensions;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitRepresentation;

class UnityUnitDefinitionMap
extends UnitDefinitionMap {
    private Map<Syntax, Map<String, UnitDefinition>> syntaxToUnitLookupMap = null;
    private Map<Syntax, Map<UnitDefinition, UnitRepresentation>> syntaxToUnitRepresentationMap = null;
    private Map<String, UnitDefinition> uriToUnitLookupMap = null;

    UnityUnitDefinitionMap() {
    }

    private void mapUnitToRepresentation(Map<UnitDefinition, UnitRepresentation> map, UnitDefinition unitDefinition, UnitRepresentation unitRepresentation, boolean bl) {
        UnitRepresentation unitRepresentation2 = map.get(unitDefinition);
        if (unitRepresentation2 == null) {
            map.put(unitDefinition, unitRepresentation);
        } else if (bl) {
            unitRepresentation.add(unitRepresentation2);
            map.put(unitDefinition, unitRepresentation);
        } else {
            unitRepresentation2.add(unitRepresentation);
        }
    }

    @Override
    public UnitDefinitionMap.Resolver getResolver(final Syntax syntax) {
        final Map<String, UnitDefinition> map = this.syntaxToUnitLookupMap.get((Object)syntax);
        final Map<UnitDefinition, UnitRepresentation> map2 = this.syntaxToUnitRepresentationMap.get((Object)syntax);
        if (map == null || map2 == null) {
            return null;
        }
        return new UnitDefinitionMap.Resolver(){

            @Override
            public UnitDefinition lookupSymbol(String string) {
                return (UnitDefinition)map.get(string);
            }

            @Override
            public UnitRepresentation lookupUnit(UnitDefinition unitDefinition) {
                return (UnitRepresentation)map2.get(unitDefinition);
            }

            @Override
            public Syntax getSyntax() {
                return syntax;
            }
        };
    }

    @Override
    public UnitDefinition lookupUnitDefinition(String string) {
        return this.uriToUnitLookupMap.get(string);
    }

    @Override
    UnitDefinitionMap initialize() {
        ArrayList<UnitDefinition> arrayList = new ArrayList<UnitDefinition>();
        this.uriToUnitLookupMap = new HashMap<String, UnitDefinition>(96);
        UnitDefinition unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Byte", "Byte", "Byte", "http://qudt.org/vocab/quantity#InformationEntropy", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, "\\byte");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Byte", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Newton", "Newton", "Newton", "http://qudt.org/vocab/quantity#Force", new Dimensions(new float[]{1.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Newton", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Tesla", "Tesla", "Tesla", "http://qudt.org/vocab/quantity#MagneticField", new Dimensions(new float[]{0.0f, 1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Tesla", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Steradian", "Steradian", "Steradian", "http://qudt.org/vocab/quantity#SolidAngle", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "The steradian (symbol: sr) is the SI unit of solid angle. It is used to describe two-dimensional angular spans in three-dimensional space, analogous to the way in which the radian describes angles in a plane.", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Steradian", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Kelvin", "Kelvin", "Kelvin", "http://qudt.org/vocab/quantity#ThermodynamicTemperature", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Kelvin", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Lumen", "Lumen", "Lumen", "http://qudt.org/vocab/quantity#LuminousFlux", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Lumen", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#SolarRadius", "solRad", "SolarRadius", "http://qudt.org/vocab/quantity#Length", new Dimensions(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "6.9599e8 m", "R\\solar");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#SolarRadius", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#MinuteTime", "Minute Time", "MinuteTime", "http://qudt.org/vocab/quantity#Time", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#MinuteTime", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#DegreeAngle", "Degree Angle", "DegreeAngle", "http://qudt.org/vocab/quantity#PlaneAngle", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#DegreeAngle", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#Crab", "Crab", "Crab", "http://bitbucket/org/nxg/unity/ns/quantity#SpecificIntensity", new Dimensions(new float[]{0.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "The flux density, relative to that of the Crab.\nMentioned in the OGIP standard, but strongly disrecommended.\nThe OGIP standard permits only 'm' as a prefix.", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#Crab", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#DetectorChannel", "chan", "DetectorChannel", "http://qudt.org/vocab/quantity#Dimensionless", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "One channel in a detector of some type", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#DetectorChannel", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Volt", "Volt", "Volt", "http://qudt.org/vocab/quantity#EnergyPerElectricCharge", new Dimensions(new float[]{2.0f, 1.0f, -3.0f, -1.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Volt", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#ADU", "ADU", "ADU", "http://qudt.org/vocab/quantity#Dimensionless", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "Same as channel???", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#ADU", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Erg", "Erg", "Erg", "http://qudt.org/vocab/quantity#EnergyAndWork", new Dimensions(new float[]{2.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Erg", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Pascal", "Pascal", "Pascal", "http://qudt.org/vocab/quantity#ForcePerArea", new Dimensions(new float[]{-1.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Pascal", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#AstronomicalUnit", "Astronomical Unit", "AstronomicalUnit", "http://qudt.org/vocab/quantity#Length", new Dimensions(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#AstronomicalUnit", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#StellarMagnitude", "mag", "StellarMagnitude", "http://bitbucket/org/nxg/unity/ns/quantity#StellarMagnitudeQuantityKind", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "Log of a ratio of intensities.  See http://en.wikipedia.org/wiki/Magnitude_(astronomy)", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#StellarMagnitude", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Siemens", "Siemens", "Siemens", "http://qudt.org/vocab/quantity#ElectricConductivity", new Dimensions(new float[]{-2.0f, -1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Siemens", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#Jansky", "Jy", "Jansky", "http://bitbucket/org/nxg/unity/ns/quantity#SpecificIntensity", new Dimensions(new float[]{0.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "10^-26 W m-2 Hz-1", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#Jansky", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#LightYear", "Light Year", "LightYear", "http://qudt.org/vocab/quantity#Length", new Dimensions(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "A unit of length defining the distance, in meters, that light travels in a vacuum in one year.", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#LightYear", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#SecondTime", "Second", "SecondTime", "http://qudt.org/vocab/quantity#Time", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#SecondTime", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Gauss", "Gauss", "Gauss", "http://qudt.org/vocab/quantity#MagneticField", new Dimensions(new float[]{0.0f, 1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Gauss", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#MilliArcSecond", "mas", "MilliArcSecond", "http://qudt.org/vocab/quantity#PlaneAngle", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "1/1000 of an arc-second, for use in those syntaxes which do not allow SI prefixes of arcsec", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#MilliArcSecond", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Meter", "Metre", "Meter", "http://qudt.org/vocab/quantity#Length", new Dimensions(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Meter", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Coulomb", "Coulomb", "Coulomb", "http://qudt.org/vocab/quantity#ElectricCharge", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Coulomb", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#Rydberg", "Ry", "Rydberg", "http://qudt.org/vocab/quantity#EnergyAndWork", new Dimensions(new float[]{2.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "Half of the Hartree energy, defined as 13.605692 eV.  See http://en.wikipedia.org/wiki/Hartree", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#Rydberg", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Decibel", "Decibel", "Decibel", "http://qudt.org/vocab/quantity#SignalStrength", new Dimensions(new float[]{1.0f, 1.0f, -3.0f, -1.0f, 0.0f, 0.0f, 0.0f}), null, "\\decibel");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Decibel", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Hertz", "Hertz", "Hertz", "http://qudt.org/vocab/quantity#Frequency", new Dimensions(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Hertz", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Mole", "Mole", "Mole", "http://qudt.org/vocab/quantity#AmountOfSubstance", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Mole", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Farad", "Farad", "Farad", "http://qudt.org/vocab/quantity#Capacitance", new Dimensions(new float[]{-2.0f, -1.0f, 4.0f, 2.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Farad", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#BesselianYear", "Bessellian Year", "BesselianYear", "http://qudt.org/vocab/quantity#Time", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "The Besselian Year.\nSee the discussion in FITS WCS paper IV (section 4.2), and FITS v4.0 (section 9.3)\nfor important caveats concerning the use of the Besselian and Tropical years.", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#BesselianYear", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#Voxel", "voxel", "Voxel", "http://qudt.org/vocab/quantity#Dimensionless", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "The 3-D analogue of a pixel", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#Voxel", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#Pixel", "pixel", "Pixel", "http://qudt.org/vocab/quantity#Dimensionless", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "an element of a 2-D image", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#Pixel", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Joule", "Joule", "Joule", "http://qudt.org/vocab/quantity#EnergyAndWork", new Dimensions(new float[]{2.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Joule", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Number", "Number", "Number", "http://qudt.org/vocab/quantity#Dimensionless", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Number", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Watt", "Watt", "Watt", "http://qudt.org/vocab/quantity#Power", new Dimensions(new float[]{2.0f, 1.0f, -3.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Watt", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Lux", "Lux", "Lux", "http://qudt.org/vocab/quantity#LuminousFluxPerArea", new Dimensions(new float[]{-2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Lux", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#ArcMinute", "Arc Minute", "ArcMinute", "http://qudt.org/vocab/quantity#PlaneAngle", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#ArcMinute", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Gram", "Gramme", "Gram", "http://qudt.org/vocab/quantity#Mass", new Dimensions(new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Gram", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Bit", "Bit", "Bit", "http://qudt.org/vocab/quantity#InformationEntropy", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "In information theory, a bit is the amount of information that, on average, can be stored in a discrete bit. It is thus the amount of information carried by a choice between two equally likely outcomes. One bit corresponds to about 0.693 nats (ln(2)), or 0.301 hartleys (log10(2)).", "\\bit");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Bit", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Weber", "Weber", "Weber", "http://qudt.org/vocab/quantity#MagneticFlux", new Dimensions(new float[]{2.0f, 1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Weber", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#JulianCentury", "Julian Century", "JulianCentury", "http://qudt.org/vocab/quantity#Time", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "One hundred Julian Years", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#JulianCentury", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Barn", "Barn", "Barn", "http://qudt.org/vocab/quantity#Area", new Dimensions(new float[]{2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Barn", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#Photon", "ph", "Photon", "http://qudt.org/vocab/quantity#Dimensionless", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "as in ev/photon", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#Photon", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Candela", "Candela", "Candela", "http://qudt.org/vocab/quantity#LuminousIntensity", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Candela", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Percent", "Percent", "Percent", "http://qudt.org/vocab/quantity#DimensionlessRatio", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, "\\%");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Percent", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#DistributionBin", "bin", "DistributionBin", "http://qudt.org/vocab/quantity#Dimensionless", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "One division within a distribution", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#DistributionBin", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#SolarMass", "Solar mass", "SolarMass", "http://qudt.org/vocab/quantity#Mass", new Dimensions(new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "The mass of the sun is 1.9891e30 kg", "M\\solar");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#SolarMass", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Angstrom", "Angstrom", "Angstrom", "http://qudt.org/vocab/quantity#Length", new Dimensions(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "The \u00e5ngstr\u00f6m or angstrom (symbol \u00c5) (the latter spelling, without diacritics, is now usually used in English) (pronounced /\u02c8\u00e6\u014bstr\u0259m/; Swedish: [\u02c8\u0254\u014bstr\u00f8m]) is an internationally recognized unit of length equal to 0.1 nanometre or 1\u00d710\u221210 metres. It is named after Anders Jonas \u00c5ngstr\u00f6m. Although accepted for use, it is not formally defined within the International System of Units(SI). (That article lists the units that are so defined.) The \u00e5ngstr\u00f6m is often used in the natural sciences to express the sizes of atoms, lengths of chemical bonds and the wavelengths of electromagnetic radiation, and in technology for the dimensions of parts of integrated circuits. It is also commonly used in structural biology. [Wikipedia]", "\\angstrom");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Angstrom", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Day", "Day", "Day", "http://qudt.org/vocab/quantity#Time", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "Mean solar day", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Day", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Radian", "Radian", "Radian", "http://qudt.org/vocab/quantity#PlaneAngle", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "The radian is the standard unit of angular measure, used in many areas of mathematics. It describes the plane angle subtended by a circular arc as the length of the arc divided by the radius of the arc. The unit was formerly a SI supplementary unit, but this category was abolished in 1995 and the radian is now considered a SI derived unit. The SI unit of solid angle measurement is the steradian.\nThe radian is represented by the symbol \"rad\" or, more rarely, by the superscript c (for \"circular measure\"). For example, an angle of 1.2 radians would be written as \"1.2 rad\" or \"1.2c\" (the second symbol is often mistaken for a degree: \"1.2\u00b0\"). As the ratio of two lengths, the radian is a \"pure number\" that needs no unit symbol, and in mathematical writing the symbol \"rad\" is almost always omitted. In the absence of any symbol radians are assumed, and when degrees are meant the symbol \u00b0 is used. [Wikipedia]", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Radian", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#Beam", "beam", "Beam", "http://qudt.org/vocab/quantity#Dimensionless", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "as in Jy/beam", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#Beam", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Ohm", "Ohm", "Ohm", "http://qudt.org/vocab/quantity#Resistance", new Dimensions(new float[]{2.0f, 1.0f, -3.0f, -2.0f, 0.0f, 0.0f, 0.0f}), null, "\\ohm");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Ohm", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#YearTropical", "Year Tropical", "YearTropical", "http://qudt.org/vocab/quantity#Time", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#YearTropical", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#JulianYear", "Julian year", "JulianYear", "http://qudt.org/vocab/quantity#Time", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "31 557 600s (365.25d), peta a (Pa) forbidden", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#JulianYear", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Ampere", "Ampere", "Ampere", "http://qudt.org/vocab/quantity#ElectricCurrent", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Ampere", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#ElectronVolt", "Electron Volt", "ElectronVolt", "http://qudt.org/vocab/quantity#EnergyAndWork", new Dimensions(new float[]{2.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#ElectronVolt", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Debye", "Debye", "Debye", "http://qudt.org/vocab/quantity#ElectricDipoleMoment", new Dimensions(new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Debye", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#ArcSecond", "Arc Second", "ArcSecond", "http://qudt.org/vocab/quantity#PlaneAngle", new Dimensions(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#ArcSecond", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Parsec", "Parsec", "Parsec", "http://qudt.org/vocab/quantity#Length", new Dimensions(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "The parsec (parallax of one arcsecond; symbol: pc) is a unit of length, equal to just under 31 trillion (31\u00d71012) kilometres (about 19 trillion miles), 206265 AU, or about 3.26 light-years. The parsec measurement unit is used in astronomy. It is defined as the length of the adjacent side of an imaginary right triangle in space. The two dimensions that specify this triangle are the parallax angle (defined as 1 arcsecond) and the opposite side (defined as 1 astronomical unit (AU), the distance from the Earth to the Sun). Given these two measurements, along with the rules of trigonometry, the length of the adjacent side (the parsec) can be found. [Wikipedia]", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Parsec", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#Rayleigh", "R", "Rayleigh", "http://bitbucket.org/nxg/unity/ns/unit#PhotonFlux", new Dimensions(new float[]{-2.0f, 0.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "Unit of photon flux density: Wikipedia has units of 10^10 photons/m2/column/s.\nThe FITS spec has units of 1e10/(4PI) photons m-2 s-2 sr-1.\nSee http://en.wikipedia.org/wiki/Rayleigh_(unit).\nNo, I don't know how to express its dimensions in the QUDT system!\nWe go with the FITS definition here.", null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#Rayleigh", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Henry", "Henry", "Henry", "http://qudt.org/vocab/quantity#Inductance", new Dimensions(new float[]{2.0f, 1.0f, -2.0f, -2.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Henry", unitDefinition);
        unitDefinition = new UnitDefinition("http://bitbucket.org/nxg/unity/ns/unit#SolarLuminosity", "solLum", "SolarLuminosity", "http://qudt.org/vocab/quantity#Power", new Dimensions(new float[]{2.0f, 1.0f, -3.0f, 0.0f, 0.0f, 0.0f, 0.0f}), "3.8268e26 W", "L\\solar");
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://bitbucket.org/nxg/unity/ns/unit#SolarLuminosity", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#UnifiedAtomicMassUnit", "Unified Atomic Mass Unit", "UnifiedAtomicMassUnit", "http://qudt.org/vocab/quantity#Mass", new Dimensions(new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#UnifiedAtomicMassUnit", unitDefinition);
        unitDefinition = new UnitDefinition("http://qudt.org/vocab/unit#Hour", "Hour", "Hour", "http://qudt.org/vocab/quantity#Time", new Dimensions(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}), null, null);
        arrayList.add(unitDefinition);
        this.uriToUnitLookupMap.put("http://qudt.org/vocab/unit#Hour", unitDefinition);
        this.syntaxToUnitLookupMap = new HashMap<Syntax, Map<String, UnitDefinition>>(8);
        this.syntaxToUnitRepresentationMap = new HashMap<Syntax, Map<UnitDefinition, UnitRepresentation>>(8);
        HashMap<String, UnitDefinition> hashMap = new HashMap<String, UnitDefinition>();
        HashMap<UnitDefinition, UnitRepresentation> hashMap2 = new HashMap<UnitDefinition, UnitRepresentation>();
        unitDefinition = (UnitDefinition)arrayList.get(5);
        hashMap.put("lm", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lm"), false);
        unitDefinition = (UnitDefinition)arrayList.get(8);
        hashMap.put("deg", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "deg"), false);
        unitDefinition = (UnitDefinition)arrayList.get(28);
        hashMap.put("mol", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "mol"), false);
        unitDefinition = (UnitDefinition)arrayList.get(39);
        hashMap.put("bit", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "bit"), false);
        unitDefinition = (UnitDefinition)arrayList.get(36);
        hashMap.put("lx", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lx"), false);
        unitDefinition = (UnitDefinition)arrayList.get(14);
        hashMap.put("Pa", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Pa"), false);
        unitDefinition = (UnitDefinition)arrayList.get(56);
        hashMap.put("eV", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "eV"), false);
        unitDefinition = (UnitDefinition)arrayList.get(50);
        hashMap.put("rad", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "rad"), false);
        unitDefinition = (UnitDefinition)arrayList.get(52);
        hashMap.put("Ohm", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Ohm"), false);
        unitDefinition = (UnitDefinition)arrayList.get(42);
        hashMap.put("barn", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "barn"), false);
        unitDefinition = (UnitDefinition)arrayList.get(54);
        hashMap.put("yr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "yr"), true);
        unitDefinition = (UnitDefinition)arrayList.get(32);
        hashMap.put("pix", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "pix"), false);
        unitDefinition = (UnitDefinition)arrayList.get(45);
        hashMap.put("%", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "%"), false);
        unitDefinition = (UnitDefinition)arrayList.get(0);
        hashMap.put("byte", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "byte"), false);
        unitDefinition = (UnitDefinition)arrayList.get(27);
        hashMap.put("Hz", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Hz"), false);
        unitDefinition = (UnitDefinition)arrayList.get(15);
        hashMap.put("AU", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "AU"), false);
        unitDefinition = (UnitDefinition)arrayList.get(37);
        hashMap.put("arcmin", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "arcmin"), false);
        unitDefinition = (UnitDefinition)arrayList.get(48);
        hashMap.put("Angstrom", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "Angstrom"), false);
        unitDefinition = (UnitDefinition)arrayList.get(55);
        hashMap.put("A", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "A"), false);
        unitDefinition = (UnitDefinition)arrayList.get(24);
        hashMap.put("C", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "C"), false);
        unitDefinition = (UnitDefinition)arrayList.get(57);
        hashMap.put("D", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "D"), false);
        unitDefinition = (UnitDefinition)arrayList.get(58);
        hashMap.put("arcsec", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "arcsec"), false);
        unitDefinition = (UnitDefinition)arrayList.get(29);
        hashMap.put("F", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "F"), false);
        unitDefinition = (UnitDefinition)arrayList.get(61);
        hashMap.put("H", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "H"), false);
        unitDefinition = (UnitDefinition)arrayList.get(47);
        hashMap.put("solMass", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "solMass"), false);
        unitDefinition = (UnitDefinition)arrayList.get(33);
        hashMap.put("J", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "J"), false);
        unitDefinition = (UnitDefinition)arrayList.get(4);
        hashMap.put("K", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "K"), false);
        unitDefinition = (UnitDefinition)arrayList.get(1);
        hashMap.put("N", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "N"), false);
        unitDefinition = (UnitDefinition)arrayList.get(16);
        hashMap.put("mag", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "mag"), false);
        unitDefinition = (UnitDefinition)arrayList.get(17);
        hashMap.put("S", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "S"), false);
        unitDefinition = (UnitDefinition)arrayList.get(7);
        hashMap.put("min", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "min"), false);
        unitDefinition = (UnitDefinition)arrayList.get(2);
        hashMap.put("T", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "T"), false);
        unitDefinition = (UnitDefinition)arrayList.get(11);
        hashMap.put("V", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "V"), false);
        unitDefinition = (UnitDefinition)arrayList.get(35);
        hashMap.put("W", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "W"), false);
        unitDefinition = (UnitDefinition)arrayList.get(22);
        hashMap.put("mas", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "mas"), false);
        unitDefinition = (UnitDefinition)arrayList.get(62);
        hashMap.put("solLum", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "solLum"), false);
        unitDefinition = (UnitDefinition)arrayList.get(3);
        hashMap.put("sr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "sr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(54);
        hashMap.put("a", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "a"), false);
        unitDefinition = (UnitDefinition)arrayList.get(44);
        hashMap.put("cd", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "cd"), false);
        unitDefinition = (UnitDefinition)arrayList.get(49);
        hashMap.put("d", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "d"), false);
        unitDefinition = (UnitDefinition)arrayList.get(25);
        hashMap.put("Ry", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Ry"), false);
        unitDefinition = (UnitDefinition)arrayList.get(38);
        hashMap.put("g", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "g"), false);
        unitDefinition = (UnitDefinition)arrayList.get(64);
        hashMap.put("h", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "h"), false);
        unitDefinition = (UnitDefinition)arrayList.get(40);
        hashMap.put("Wb", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Wb"), false);
        unitDefinition = (UnitDefinition)arrayList.get(23);
        hashMap.put("m", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "m"), false);
        unitDefinition = (UnitDefinition)arrayList.get(6);
        hashMap.put("solRad", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "solRad"), false);
        unitDefinition = (UnitDefinition)arrayList.get(18);
        hashMap.put("Jy", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Jy"), false);
        unitDefinition = (UnitDefinition)arrayList.get(34);
        hashMap.put("ct", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "ct"), false);
        unitDefinition = (UnitDefinition)arrayList.get(59);
        hashMap.put("pc", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "pc"), false);
        unitDefinition = (UnitDefinition)arrayList.get(20);
        hashMap.put("s", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "s"), false);
        this.syntaxToUnitLookupMap.put(Syntax.CDS, hashMap);
        this.syntaxToUnitRepresentationMap.put(Syntax.CDS, hashMap2);
        hashMap = new HashMap();
        hashMap2 = new HashMap();
        unitDefinition = (UnitDefinition)arrayList.get(5);
        hashMap.put("lm", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lm"), false);
        unitDefinition = (UnitDefinition)arrayList.get(19);
        hashMap.put("lyr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "lyr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(46);
        hashMap.put("bin", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "bin"), false);
        unitDefinition = (UnitDefinition)arrayList.get(8);
        hashMap.put("deg", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "deg"), false);
        unitDefinition = (UnitDefinition)arrayList.get(28);
        hashMap.put("mol", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "mol"), false);
        unitDefinition = (UnitDefinition)arrayList.get(36);
        hashMap.put("lx", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lx"), false);
        unitDefinition = (UnitDefinition)arrayList.get(14);
        hashMap.put("Pa", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Pa"), false);
        unitDefinition = (UnitDefinition)arrayList.get(56);
        hashMap.put("eV", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "eV"), false);
        unitDefinition = (UnitDefinition)arrayList.get(50);
        hashMap.put("rad", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "rad"), false);
        unitDefinition = (UnitDefinition)arrayList.get(42);
        hashMap.put("barn", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "barn"), false);
        unitDefinition = (UnitDefinition)arrayList.get(54);
        hashMap.put("yr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "yr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(0);
        hashMap.put("byte", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "byte"), false);
        unitDefinition = (UnitDefinition)arrayList.get(34);
        hashMap.put("count", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "count"), false);
        unitDefinition = (UnitDefinition)arrayList.get(27);
        hashMap.put("Hz", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Hz"), false);
        unitDefinition = (UnitDefinition)arrayList.get(15);
        hashMap.put("AU", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "AU"), false);
        unitDefinition = (UnitDefinition)arrayList.get(52);
        hashMap.put("ohm", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "ohm"), false);
        unitDefinition = (UnitDefinition)arrayList.get(48);
        hashMap.put("angstrom", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "angstrom"), false);
        unitDefinition = (UnitDefinition)arrayList.get(37);
        hashMap.put("arcmin", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "arcmin"), false);
        unitDefinition = (UnitDefinition)arrayList.get(55);
        hashMap.put("A", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "A"), false);
        unitDefinition = (UnitDefinition)arrayList.get(24);
        hashMap.put("C", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "C"), false);
        unitDefinition = (UnitDefinition)arrayList.get(58);
        hashMap.put("arcsec", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "arcsec"), false);
        unitDefinition = (UnitDefinition)arrayList.get(29);
        hashMap.put("F", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "F"), false);
        unitDefinition = (UnitDefinition)arrayList.get(21);
        hashMap.put("G", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "G"), false);
        unitDefinition = (UnitDefinition)arrayList.get(61);
        hashMap.put("H", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "H"), false);
        unitDefinition = (UnitDefinition)arrayList.get(33);
        hashMap.put("J", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "J"), false);
        unitDefinition = (UnitDefinition)arrayList.get(4);
        hashMap.put("K", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "K"), false);
        unitDefinition = (UnitDefinition)arrayList.get(1);
        hashMap.put("N", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "N"), false);
        unitDefinition = (UnitDefinition)arrayList.get(9);
        hashMap.put("Crab", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Crab"), false);
        unitDefinition = (UnitDefinition)arrayList.get(16);
        hashMap.put("mag", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "mag"), false);
        unitDefinition = (UnitDefinition)arrayList.get(17);
        hashMap.put("S", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "S"), false);
        unitDefinition = (UnitDefinition)arrayList.get(7);
        hashMap.put("min", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "min"), false);
        unitDefinition = (UnitDefinition)arrayList.get(2);
        hashMap.put("T", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "T"), false);
        unitDefinition = (UnitDefinition)arrayList.get(11);
        hashMap.put("V", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "V"), false);
        unitDefinition = (UnitDefinition)arrayList.get(35);
        hashMap.put("W", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "W"), false);
        unitDefinition = (UnitDefinition)arrayList.get(13);
        hashMap.put("erg", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "erg"), false);
        unitDefinition = (UnitDefinition)arrayList.get(32);
        hashMap.put("pixel", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "pixel"), false);
        unitDefinition = (UnitDefinition)arrayList.get(3);
        hashMap.put("sr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "sr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(44);
        hashMap.put("cd", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "cd"), false);
        unitDefinition = (UnitDefinition)arrayList.get(49);
        hashMap.put("d", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "d"), false);
        unitDefinition = (UnitDefinition)arrayList.get(38);
        hashMap.put("g", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "g"), false);
        unitDefinition = (UnitDefinition)arrayList.get(64);
        hashMap.put("h", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "h"), false);
        unitDefinition = (UnitDefinition)arrayList.get(40);
        hashMap.put("Wb", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Wb"), false);
        unitDefinition = (UnitDefinition)arrayList.get(23);
        hashMap.put("m", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "m"), false);
        unitDefinition = (UnitDefinition)arrayList.get(18);
        hashMap.put("Jy", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Jy"), false);
        unitDefinition = (UnitDefinition)arrayList.get(43);
        hashMap.put("photon", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "photon"), false);
        unitDefinition = (UnitDefinition)arrayList.get(59);
        hashMap.put("pc", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "pc"), false);
        unitDefinition = (UnitDefinition)arrayList.get(20);
        hashMap.put("s", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "s"), false);
        unitDefinition = (UnitDefinition)arrayList.get(31);
        hashMap.put("voxel", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "voxel"), false);
        unitDefinition = (UnitDefinition)arrayList.get(10);
        hashMap.put("chan", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "chan"), false);
        this.syntaxToUnitLookupMap.put(Syntax.OGIP, hashMap);
        this.syntaxToUnitRepresentationMap.put(Syntax.OGIP, hashMap2);
        hashMap = new HashMap();
        hashMap2 = new HashMap();
        unitDefinition = (UnitDefinition)arrayList.get(51);
        hashMap.put("beam", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "beam"), false);
        unitDefinition = (UnitDefinition)arrayList.get(5);
        hashMap.put("lm", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lm"), false);
        unitDefinition = (UnitDefinition)arrayList.get(19);
        hashMap.put("lyr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lyr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(46);
        hashMap.put("bin", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "bin"), false);
        unitDefinition = (UnitDefinition)arrayList.get(8);
        hashMap.put("deg", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "deg"), false);
        unitDefinition = (UnitDefinition)arrayList.get(28);
        hashMap.put("mol", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "mol"), false);
        unitDefinition = (UnitDefinition)arrayList.get(39);
        hashMap.put("bit", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, true, false, "bit"), false);
        unitDefinition = (UnitDefinition)arrayList.get(36);
        hashMap.put("lx", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lx"), false);
        unitDefinition = (UnitDefinition)arrayList.get(14);
        hashMap.put("Pa", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Pa"), false);
        unitDefinition = (UnitDefinition)arrayList.get(56);
        hashMap.put("eV", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "eV"), false);
        unitDefinition = (UnitDefinition)arrayList.get(50);
        hashMap.put("rad", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "rad"), false);
        unitDefinition = (UnitDefinition)arrayList.get(52);
        hashMap.put("Ohm", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Ohm"), false);
        unitDefinition = (UnitDefinition)arrayList.get(42);
        hashMap.put("barn", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, true, "barn"), false);
        unitDefinition = (UnitDefinition)arrayList.get(54);
        hashMap.put("yr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "yr"), true);
        unitDefinition = (UnitDefinition)arrayList.get(32);
        hashMap.put("pix", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "pix"), false);
        unitDefinition = (UnitDefinition)arrayList.get(45);
        hashMap.put("%", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "%"), false);
        unitDefinition = (UnitDefinition)arrayList.get(0);
        hashMap.put("byte", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, true, false, "byte"), true);
        unitDefinition = (UnitDefinition)arrayList.get(34);
        hashMap.put("count", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "count"), true);
        unitDefinition = (UnitDefinition)arrayList.get(27);
        hashMap.put("Hz", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Hz"), false);
        unitDefinition = (UnitDefinition)arrayList.get(12);
        hashMap.put("adu", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "adu"), false);
        unitDefinition = (UnitDefinition)arrayList.get(15);
        hashMap.put("AU", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "AU"), true);
        unitDefinition = (UnitDefinition)arrayList.get(15);
        hashMap.put("au", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "au"), false);
        unitDefinition = (UnitDefinition)arrayList.get(48);
        hashMap.put("angstrom", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, true, "angstrom"), false);
        unitDefinition = (UnitDefinition)arrayList.get(37);
        hashMap.put("arcmin", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "arcmin"), false);
        unitDefinition = (UnitDefinition)arrayList.get(48);
        hashMap.put("Angstrom", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, true, "Angstrom"), true);
        unitDefinition = (UnitDefinition)arrayList.get(55);
        hashMap.put("A", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "A"), false);
        unitDefinition = (UnitDefinition)arrayList.get(0);
        hashMap.put("B", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, true, false, "B"), false);
        unitDefinition = (UnitDefinition)arrayList.get(24);
        hashMap.put("C", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "C"), false);
        unitDefinition = (UnitDefinition)arrayList.get(57);
        hashMap.put("D", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "D"), false);
        unitDefinition = (UnitDefinition)arrayList.get(58);
        hashMap.put("arcsec", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "arcsec"), false);
        unitDefinition = (UnitDefinition)arrayList.get(29);
        hashMap.put("F", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "F"), false);
        unitDefinition = (UnitDefinition)arrayList.get(21);
        hashMap.put("G", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, true, "G"), false);
        unitDefinition = (UnitDefinition)arrayList.get(61);
        hashMap.put("H", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "H"), false);
        unitDefinition = (UnitDefinition)arrayList.get(47);
        hashMap.put("solMass", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "solMass"), false);
        unitDefinition = (UnitDefinition)arrayList.get(33);
        hashMap.put("J", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "J"), false);
        unitDefinition = (UnitDefinition)arrayList.get(4);
        hashMap.put("K", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "K"), false);
        unitDefinition = (UnitDefinition)arrayList.get(1);
        hashMap.put("N", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "N"), false);
        unitDefinition = (UnitDefinition)arrayList.get(60);
        hashMap.put("R", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "R"), false);
        unitDefinition = (UnitDefinition)arrayList.get(16);
        hashMap.put("mag", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "mag"), false);
        unitDefinition = (UnitDefinition)arrayList.get(17);
        hashMap.put("S", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "S"), false);
        unitDefinition = (UnitDefinition)arrayList.get(7);
        hashMap.put("min", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "min"), false);
        unitDefinition = (UnitDefinition)arrayList.get(2);
        hashMap.put("T", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "T"), false);
        unitDefinition = (UnitDefinition)arrayList.get(11);
        hashMap.put("V", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "V"), false);
        unitDefinition = (UnitDefinition)arrayList.get(35);
        hashMap.put("W", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "W"), false);
        unitDefinition = (UnitDefinition)arrayList.get(13);
        hashMap.put("erg", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, true, "erg"), false);
        unitDefinition = (UnitDefinition)arrayList.get(32);
        hashMap.put("pixel", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "pixel"), true);
        unitDefinition = (UnitDefinition)arrayList.get(26);
        hashMap.put("dB", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "dB"), false);
        unitDefinition = (UnitDefinition)arrayList.get(22);
        hashMap.put("mas", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "mas"), false);
        unitDefinition = (UnitDefinition)arrayList.get(30);
        hashMap.put("Ba", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, true, "Ba"), false);
        unitDefinition = (UnitDefinition)arrayList.get(62);
        hashMap.put("solLum", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "solLum"), false);
        unitDefinition = (UnitDefinition)arrayList.get(3);
        hashMap.put("sr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "sr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(54);
        hashMap.put("a", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "a"), false);
        unitDefinition = (UnitDefinition)arrayList.get(44);
        hashMap.put("cd", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "cd"), false);
        unitDefinition = (UnitDefinition)arrayList.get(49);
        hashMap.put("d", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "d"), false);
        unitDefinition = (UnitDefinition)arrayList.get(25);
        hashMap.put("Ry", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Ry"), false);
        unitDefinition = (UnitDefinition)arrayList.get(38);
        hashMap.put("g", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "g"), false);
        unitDefinition = (UnitDefinition)arrayList.get(64);
        hashMap.put("h", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "h"), false);
        unitDefinition = (UnitDefinition)arrayList.get(40);
        hashMap.put("Wb", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Wb"), false);
        unitDefinition = (UnitDefinition)arrayList.get(23);
        hashMap.put("m", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "m"), false);
        unitDefinition = (UnitDefinition)arrayList.get(53);
        hashMap.put("ta", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, true, "ta"), false);
        unitDefinition = (UnitDefinition)arrayList.get(6);
        hashMap.put("solRad", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "solRad"), false);
        unitDefinition = (UnitDefinition)arrayList.get(18);
        hashMap.put("Jy", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Jy"), false);
        unitDefinition = (UnitDefinition)arrayList.get(43);
        hashMap.put("photon", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "photon"), true);
        unitDefinition = (UnitDefinition)arrayList.get(34);
        hashMap.put("ct", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "ct"), false);
        unitDefinition = (UnitDefinition)arrayList.get(59);
        hashMap.put("pc", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "pc"), false);
        unitDefinition = (UnitDefinition)arrayList.get(20);
        hashMap.put("s", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "s"), false);
        unitDefinition = (UnitDefinition)arrayList.get(63);
        hashMap.put("u", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "u"), false);
        unitDefinition = (UnitDefinition)arrayList.get(31);
        hashMap.put("voxel", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "voxel"), false);
        unitDefinition = (UnitDefinition)arrayList.get(43);
        hashMap.put("ph", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "ph"), false);
        unitDefinition = (UnitDefinition)arrayList.get(10);
        hashMap.put("chan", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "chan"), false);
        this.syntaxToUnitLookupMap.put(Syntax.VOUNITS, hashMap);
        this.syntaxToUnitRepresentationMap.put(Syntax.VOUNITS, hashMap2);
        hashMap = new HashMap();
        hashMap2 = new HashMap();
        unitDefinition = (UnitDefinition)arrayList.get(51);
        hashMap.put("beam", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "beam"), false);
        unitDefinition = (UnitDefinition)arrayList.get(5);
        hashMap.put("lm", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lm"), false);
        unitDefinition = (UnitDefinition)arrayList.get(19);
        hashMap.put("lyr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "lyr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(46);
        hashMap.put("bin", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "bin"), false);
        unitDefinition = (UnitDefinition)arrayList.get(8);
        hashMap.put("deg", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "deg"), false);
        unitDefinition = (UnitDefinition)arrayList.get(28);
        hashMap.put("mol", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "mol"), false);
        unitDefinition = (UnitDefinition)arrayList.get(39);
        hashMap.put("bit", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "bit"), false);
        unitDefinition = (UnitDefinition)arrayList.get(36);
        hashMap.put("lx", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "lx"), false);
        unitDefinition = (UnitDefinition)arrayList.get(14);
        hashMap.put("Pa", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Pa"), false);
        unitDefinition = (UnitDefinition)arrayList.get(56);
        hashMap.put("eV", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "eV"), false);
        unitDefinition = (UnitDefinition)arrayList.get(50);
        hashMap.put("rad", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "rad"), false);
        unitDefinition = (UnitDefinition)arrayList.get(52);
        hashMap.put("Ohm", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Ohm"), false);
        unitDefinition = (UnitDefinition)arrayList.get(42);
        hashMap.put("barn", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, true, "barn"), false);
        unitDefinition = (UnitDefinition)arrayList.get(54);
        hashMap.put("yr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "yr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(32);
        hashMap.put("pix", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "pix"), false);
        unitDefinition = (UnitDefinition)arrayList.get(0);
        hashMap.put("byte", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "byte"), false);
        unitDefinition = (UnitDefinition)arrayList.get(34);
        hashMap.put("count", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "count"), false);
        unitDefinition = (UnitDefinition)arrayList.get(27);
        hashMap.put("Hz", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Hz"), false);
        unitDefinition = (UnitDefinition)arrayList.get(12);
        hashMap.put("adu", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "adu"), false);
        unitDefinition = (UnitDefinition)arrayList.get(15);
        hashMap.put("AU", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "AU"), false);
        unitDefinition = (UnitDefinition)arrayList.get(37);
        hashMap.put("arcmin", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "arcmin"), false);
        unitDefinition = (UnitDefinition)arrayList.get(48);
        hashMap.put("Angstrom", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, true, "Angstrom"), false);
        unitDefinition = (UnitDefinition)arrayList.get(55);
        hashMap.put("A", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "A"), false);
        unitDefinition = (UnitDefinition)arrayList.get(24);
        hashMap.put("C", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "C"), false);
        unitDefinition = (UnitDefinition)arrayList.get(57);
        hashMap.put("D", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "D"), false);
        unitDefinition = (UnitDefinition)arrayList.get(58);
        hashMap.put("arcsec", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "arcsec"), false);
        unitDefinition = (UnitDefinition)arrayList.get(29);
        hashMap.put("F", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "F"), false);
        unitDefinition = (UnitDefinition)arrayList.get(21);
        hashMap.put("G", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, true, "G"), false);
        unitDefinition = (UnitDefinition)arrayList.get(61);
        hashMap.put("H", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "H"), false);
        unitDefinition = (UnitDefinition)arrayList.get(47);
        hashMap.put("solMass", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "solMass"), false);
        unitDefinition = (UnitDefinition)arrayList.get(33);
        hashMap.put("J", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "J"), false);
        unitDefinition = (UnitDefinition)arrayList.get(4);
        hashMap.put("K", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "K"), false);
        unitDefinition = (UnitDefinition)arrayList.get(1);
        hashMap.put("N", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "N"), false);
        unitDefinition = (UnitDefinition)arrayList.get(60);
        hashMap.put("R", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "R"), false);
        unitDefinition = (UnitDefinition)arrayList.get(16);
        hashMap.put("mag", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "mag"), false);
        unitDefinition = (UnitDefinition)arrayList.get(17);
        hashMap.put("S", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "S"), false);
        unitDefinition = (UnitDefinition)arrayList.get(7);
        hashMap.put("min", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "min"), false);
        unitDefinition = (UnitDefinition)arrayList.get(2);
        hashMap.put("T", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "T"), false);
        unitDefinition = (UnitDefinition)arrayList.get(11);
        hashMap.put("V", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "V"), false);
        unitDefinition = (UnitDefinition)arrayList.get(35);
        hashMap.put("W", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "W"), false);
        unitDefinition = (UnitDefinition)arrayList.get(13);
        hashMap.put("erg", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, true, "erg"), false);
        unitDefinition = (UnitDefinition)arrayList.get(32);
        hashMap.put("pixel", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "pixel"), true);
        unitDefinition = (UnitDefinition)arrayList.get(22);
        hashMap.put("mas", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "mas"), false);
        unitDefinition = (UnitDefinition)arrayList.get(30);
        hashMap.put("Ba", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, true, "Ba"), false);
        unitDefinition = (UnitDefinition)arrayList.get(62);
        hashMap.put("solLum", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "solLum"), false);
        unitDefinition = (UnitDefinition)arrayList.get(3);
        hashMap.put("sr", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "sr"), false);
        unitDefinition = (UnitDefinition)arrayList.get(54);
        hashMap.put("a", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "a"), true);
        unitDefinition = (UnitDefinition)arrayList.get(44);
        hashMap.put("cd", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "cd"), false);
        unitDefinition = (UnitDefinition)arrayList.get(49);
        hashMap.put("d", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "d"), false);
        unitDefinition = (UnitDefinition)arrayList.get(25);
        hashMap.put("Ry", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "Ry"), false);
        unitDefinition = (UnitDefinition)arrayList.get(38);
        hashMap.put("g", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "g"), false);
        unitDefinition = (UnitDefinition)arrayList.get(64);
        hashMap.put("h", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "h"), false);
        unitDefinition = (UnitDefinition)arrayList.get(40);
        hashMap.put("Wb", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Wb"), false);
        unitDefinition = (UnitDefinition)arrayList.get(23);
        hashMap.put("m", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "m"), false);
        unitDefinition = (UnitDefinition)arrayList.get(53);
        hashMap.put("ta", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, true, "ta"), false);
        unitDefinition = (UnitDefinition)arrayList.get(6);
        hashMap.put("solRad", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "solRad"), false);
        unitDefinition = (UnitDefinition)arrayList.get(18);
        hashMap.put("Jy", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "Jy"), false);
        unitDefinition = (UnitDefinition)arrayList.get(43);
        hashMap.put("photon", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "photon"), true);
        unitDefinition = (UnitDefinition)arrayList.get(34);
        hashMap.put("ct", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "ct"), false);
        unitDefinition = (UnitDefinition)arrayList.get(59);
        hashMap.put("pc", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "pc"), false);
        unitDefinition = (UnitDefinition)arrayList.get(20);
        hashMap.put("s", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(true, false, false, "s"), false);
        unitDefinition = (UnitDefinition)arrayList.get(63);
        hashMap.put("u", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "u"), false);
        unitDefinition = (UnitDefinition)arrayList.get(31);
        hashMap.put("voxel", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "voxel"), false);
        unitDefinition = (UnitDefinition)arrayList.get(41);
        hashMap.put("cy", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "cy"), false);
        unitDefinition = (UnitDefinition)arrayList.get(43);
        hashMap.put("ph", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "ph"), false);
        unitDefinition = (UnitDefinition)arrayList.get(10);
        hashMap.put("chan", unitDefinition);
        this.mapUnitToRepresentation(hashMap2, unitDefinition, new UnitRepresentation(false, false, false, "chan"), false);
        this.syntaxToUnitLookupMap.put(Syntax.FITS, hashMap);
        this.syntaxToUnitRepresentationMap.put(Syntax.FITS, hashMap2);
        return this;
    }
}

