/*
 * Copyright (C) 2009-2010  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

class SourceHighlightIde;

class QAction;
class QSignalMapper;
class Assistant;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *event);

private slots:
      void newFile();
      void openInput();
      void about();

      void setActiveSubWindow(QWidget *window);
      void updateWindowMenu();
      void showDocumentation();
      void configureSourceHighlight();

private:
      void createActions();
      void createMenus();

      void readSettings();
      void writeSettings();

      SourceHighlightIde *activeMdiChild();

      /**
        * Checks that source-highlight settings are correct,
        * otherwise open the setting dialog.
        * @return whether settings are ok
        */
      bool checkSourceHighlightSettings();

      QAction *closeAct;
      QAction *closeAllAct;
      QAction *tileAct;
      QAction *cascadeAct;
      QAction *nextAct;
      QAction *previousAct;
      QAction *separatorAct;

      QSignalMapper *windowMapper;

private:
    Ui::MainWindow *ui;

    /// the instance for showing help contents
    Assistant *assistant;

    /// the path for help files
    QString helpPath;

    QString sourceHighlightDataDir;

};

#endif // MAINWINDOW_H
