/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.ImmutableAsList;
import com.squareup.haha.guava.collect.ImmutableCollection;
import com.squareup.haha.guava.collect.ImmutableList;
import com.squareup.haha.guava.collect.ImmutableMap;
import com.squareup.haha.guava.collect.ImmutableSet;
import com.squareup.haha.guava.collect.Multiset;
import com.squareup.haha.guava.collect.Multisets;
import com.squareup.haha.guava.collect.RegularImmutableMultiset;
import com.squareup.haha.guava.collect.UnmodifiableIterator;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public abstract class ImmutableMultiset<E>
extends ImmutableCollection<E>
implements Multiset<E> {
    private transient ImmutableSet<Multiset.Entry<E>> entrySet;

    ImmutableMultiset() {
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        Iterator entryIterator = ((ImmutableSet)this.entrySet()).iterator();
        return new UnmodifiableIterator<E>(this, entryIterator){
            private int remaining;
            private E element;
            private /* synthetic */ Iterator val$entryIterator;
            {
                this.val$entryIterator = iterator;
            }

            @Override
            public final boolean hasNext() {
                return this.remaining > 0 || this.val$entryIterator.hasNext();
            }

            @Override
            public final E next() {
                if (this.remaining <= 0) {
                    Multiset.Entry entry = (Multiset.Entry)this.val$entryIterator.next();
                    this.element = entry.getElement();
                    this.remaining = entry.getCount();
                }
                --this.remaining;
                return this.element;
            }
        };
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.count(object) > 0;
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        return this.elementSet().containsAll(targets);
    }

    @Override
    @Deprecated
    public final int add(E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int setCount(E element, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean setCount(E element, int oldCount, int newCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    final int copyIntoArray(Object[] dst, int offset) {
        for (Multiset.Entry entry : this.entrySet()) {
            Arrays.fill(dst, offset, offset + entry.getCount(), entry.getElement());
            offset += entry.getCount();
        }
        return offset;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Multisets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Ascii.hashCodeImpl(this.entrySet());
    }

    @Override
    public String toString() {
        return ((AbstractCollection)((Object)this.entrySet())).toString();
    }

    @Override
    private ImmutableSet<Multiset.Entry<E>> entrySet() {
        ImmutableSet<Multiset.Entry<E>> es = this.entrySet;
        if (es == null) {
            ImmutableMultiset immutableMultiset = this;
            this.entrySet = immutableMultiset.isEmpty() ? ImmutableSet.of() : immutableMultiset.new EntrySet(0);
            return this.entrySet;
        }
        return es;
    }

    abstract Multiset.Entry<E> getEntry(int var1);

    static {
        new RegularImmutableMultiset(ImmutableMap.of(), 0);
    }

    final class EntrySet
    extends ImmutableSet<Multiset.Entry<E>> {
        private EntrySet() {
        }

        @Override
        final boolean isPartialView() {
            return ImmutableMultiset.this.isPartialView();
        }

        @Override
        public final UnmodifiableIterator<Multiset.Entry<E>> iterator() {
            return this.asList().iterator();
        }

        @Override
        final ImmutableList<Multiset.Entry<E>> createAsList() {
            return new ImmutableAsList<Multiset.Entry<E>>(this){
                private /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = entrySet;
                }

                @Override
                final ImmutableCollection<Multiset.Entry<E>> delegateCollection() {
                    return this.this$1;
                }
            };
        }

        @Override
        public final int size() {
            return ImmutableMultiset.this.elementSet().size();
        }

        @Override
        public final boolean contains(Object o) {
            if (o instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)o;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int count = ImmutableMultiset.this.count(entry.getElement());
                return count == entry.getCount();
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return ImmutableMultiset.this.hashCode();
        }

        /* synthetic */ EntrySet(byte by) {
            this();
        }
    }
}

