#------------------------------------------------------------------------------
# Copyright (c) 2011, Enthought, Inc.
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
#------------------------------------------------------------------------------
""" Pointer and Key names for enable. Note that when these lists change,
    corresponding lists in each of the toolkit backends need to be changed as
    well. A warning will be printed when the enable.window module is imported
    if the current toolkit's mapping is a different length than a list given
    here.
"""

# Mouse pointer names
pointer_names = [
    'arrow',
    'arrow wait',
    'blank',
    'bullseye',
    'char',
    'cross',
    'hand',
    'ibeam',
    'left button',
    'magnifier',
    'middle button',
    'no entry',
    'paint brush',
    'pencil',
    'point left',
    'point right',
    'question arrow',
    'right arrow',
    'right button',
    'size bottom',
    'size bottom left',
    'size bottom right',
    'size left',
    'size right',
    'size top',
    'size top left',
    'size top right',
    'sizing',
    'spray can',
    'wait',
    'watch',
]

# Keyboard key names
key_names = [
    'Add',
    'Backspace',
    'Cancel',
    'Capital',
    'Clear',
    'Control',
    'Decimal',
    'Delete',
    'Divide',
    'Down',
    'End',
    'Enter',
    'Enter',
    'Esc',
    'Execute',
    'F1',
    'F10',
    'F11',
    'F12',
    'F13',
    'F14',
    'F15',
    'F16',
    'F17',
    'F18',
    'F19',
    'F2',
    'F20',
    'F21',
    'F22',
    'F23',
    'F24',
    'F3',
    'F4',
    'F5',
    'F6',
    'F7',
    'F8',
    'F9',
    'Help',
    'Home',
    'Insert',
    'Left',
    'Menu',
    'Multiply',
    'Num Lock',
    'Numpad 0',
    'Numpad 1',
    'Numpad 2',
    'Numpad 3',
    'Numpad 4',
    'Numpad 5',
    'Numpad 6',
    'Numpad 7',
    'Numpad 8',
    'Numpad 9',
    'Page Down',
    'Page Up',
    'Pause',
    'Print',
    'Right',
    'Scroll Lock',
    'Select',
    'Shift',
    'Subtract',
    'Tab',
    'Up',
    'Alt',
]

mouse_wheel_axes_names = ['vertical', 'horizontal']
