# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, AsyncIterator, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import MatchConditions
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._operations._operations import (
    build_azure_app_configuration_check_key_value_request,
    build_azure_app_configuration_check_key_values_request,
    build_azure_app_configuration_check_keys_request,
    build_azure_app_configuration_check_labels_request,
    build_azure_app_configuration_check_revisions_request,
    build_azure_app_configuration_check_snapshot_request,
    build_azure_app_configuration_check_snapshots_request,
    build_azure_app_configuration_create_snapshot_request,
    build_azure_app_configuration_delete_key_value_request,
    build_azure_app_configuration_delete_lock_request,
    build_azure_app_configuration_get_key_value_request,
    build_azure_app_configuration_get_key_values_request,
    build_azure_app_configuration_get_keys_request,
    build_azure_app_configuration_get_labels_request,
    build_azure_app_configuration_get_operation_details_request,
    build_azure_app_configuration_get_revisions_request,
    build_azure_app_configuration_get_snapshot_request,
    build_azure_app_configuration_get_snapshots_request,
    build_azure_app_configuration_put_key_value_request,
    build_azure_app_configuration_put_lock_request,
    build_azure_app_configuration_update_snapshot_request,
)
from .._vendor import AzureAppConfigurationClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AzureAppConfigurationClientOperationsMixin(  # pylint: disable=too-many-public-methods,name-too-long
    AzureAppConfigurationClientMixinABC
):

    @distributed_trace
    def get_keys(
        self,
        *,
        name: Optional[str] = None,
        after: Optional[str] = None,
        sync_token: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Key"]:
        """Gets a list of keys.

        Gets a list of keys.

        :keyword name: A filter for the name of the returned keys. Default value is None.
        :paramtype name: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :return: An iterator like instance of Key
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.Key]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Key]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_azure_app_configuration_get_keys_request(
                    name=name,
                    after=after,
                    sync_token=sync_token,
                    accept_datetime=accept_datetime,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Key], deserialized["items"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("@nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.Error, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def check_keys(
        self,
        *,
        name: Optional[str] = None,
        sync_token: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        **kwargs: Any
    ) -> bool:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :keyword name: A filter for the name of the returned keys. Default value is None.
        :paramtype name: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_check_keys_request(
            name=name,
            sync_token=sync_token,
            after=after,
            accept_datetime=accept_datetime,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace
    def get_key_values(
        self,
        *,
        key: Optional[str] = None,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, _models.ConfigurationSettingFields]]] = None,
        snapshot: Optional[str] = None,
        tags: Optional[List[str]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.KeyValue"]:
        """Gets a list of key-values.

        Gets a list of key-values.

        :keyword key: A filter used to match keys. Syntax reference:
         https://aka.ms/azconfig/docs/keyvaluefiltering. Default value is None.
        :paramtype key: str
        :keyword label: A filter used to match labels. Syntax reference:
         https://aka.ms/azconfig/docs/keyvaluefiltering. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.ConfigurationSettingFields]
        :keyword snapshot: A filter used get key-values for a snapshot. The value should be the name of
         the snapshot. Not valid when used with 'key' and 'label' filters. Default value is None.
        :paramtype snapshot: str
        :keyword tags: A filter used to query by tags. Syntax reference:
         https://aka.ms/azconfig/docs/keyvaluefiltering. Default value is None.
        :paramtype tags: list[str]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: An iterator like instance of KeyValue
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.KeyValue]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.KeyValue]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_azure_app_configuration_get_key_values_request(
                    key=key,
                    label=label,
                    sync_token=sync_token,
                    after=after,
                    accept_datetime=accept_datetime,
                    select=select,
                    snapshot=snapshot,
                    tags=tags,
                    etag=etag,
                    match_condition=match_condition,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.KeyValue], deserialized["items"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("@nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.Error, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def check_key_values(
        self,
        *,
        key: Optional[str] = None,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, _models.ConfigurationSettingFields]]] = None,
        snapshot: Optional[str] = None,
        tags: Optional[List[str]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> bool:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :keyword key: A filter used to match keys. Syntax reference:
         https://aka.ms/azconfig/docs/keyvaluefiltering. Default value is None.
        :paramtype key: str
        :keyword label: A filter used to match labels. Syntax reference:
         https://aka.ms/azconfig/docs/keyvaluefiltering. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.ConfigurationSettingFields]
        :keyword snapshot: A filter used get key-values for a snapshot. Not valid when used with 'key'
         and 'label' filters. Default value is None.
        :paramtype snapshot: str
        :keyword tags: A filter used to query by tags. Syntax reference:
         https://aka.ms/azconfig/docs/keyvaluefiltering. Default value is None.
        :paramtype tags: list[str]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_check_key_values_request(
            key=key,
            label=label,
            sync_token=sync_token,
            after=after,
            accept_datetime=accept_datetime,
            select=select,
            snapshot=snapshot,
            tags=tags,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace_async
    async def get_key_value(
        self,
        key: str,
        *,
        label: Optional[str] = None,
        select: Optional[List[Union[str, _models.ConfigurationSettingFields]]] = None,
        sync_token: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.KeyValue:
        """Gets a single key-value.

        Gets a single key-value.

        :param key: The key of the key-value. Required.
        :type key: str
        :keyword label: The label of the key-value to retrieve. Default value is None.
        :paramtype label: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.ConfigurationSettingFields]
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: KeyValue. The KeyValue is compatible with MutableMapping
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.KeyValue] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_get_key_value_request(
            key=key,
            label=label,
            select=select,
            sync_token=sync_token,
            accept_datetime=accept_datetime,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.KeyValue, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _put_key_value(
        self,
        key: str,
        entity: Optional[_models.KeyValue] = None,
        *,
        content_type: str,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.KeyValue: ...
    @overload
    async def _put_key_value(
        self,
        key: str,
        entity: Optional[JSON] = None,
        *,
        content_type: str,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.KeyValue: ...
    @overload
    async def _put_key_value(
        self,
        key: str,
        entity: Optional[IO[bytes]] = None,
        *,
        content_type: str,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.KeyValue: ...

    @distributed_trace_async
    async def _put_key_value(
        self,
        key: str,
        entity: Optional[Union[_models.KeyValue, JSON, IO[bytes]]] = None,
        *,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.KeyValue:
        """Creates a key-value.

        Creates a key-value.

        :param key: The key of the key-value to create. Required.
        :type key: str
        :param entity: The key-value to create. Is one of the following types: KeyValue, JSON,
         IO[bytes] Default value is None.
        :type entity: ~azure.appconfiguration.models.KeyValue or JSON or IO[bytes]
        :keyword label: The label of the key-value to create. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: KeyValue. The KeyValue is compatible with MutableMapping
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyValue] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(entity, (IOBase, bytes)):
            _content = entity
        else:
            if entity is not None:
                _content = json.dumps(entity, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_azure_app_configuration_put_key_value_request(
            key=key,
            label=label,
            sync_token=sync_token,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.KeyValue, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_key_value(
        self,
        key: str,
        *,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> Optional[_models.KeyValue]:
        """Deletes a key-value.

        Deletes a key-value.

        :param key: The key of the key-value to delete. Required.
        :type key: str
        :keyword label: The label of the key-value to delete. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: KeyValue or None. The KeyValue is compatible with MutableMapping
        :rtype: ~azure.appconfiguration.models.KeyValue or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[_models.KeyValue]] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_delete_key_value_request(
            key=key,
            label=label,
            sync_token=sync_token,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.KeyValue, response.json())

        if response.status_code == 204:
            response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def check_key_value(
        self,
        key: str,
        *,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, _models.ConfigurationSettingFields]]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> bool:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param key: The key of the key-value to retrieve. Required.
        :type key: str
        :keyword label: The label of the key-value to retrieve. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.ConfigurationSettingFields]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_check_key_value_request(
            key=key,
            label=label,
            sync_token=sync_token,
            accept_datetime=accept_datetime,
            select=select,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace
    def get_snapshots(
        self,
        *,
        name: Optional[str] = None,
        after: Optional[str] = None,
        select: Optional[List[Union[str, _models.SnapshotFields]]] = None,
        status: Optional[List[Union[str, _models.SnapshotStatus]]] = None,
        sync_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Snapshot"]:
        """Gets a list of key-value snapshots.

        Gets a list of key-value snapshots.

        :keyword name: A filter for the name of the returned snapshots. Default value is None.
        :paramtype name: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.SnapshotFields]
        :keyword status: Used to filter returned snapshots by their status property. Default value is
         None.
        :paramtype status: list[str or ~azure.appconfiguration.models.SnapshotStatus]
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :return: An iterator like instance of Snapshot
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.Snapshot]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Snapshot]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_azure_app_configuration_get_snapshots_request(
                    name=name,
                    after=after,
                    select=select,
                    status=status,
                    sync_token=sync_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Snapshot], deserialized["items"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("@nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.Error, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def check_snapshots(
        self, *, sync_token: Optional[str] = None, after: Optional[str] = None, **kwargs: Any
    ) -> bool:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_check_snapshots_request(
            sync_token=sync_token,
            after=after,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace_async
    async def get_snapshot(
        self,
        name: str,
        *,
        select: Optional[List[Union[str, _models.SnapshotFields]]] = None,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Snapshot:
        """Gets a single key-value snapshot.

        Gets a single key-value snapshot.

        :param name: The name of the snapshot. Required.
        :type name: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.SnapshotFields]
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Snapshot. The Snapshot is compatible with MutableMapping
        :rtype: ~azure.appconfiguration.models.Snapshot
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Snapshot] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_get_snapshot_request(
            name=name,
            select=select,
            sync_token=sync_token,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Link"] = self._deserialize("str", response.headers.get("Link"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Snapshot, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_operation_details(self, *, snapshot: str, **kwargs: Any) -> _models.OperationDetails:
        """Gets the state of a long running operation.

        Gets the state of a long running operation.

        :keyword snapshot: Snapshot identifier for the long running operation. Required.
        :paramtype snapshot: str
        :return: OperationDetails. The OperationDetails is compatible with MutableMapping
        :rtype: ~azure.appconfiguration.models.OperationDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.OperationDetails] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_get_operation_details_request(
            snapshot=snapshot,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.OperationDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_snapshot_initial(
        self,
        name: str,
        entity: Union[_models.Snapshot, JSON, IO[bytes]],
        *,
        sync_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(entity, (IOBase, bytes)):
            _content = entity
        else:
            _content = json.dumps(entity, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_azure_app_configuration_create_snapshot_request(
            name=name,
            sync_token=sync_token,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Link"] = self._deserialize("str", response.headers.get("Link"))
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_snapshot(
        self, name: str, entity: _models.Snapshot, *, content_type: str, sync_token: Optional[str] = None, **kwargs: Any
    ) -> AsyncLROPoller[_models.Snapshot]:
        """Creates a key-value snapshot.

        Creates a key-value snapshot.

        :param name: The name of the key-value snapshot to create. Required.
        :type name: str
        :param entity: The key-value snapshot to create. Required.
        :type entity: ~azure.appconfiguration.models.Snapshot
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Required.
        :paramtype content_type: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :return: An instance of AsyncLROPoller that returns Snapshot. The Snapshot is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.appconfiguration.models.Snapshot]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_snapshot(
        self, name: str, entity: JSON, *, content_type: str, sync_token: Optional[str] = None, **kwargs: Any
    ) -> AsyncLROPoller[_models.Snapshot]:
        """Creates a key-value snapshot.

        Creates a key-value snapshot.

        :param name: The name of the key-value snapshot to create. Required.
        :type name: str
        :param entity: The key-value snapshot to create. Required.
        :type entity: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Required.
        :paramtype content_type: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :return: An instance of AsyncLROPoller that returns Snapshot. The Snapshot is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.appconfiguration.models.Snapshot]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_snapshot(
        self, name: str, entity: IO[bytes], *, content_type: str, sync_token: Optional[str] = None, **kwargs: Any
    ) -> AsyncLROPoller[_models.Snapshot]:
        """Creates a key-value snapshot.

        Creates a key-value snapshot.

        :param name: The name of the key-value snapshot to create. Required.
        :type name: str
        :param entity: The key-value snapshot to create. Required.
        :type entity: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/vnd.microsoft.appconfig.snapshot+json', 'application/json'.
         Required.
        :paramtype content_type: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :return: An instance of AsyncLROPoller that returns Snapshot. The Snapshot is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.appconfiguration.models.Snapshot]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_snapshot(
        self,
        name: str,
        entity: Union[_models.Snapshot, JSON, IO[bytes]],
        *,
        sync_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Snapshot]:
        """Creates a key-value snapshot.

        Creates a key-value snapshot.

        :param name: The name of the key-value snapshot to create. Required.
        :type name: str
        :param entity: The key-value snapshot to create. Is one of the following types: Snapshot, JSON,
         IO[bytes] Required.
        :type entity: ~azure.appconfiguration.models.Snapshot or JSON or IO[bytes]
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :return: An instance of AsyncLROPoller that returns Snapshot. The Snapshot is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.appconfiguration.models.Snapshot]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Snapshot] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_snapshot_initial(
                name=name,
                entity=entity,
                sync_token=sync_token,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Link"] = self._deserialize("str", response.headers.get("Link"))
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )
            response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

            deserialized = _deserialize(_models.Snapshot, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Snapshot].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Snapshot](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def _update_snapshot(
        self,
        name: str,
        entity: _models.SnapshotUpdateParameters,
        *,
        content_type: str,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Snapshot: ...
    @overload
    async def _update_snapshot(
        self,
        name: str,
        entity: JSON,
        *,
        content_type: str,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Snapshot: ...
    @overload
    async def _update_snapshot(
        self,
        name: str,
        entity: IO[bytes],
        *,
        content_type: str,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Snapshot: ...

    @distributed_trace_async
    async def _update_snapshot(
        self,
        name: str,
        entity: Union[_models.SnapshotUpdateParameters, JSON, IO[bytes]],
        *,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Snapshot:
        """Updates the state of a key-value snapshot.

        Updates the state of a key-value snapshot.

        :param name: The name of the key-value snapshot to update. Required.
        :type name: str
        :param entity: The parameters used to update the snapshot. Is one of the following types:
         SnapshotUpdateParameters, JSON, IO[bytes] Required.
        :type entity: ~azure.appconfiguration.models.SnapshotUpdateParameters or JSON or IO[bytes]
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Snapshot. The Snapshot is compatible with MutableMapping
        :rtype: ~azure.appconfiguration.models.Snapshot
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Snapshot] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(entity, (IOBase, bytes)):
            _content = entity
        else:
            _content = json.dumps(entity, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_azure_app_configuration_update_snapshot_request(
            name=name,
            sync_token=sync_token,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Link"] = self._deserialize("str", response.headers.get("Link"))
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Snapshot, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def check_snapshot(
        self,
        name: str,
        *,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> bool:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param name: The name of the key-value snapshot to check. Required.
        :type name: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_check_snapshot_request(
            name=name,
            sync_token=sync_token,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Link"] = self._deserialize("str", response.headers.get("Link"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace
    def get_labels(
        self,
        *,
        name: Optional[str] = None,
        sync_token: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, _models.LabelFields]]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Label"]:
        """Gets a list of labels.

        Gets a list of labels.

        :keyword name: A filter for the name of the returned labels. Default value is None.
        :paramtype name: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.LabelFields]
        :return: An iterator like instance of Label
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.Label]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Label]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_azure_app_configuration_get_labels_request(
                    name=name,
                    sync_token=sync_token,
                    after=after,
                    accept_datetime=accept_datetime,
                    select=select,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Label], deserialized["items"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("@nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.Error, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def check_labels(
        self,
        *,
        name: Optional[str] = None,
        sync_token: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, _models.LabelFields]]] = None,
        **kwargs: Any
    ) -> bool:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :keyword name: A filter for the name of the returned labels. Default value is None.
        :paramtype name: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.LabelFields]
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_check_labels_request(
            name=name,
            sync_token=sync_token,
            after=after,
            accept_datetime=accept_datetime,
            select=select,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace_async
    async def put_lock(
        self,
        key: str,
        *,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.KeyValue:
        """Locks a key-value.

        Locks a key-value.

        :param key: The key of the key-value to lock. Required.
        :type key: str
        :keyword label: The label, if any, of the key-value to lock. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: KeyValue. The KeyValue is compatible with MutableMapping
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.KeyValue] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_put_lock_request(
            key=key,
            label=label,
            sync_token=sync_token,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.KeyValue, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_lock(
        self,
        key: str,
        *,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.KeyValue:
        """Unlocks a key-value.

        Unlocks a key-value.

        :param key: The key of the key-value to unlock. Required.
        :type key: str
        :keyword label: The label, if any, of the key-value to unlock. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: KeyValue. The KeyValue is compatible with MutableMapping
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.KeyValue] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_delete_lock_request(
            key=key,
            label=label,
            sync_token=sync_token,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Content-Type"] = self._deserialize("str", response.headers.get("Content-Type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.KeyValue, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_revisions(
        self,
        *,
        key: Optional[str] = None,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, _models.ConfigurationSettingFields]]] = None,
        tags: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.KeyValue"]:
        """Gets a list of key-value revisions.

        Gets a list of key-value revisions.

        :keyword key: A filter used to match keys. Syntax reference:
         https://aka.ms/azconfig/docs/restapirevisions. Default value is None.
        :paramtype key: str
        :keyword label: A filter used to match labels. Syntax reference:
         https://aka.ms/azconfig/docs/restapirevisions. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.ConfigurationSettingFields]
        :keyword tags: A filter used to query by tags. Syntax reference:
         https://aka.ms/azconfig/docs/restapirevisions. Default value is None.
        :paramtype tags: list[str]
        :return: An iterator like instance of KeyValue
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.KeyValue]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.KeyValue]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_azure_app_configuration_get_revisions_request(
                    key=key,
                    label=label,
                    sync_token=sync_token,
                    after=after,
                    accept_datetime=accept_datetime,
                    select=select,
                    tags=tags,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.KeyValue], deserialized["items"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("@nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.Error, response.json())
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def check_revisions(
        self,
        *,
        key: Optional[str] = None,
        label: Optional[str] = None,
        sync_token: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, _models.ConfigurationSettingFields]]] = None,
        tags: Optional[List[str]] = None,
        **kwargs: Any
    ) -> bool:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :keyword key: A filter used to match keys. Syntax reference:
         https://aka.ms/azconfig/docs/restapirevisions. Default value is None.
        :paramtype key: str
        :keyword label: A filter used to match labels. Syntax reference:
         https://aka.ms/azconfig/docs/restapirevisions. Default value is None.
        :paramtype label: str
        :keyword sync_token: Used to guarantee real-time consistency between requests. Default value is
         None.
        :paramtype sync_token: str
        :keyword after: Instructs the server to return elements that appear after the element referred
         to by the specified token. Default value is None.
        :paramtype after: str
        :keyword accept_datetime: Requests the server to respond with the state of the resource at the
         specified
         time. Default value is None.
        :paramtype accept_datetime: str
        :keyword select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :paramtype select: list[str or ~azure.appconfiguration.models.ConfigurationSettingFields]
        :keyword tags: A filter used to query by tags. Syntax reference:
         https://aka.ms/azconfig/docs/restapirevisions. Default value is None.
        :paramtype tags: list[str]
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_azure_app_configuration_check_revisions_request(
            key=key,
            label=label,
            sync_token=sync_token,
            after=after,
            accept_datetime=accept_datetime,
            select=select,
            tags=tags,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.Error, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299
